/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;

public abstract class Configurator {
    private ClassLoader classLoader;
    private int periodicity = 0;
    private int cnt;
    private Exception lastExc = null;
    private static long MIN_MILLIS = 60000L;
    private static HashSet periodicities = new HashSet();
    private static Timer timer = null;
    private static TimerTask watcher = null;

    protected Configurator() {
        this(Thread.currentThread().getContextClassLoader());
    }

    protected Configurator(ClassLoader classLoader) {
        this.classLoader = classLoader != null ? classLoader : Thread.currentThread().getContextClassLoader();
    }

    public abstract void configure();

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader != null ? classLoader : Thread.currentThread().getContextClassLoader();
    }

    public int getPeriodicity() {
        return this.periodicity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setPeriodicity(int mins) {
        this.periodicity = mins;
        Class<Configurator> clazz = Configurator.class;
        synchronized (Configurator.class) {
            if (this.periodicity > 0) {
                periodicities.add(this);
                this.cnt = this.periodicity;
            } else {
                periodicities.remove(this);
            }
            if (periodicities.size() > 0) {
                if (timer == null) {
                    timer = new Timer();
                    watcher = new TimerTask(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            Class<Configurator> clazz = Configurator.class;
                            synchronized (Configurator.class) {
                                Iterator iter = periodicities.iterator();
                                while (iter.hasNext()) {
                                    ((Configurator)iter.next()).minutePassed();
                                }
                                // ** MonitorExit[var1_1] (shouldn't be in output)
                                return;
                            }
                        }
                    };
                    timer.schedule(watcher, 0L, MIN_MILLIS);
                }
            } else if (timer != null) {
                timer.cancel();
                timer = null;
                watcher.cancel();
                watcher = null;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public Exception getException() {
        return this.lastExc;
    }

    public void throwException() throws Exception {
        if (this.lastExc != null) {
            throw this.lastExc;
        }
    }

    protected void resetException() {
        this.lastExc = null;
    }

    protected void handleException(Exception exc) {
        this.lastExc = exc;
    }

    private synchronized void minutePassed() {
        if (--this.cnt == 0) {
            this.configure();
            this.cnt = this.periodicity;
        }
    }
}

