/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging.tools.lv;

import com.sap.tc.logging.ListFormatter;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.LogRecord;
import com.sap.tc.logging.exceptions.OpenException;
import com.sap.tc.logging.interfaces.ILoggingResultSet;
import com.sap.tc.logging.interfaces.IReadLog;
import com.sap.tc.logging.reader.ReadableLog;
import com.sap.tc.logging.tools.lv.LVException;
import com.sap.tc.logging.tools.lv.LVFormatter;
import com.sap.tc.logging.tools.lv.LVOptions;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;

class LVReader {
    private static final Location console = Location.getLocation("std", "tc~logging~java", "BC-JAS-ADM-LOG-API");
    private static final String LISTFORMATTER_VERSION_TAG = "#1.5";
    private static final String SPACE = " ";
    private static final int ALIGN_LEFT = 1;
    private static final int ALIGN_CENTER = 2;
    private static final int ALIGN_RIGHT = 3;
    private static final SimpleDateFormat timeFormatter = new SimpleDateFormat("HH:mm:ss.SSS");
    private static final SimpleDateFormat dateFormatter = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    private static final boolean debug = false;
    private LVOptions lvOptions = null;
    private boolean isStdOut = false;
    private boolean isStdError = false;
    private File[] logDirectory;
    private IReadLog[] file;
    private static PrintWriter out;
    private final ListFormatter formatter = new ListFormatter();

    public LVReader(LVOptions lvOptions) throws Exception {
        this.lvOptions = lvOptions;
        out = lvOptions.outSystem;
        this.init();
    }

    private void init() throws Exception {
        Vector<IReadLog> fileList = new Vector<IReadLog>();
        for (int i = 0; i < this.lvOptions.readFileName.length; ++i) {
            File logDirFile = new File(this.lvOptions.readFileName[i]);
            File[] fileForRead = null;
            fileForRead = logDirFile.exists() && logDirFile.isDirectory() ? logDirFile.listFiles(new LVFileFilter()) : new File[]{logDirFile};
            for (int fCnt = 0; fCnt < fileForRead.length; ++fCnt) {
                fileList.add(ReadableLog.createFileReadLog(fileForRead[fCnt].toString()));
            }
        }
        if (!fileList.isEmpty()) {
            this.file = fileList.toArray(new IReadLog[0]);
        }
        if (this.lvOptions.outFileName != null) {
            try {
                out = new PrintWriter(new BufferedWriter(new FileWriter(this.lvOptions.outFileName)));
            }
            catch (Throwable th) {
                throw new LVException("ASJ.log_api.000053", "Invalid {0} option: {1}!", new Object[]{"outfile", this.lvOptions.outFileName}, th);
            }
        }
    }

    public void read() throws LVException {
        String fileToOpen = null;
        try {
            for (int i = 0; i < this.file.length; ++i) {
                fileToOpen = this.file[i].getSource();
                this.file[i].open();
                if (this.lvOptions.isTail) {
                    this.file[i].moveToEOF();
                    continue;
                }
                this.file[i].moveToBOF();
            }
            while (true) {
                this.readRecords();
                if (this.lvOptions.isBatchMode) {
                    return;
                }
                Thread.sleep(400L);
            }
        }
        catch (OpenException ex) {
            throw new LVException("ASJ.log_api.000041", "File ''{0}'' could not be found or created!", new Object[]{fileToOpen}, (Throwable)ex);
        }
        catch (Exception ex) {
            throw new LVException("ASJ.log_api.000018", "Unexcepted error occured on {0}!", new Object[]{"LV Tool"}, (Throwable)ex);
        }
    }

    public LVOptions getLVOptions() {
        return this.lvOptions;
    }

    protected void setLVOptions(LVOptions lvOptions) {
        this.lvOptions = lvOptions;
    }

    public void readRecords() throws Exception {
        int i = 0;
        String fileIndex = null;
        ILoggingResultSet rs = null;
        for (i = 0; i < this.file.length; ++i) {
            if (this.lvOptions.isIndexed) {
                fileIndex = this.file.length > 1 ? "F:" + (i + 1) + "/" + this.file.length + " -" : null;
            }
            this.file[i].open();
            while (!this.file[i].isEOF()) {
                rs = this.file[i].readNext();
                if (rs.getSize() <= 0) continue;
                this.parseMSG(fileIndex, (LogRecord)rs.getResults().get(0), true);
            }
        }
    }

    private void parseMSG(String fileIndex, LogRecord record, boolean isLoggingAPI) throws Exception {
        if (record == null) {
            return;
        }
        if (isLoggingAPI) {
            isLoggingAPI = false;
        } else {
            record = this.isStdOut ? console.infoT("[stdout] " + record.getMsgClear()) : (this.isStdError ? console.errorT("[stderr] " + record.getMsgClear()) : console.infoT("[std] " + record.getMsgClear()));
        }
        this.printRecord(fileIndex, record);
    }

    void printRecord(String fileIndex, LogRecord record) throws Exception {
        Date date = record.getTime();
        boolean width = false;
        boolean printRec = true;
        if (this.lvOptions.filSeverity > 0 && record.getSeverity() < this.lvOptions.filSeverity) {
            return;
        }
        if (this.lvOptions.filDate != null && date.compareTo(dateFormatter.parse(this.lvOptions.filDate)) < 0) {
            return;
        }
        if (this.lvOptions.filLocation != null && !record.getLocationName().equalsIgnoreCase(this.lvOptions.filLocation)) {
            return;
        }
        if (this.lvOptions.filCategory != null && !LVFormatter.getCategory(record).equalsIgnoreCase(this.lvOptions.filCategory)) {
            return;
        }
        StringBuffer buf = new StringBuffer(this.lvOptions.format);
        int patternLen = this.lvOptions.format.length();
        if (fileIndex != null) {
            out.print(LVFormatter.printString(fileIndex, 9, 1));
        }
        out.println(this.lvOptions.formatter.format(record));
        out.flush();
    }

    class LVFileFilter
    implements FileFilter {
        LVFileFilter() {
        }

        public boolean accept(File pathname) {
            return !pathname.exists() || pathname.isFile();
        }
    }
}

