/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapExtensionReader {
    private static final Logger logger = LoggerFactory.getLogger(MapExtensionReader.class);
    private final ByteBuffer rawData;

    public MapExtensionReader(ByteBuffer rawData) {
        this.rawData = ((ByteBuffer)Preconditions.checkNotNull((Object)rawData)).slice().order(ByteOrder.LITTLE_ENDIAN);
    }

    public Map<String, String> parse() {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        int numElements = this.parseInt();
        Preconditions.checkArgument((numElements >= 0 ? 1 : 0) != 0);
        for (int i = 0; i < numElements; ++i) {
            try {
                String key = this.parseString();
                String value = this.parseString();
                builder.put((Object)key, (Object)value);
                continue;
            }
            catch (UnsupportedEncodingException ex) {
                logger.warn("Encoding exception while parsing extension map metadata", (Throwable)ex);
            }
        }
        return builder.build();
    }

    private String parseString() throws UnsupportedEncodingException {
        int length = this.parseInt();
        byte[] rawString = new byte[length];
        this.rawData.get(rawString);
        return new String(rawString, "UTF-8");
    }

    private int parseInt() {
        return this.rawData.getInt();
    }
}

