/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.net.HostAndPort;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;

class ScyllaCloudDatacenter {
    private final String certificateAuthorityPath;
    private final byte[] certificateAuthorityData;
    private final String server;
    private final String tlsServerName;
    private final String nodeDomain;
    private final String proxyURL;
    private final boolean insecureSkipTlsVerify;
    private static final int NODE_DOMAIN_MAX_LENGTH = 218;

    @JsonCreator
    public ScyllaCloudDatacenter(@JsonProperty(value="certificateAuthorityPath") String certificateAuthorityPath, @JsonProperty(value="certificateAuthorityData") byte[] certificateAuthorityData, @JsonProperty(value="server") String server, @JsonProperty(value="tlsServerName") String tlsServerName, @JsonProperty(value="nodeDomain") String nodeDomain, @JsonProperty(value="proxyURL") String proxyURL, @JsonProperty(value="insecureSkipTlsVerify", defaultValue="false") boolean insecureSkipTlsVerify) {
        this.certificateAuthorityPath = certificateAuthorityPath;
        this.certificateAuthorityData = certificateAuthorityData;
        this.server = server;
        this.tlsServerName = tlsServerName;
        this.nodeDomain = nodeDomain;
        this.proxyURL = proxyURL;
        this.insecureSkipTlsVerify = insecureSkipTlsVerify;
    }

    public void validate() {
        if (this.certificateAuthorityData == null) {
            if (this.certificateAuthorityPath == null) {
                throw new IllegalArgumentException("Either certificateAuthorityData or certificateAuthorityPath must be provided for datacenter description.");
            }
            File file = new File(this.certificateAuthorityPath);
            if (!file.canRead()) {
                throw new IllegalArgumentException("Cannot read file at given certificateAuthorityPath (" + this.certificateAuthorityPath + ").");
            }
        }
        this.validateServer();
        this.validateNodeDomain();
    }

    public String getCertificateAuthorityPath() {
        return this.certificateAuthorityPath;
    }

    public byte[] getCertificateAuthorityData() {
        return this.certificateAuthorityData;
    }

    public InetSocketAddress getServer() {
        HostAndPort parsedServer = HostAndPort.fromString((String)this.server);
        return InetSocketAddress.createUnresolved(parsedServer.getHostText(), parsedServer.getPort());
    }

    public String getNodeDomain() {
        return this.nodeDomain;
    }

    public String getTlsServerName() {
        return this.tlsServerName;
    }

    public String getProxyURL() {
        return this.proxyURL;
    }

    public boolean isInsecureSkipTlsVerify() {
        return this.insecureSkipTlsVerify;
    }

    private void validateNodeDomain() {
        if (this.nodeDomain == null || this.nodeDomain.length() == 0) {
            throw new IllegalArgumentException("nodeDomain property is required in datacenter description.");
        }
        if (this.nodeDomain.length() > 218) {
            throw new IllegalArgumentException("Subdomain name too long (max 218): " + this.nodeDomain);
        }
        if (this.nodeDomain.contains(" ")) {
            throw new IllegalArgumentException("nodeDomain '" + this.nodeDomain + "' cannot contain spaces.");
        }
        if (this.nodeDomain.startsWith(".") || this.nodeDomain.endsWith(".")) {
            throw new IllegalArgumentException("nodeDomain '" + this.nodeDomain + "' cannot start or end with a dot.");
        }
        if (this.nodeDomain.endsWith("-")) {
            throw new IllegalArgumentException("nodeDomain '" + this.nodeDomain + "' cannot end with a minus sign.");
        }
        ImmutableList components = ImmutableList.copyOf((Object[])this.nodeDomain.split("\\."));
        for (String component : components) {
            if (component.length() == 0) {
                throw new IllegalArgumentException("nodeDomain '" + this.nodeDomain + "' cannot have empty components between dots.");
            }
            for (int index = 0; index < component.length(); ++index) {
                if (Character.isLetterOrDigit(component.charAt(index))) continue;
                if (component.charAt(index) == '-') {
                    if (index != 0 && index != component.length() - 1) continue;
                    throw new IllegalArgumentException("nodeDomain '" + this.nodeDomain + "' components can have minus sign only as interior character: " + component.charAt(index));
                }
                throw new IllegalArgumentException("nodeDomain '" + this.nodeDomain + "' contains illegal character: " + component.charAt(index));
            }
        }
    }

    private void validateServer() {
        if (this.server == null) {
            throw new IllegalArgumentException("server property is required in datacenter description.");
        }
        try {
            URL url = new URL("http://" + this.server);
            if (url.getPort() == -1) {
                throw new IllegalArgumentException("server property '" + this.server + "' does not contain a port.");
            }
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("server property '" + this.server + "' is not a valid URL", e);
        }
    }
}

