/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.utils.Bytes;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.primitives.UnsignedBytes;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Token
implements Comparable<Token> {
    public abstract DataType getType();

    public abstract Object getValue();

    public abstract ByteBuffer serialize(ProtocolVersion var1);

    static Factory getFactory(String partitionerName) {
        if (partitionerName.endsWith("Murmur3Partitioner")) {
            return M3PToken.FACTORY;
        }
        if (partitionerName.endsWith("CDCPartitioner")) {
            return CDCToken.FACTORY;
        }
        if (partitionerName.endsWith("RandomPartitioner")) {
            return RPToken.FACTORY;
        }
        if (partitionerName.endsWith("OrderedPartitioner")) {
            return OPPToken.FACTORY;
        }
        return null;
    }

    static class CDCToken
    extends TokenLong64 {
        private final long value;
        public static final Factory FACTORY = new CDCTokenFactory();
        private static final int CDC_PARTITION_KEY_LENGTH = 16;
        private static final long VERSION_MASK = 15L;
        private static final int MIN_SUPPORTED_VERSION = 1;
        private static final int MAX_SUPPORTED_VERSION = 1;

        private CDCToken(long value) {
            this.value = value;
        }

        @Override
        public DataType getType() {
            return FACTORY.getTokenType();
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public ByteBuffer serialize(ProtocolVersion protocolVersion) {
            return TypeCodec.bigint().serialize(this.value, protocolVersion);
        }

        public int hashCode() {
            return (int)(this.value ^ this.value >>> 32);
        }

        public String toString() {
            return Long.toString(this.value);
        }

        private static class CDCTokenFactory
        extends Factory {
            private static final Logger logger = LoggerFactory.getLogger(CDCTokenFactory.class);
            private static final BigInteger RING_END = BigInteger.valueOf(Long.MAX_VALUE);
            private static final BigInteger RING_LENGTH = RING_END.subtract(BigInteger.valueOf(Long.MIN_VALUE));
            static final CDCToken MIN_TOKEN = new CDCToken(Long.MIN_VALUE);
            static final CDCToken MAX_TOKEN = new CDCToken(Long.MAX_VALUE);

            private CDCTokenFactory() {
            }

            @Override
            CDCToken fromString(String tokenStr) {
                return new CDCToken(Long.parseLong(tokenStr));
            }

            @Override
            DataType getTokenType() {
                return DataType.bigint();
            }

            @Override
            Token deserialize(ByteBuffer buffer, ProtocolVersion protocolVersion) {
                return new CDCToken(TypeCodec.bigint().deserialize(buffer, protocolVersion));
            }

            @Override
            Token minToken() {
                return MIN_TOKEN;
            }

            @Override
            CDCToken hash(ByteBuffer partitionKey) {
                int offset = partitionKey.position();
                int length = partitionKey.remaining();
                if (length != 16) {
                    logger.warn("CDC partition key has invalid length: expected {} bytes, but got {} bytes", (Object)16, (Object)length);
                }
                if (length < 8) {
                    return MIN_TOKEN;
                }
                long upperDword = partitionKey.getLong(offset + 0);
                if (length != 16) {
                    return new CDCToken(upperDword);
                }
                long lowerDword = partitionKey.getLong(offset + 8);
                long version = lowerDword & 0xFL;
                if (version < 1L || version > 1L) {
                    logger.warn("CDC partition key version {} is not supported", (Object)version);
                }
                return new CDCToken(upperDword);
            }

            @Override
            List<Token> split(Token startToken, Token endToken, int numberOfSplits) {
                if (startToken.equals(endToken) && startToken.equals(MIN_TOKEN)) {
                    endToken = MAX_TOKEN;
                }
                BigInteger start = BigInteger.valueOf(((CDCToken)startToken).value);
                BigInteger end = BigInteger.valueOf(((CDCToken)endToken).value);
                BigInteger range = end.subtract(start);
                if (range.compareTo(BigInteger.ZERO) < 0) {
                    range = range.add(RING_LENGTH);
                }
                List<BigInteger> values = super.split(start, range, RING_END, RING_LENGTH, numberOfSplits);
                ArrayList tokens = Lists.newArrayListWithExpectedSize((int)values.size());
                for (BigInteger value : values) {
                    tokens.add(new CDCToken(value.longValue()));
                }
                return tokens;
            }
        }
    }

    static class RPToken
    extends Token {
        private final BigInteger value;
        public static final Factory FACTORY = new RPTokenFactory();

        private RPToken(BigInteger value) {
            this.value = value;
        }

        @Override
        public DataType getType() {
            return FACTORY.getTokenType();
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public ByteBuffer serialize(ProtocolVersion protocolVersion) {
            return TypeCodec.varint().serialize(this.value, protocolVersion);
        }

        @Override
        public int compareTo(Token other) {
            assert (other instanceof RPToken);
            return this.value.compareTo(((RPToken)other).value);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            return this.value.equals(((RPToken)obj).value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return this.value.toString();
        }

        private static class RPTokenFactory
        extends Factory {
            private static final BigInteger MIN_VALUE = BigInteger.ONE.negate();
            private static final BigInteger MAX_VALUE = BigInteger.valueOf(2L).pow(127);
            private static final BigInteger RING_LENGTH = MAX_VALUE.add(BigInteger.ONE);
            private static final Token MIN_TOKEN = new RPToken(MIN_VALUE);
            private static final Token MAX_TOKEN = new RPToken(MAX_VALUE);
            private final MessageDigest prototype = RPTokenFactory.createMessageDigest();
            private final boolean supportsClone;

            private RPTokenFactory() {
                boolean supportsClone;
                try {
                    this.prototype.clone();
                    supportsClone = true;
                }
                catch (CloneNotSupportedException e) {
                    supportsClone = false;
                }
                this.supportsClone = supportsClone;
            }

            private static MessageDigest createMessageDigest() {
                try {
                    return MessageDigest.getInstance("MD5");
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException("MD5 doesn't seem to be available on this JVM", e);
                }
            }

            private MessageDigest newMessageDigest() {
                if (this.supportsClone) {
                    try {
                        return (MessageDigest)this.prototype.clone();
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        // empty catch block
                    }
                }
                return RPTokenFactory.createMessageDigest();
            }

            private BigInteger md5(ByteBuffer data) {
                MessageDigest digest = this.newMessageDigest();
                digest.update(data.duplicate());
                return new BigInteger(digest.digest()).abs();
            }

            @Override
            RPToken fromString(String tokenStr) {
                return new RPToken(new BigInteger(tokenStr));
            }

            @Override
            DataType getTokenType() {
                return DataType.varint();
            }

            @Override
            Token deserialize(ByteBuffer buffer, ProtocolVersion protocolVersion) {
                return new RPToken(TypeCodec.varint().deserialize(buffer, protocolVersion));
            }

            @Override
            Token minToken() {
                return MIN_TOKEN;
            }

            @Override
            RPToken hash(ByteBuffer partitionKey) {
                return new RPToken(this.md5(partitionKey));
            }

            @Override
            List<Token> split(Token startToken, Token endToken, int numberOfSplits) {
                if (startToken.equals(endToken) && startToken.equals(MIN_TOKEN)) {
                    endToken = MAX_TOKEN;
                }
                BigInteger start = ((RPToken)startToken).value;
                BigInteger end = ((RPToken)endToken).value;
                BigInteger range = end.subtract(start);
                if (range.compareTo(BigInteger.ZERO) < 0) {
                    range = range.add(RING_LENGTH);
                }
                List<BigInteger> values = super.split(start, range, MAX_VALUE, RING_LENGTH, numberOfSplits);
                ArrayList tokens = Lists.newArrayListWithExpectedSize((int)values.size());
                for (BigInteger value : values) {
                    tokens.add(new RPToken(value));
                }
                return tokens;
            }
        }
    }

    static class OPPToken
    extends Token {
        private final ByteBuffer value;
        public static final Factory FACTORY = new OPPTokenFactory();

        @VisibleForTesting
        OPPToken(ByteBuffer value) {
            this.value = value;
        }

        @Override
        public DataType getType() {
            return FACTORY.getTokenType();
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public ByteBuffer serialize(ProtocolVersion protocolVersion) {
            return TypeCodec.blob().serialize(this.value, protocolVersion);
        }

        @Override
        public int compareTo(Token other) {
            assert (other instanceof OPPToken);
            return UnsignedBytes.lexicographicalComparator().compare(Bytes.getArray(this.value), Bytes.getArray(((OPPToken)other).value));
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            return this.value.equals(((OPPToken)obj).value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return Bytes.toHexString(this.value);
        }

        private static class OPPTokenFactory
        extends Factory {
            private static final BigInteger TWO = BigInteger.valueOf(2L);
            private static final Token MIN_TOKEN = new OPPToken(ByteBuffer.allocate(0));

            private OPPTokenFactory() {
            }

            @Override
            public OPPToken fromString(String tokenStr) {
                if (!tokenStr.startsWith("0x")) {
                    String prefix = tokenStr.length() % 2 == 0 ? "0x" : "0x0";
                    tokenStr = prefix + tokenStr;
                }
                ByteBuffer value = Bytes.fromHexString(tokenStr);
                return new OPPToken(value);
            }

            @Override
            DataType getTokenType() {
                return DataType.blob();
            }

            @Override
            Token deserialize(ByteBuffer buffer, ProtocolVersion protocolVersion) {
                return new OPPToken(buffer);
            }

            @Override
            Token minToken() {
                return MIN_TOKEN;
            }

            @Override
            OPPToken hash(ByteBuffer partitionKey) {
                return new OPPToken(partitionKey);
            }

            @Override
            List<Token> split(Token startToken, Token endToken, int numberOfSplits) {
                BigInteger ringEnd;
                BigInteger ringLength;
                BigInteger range;
                BigInteger end;
                BigInteger start;
                int addedBytes;
                int significantBytes;
                int tokenOrder = startToken.compareTo(endToken);
                if (tokenOrder == 0 && startToken.equals(MIN_TOKEN)) {
                    throw new IllegalArgumentException("Cannot split whole ring with ordered partitioner");
                }
                OPPToken oppStartToken = (OPPToken)startToken;
                OPPToken oppEndToken = (OPPToken)endToken;
                BigInteger bigNumberOfSplits = BigInteger.valueOf(numberOfSplits);
                if (tokenOrder < 0) {
                    significantBytes = Math.max(oppStartToken.value.capacity(), oppEndToken.value.capacity());
                    addedBytes = 0;
                    while (true) {
                        start = this.toBigInteger(oppStartToken.value, significantBytes);
                        end = this.toBigInteger(oppEndToken.value, significantBytes);
                        range = end.subtract(start);
                        if (addedBytes == 4 || start.equals(end) || range.compareTo(bigNumberOfSplits) >= 0) break;
                        ++significantBytes;
                        ++addedBytes;
                    }
                    ringLength = null;
                    ringEnd = null;
                } else {
                    significantBytes = Math.max(oppStartToken.value.capacity(), oppEndToken.value.capacity());
                    addedBytes = 0;
                    while (true) {
                        start = this.toBigInteger(oppStartToken.value, significantBytes);
                        end = this.toBigInteger(oppEndToken.value, significantBytes);
                        ringLength = TWO.pow(significantBytes * 8);
                        ringEnd = ringLength.subtract(BigInteger.ONE);
                        range = end.subtract(start).add(ringLength);
                        if (addedBytes == 4 || range.compareTo(bigNumberOfSplits) >= 0) break;
                        ++significantBytes;
                        ++addedBytes;
                    }
                }
                List<BigInteger> values = super.split(start, range, ringEnd, ringLength, numberOfSplits);
                ArrayList tokens = Lists.newArrayListWithExpectedSize((int)values.size());
                for (BigInteger value : values) {
                    tokens.add(new OPPToken(this.toBytes(value, significantBytes)));
                }
                return tokens;
            }

            private BigInteger toBigInteger(ByteBuffer bb, int significantBytes) {
                byte[] target;
                byte[] bytes = Bytes.getArray(bb);
                if (significantBytes != bytes.length) {
                    target = new byte[significantBytes];
                    System.arraycopy(bytes, 0, target, 0, bytes.length);
                } else {
                    target = bytes;
                }
                return new BigInteger(1, target);
            }

            protected ByteBuffer toBytes(BigInteger value, int significantBytes) {
                byte[] result;
                byte[] rawBytes = value.toByteArray();
                if (rawBytes.length == significantBytes) {
                    result = rawBytes;
                } else {
                    int length;
                    int start;
                    result = new byte[significantBytes];
                    if (rawBytes[0] == 0) {
                        start = 1;
                        length = rawBytes.length - 1;
                    } else {
                        start = 0;
                        length = rawBytes.length;
                    }
                    System.arraycopy(rawBytes, start, result, significantBytes - length, length);
                }
                return ByteBuffer.wrap(result);
            }
        }
    }

    static class M3PToken
    extends TokenLong64 {
        private final long value;
        public static final Factory FACTORY = new M3PTokenFactory();

        private M3PToken(long value) {
            this.value = value;
        }

        @Override
        public DataType getType() {
            return FACTORY.getTokenType();
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public ByteBuffer serialize(ProtocolVersion protocolVersion) {
            return TypeCodec.bigint().serialize(this.value, protocolVersion);
        }

        public int hashCode() {
            return (int)(this.value ^ this.value >>> 32);
        }

        public String toString() {
            return Long.toString(this.value);
        }

        private static class M3PTokenFactory
        extends Factory {
            private static final BigInteger RING_END = BigInteger.valueOf(Long.MAX_VALUE);
            private static final BigInteger RING_LENGTH = RING_END.subtract(BigInteger.valueOf(Long.MIN_VALUE));
            static final M3PToken MIN_TOKEN = new M3PToken(Long.MIN_VALUE);
            static final M3PToken MAX_TOKEN = new M3PToken(Long.MAX_VALUE);

            private M3PTokenFactory() {
            }

            private long getblock(ByteBuffer key, int offset, int index) {
                int i_8 = index << 3;
                int blockOffset = offset + i_8;
                return ((long)key.get(blockOffset + 0) & 0xFFL) + (((long)key.get(blockOffset + 1) & 0xFFL) << 8) + (((long)key.get(blockOffset + 2) & 0xFFL) << 16) + (((long)key.get(blockOffset + 3) & 0xFFL) << 24) + (((long)key.get(blockOffset + 4) & 0xFFL) << 32) + (((long)key.get(blockOffset + 5) & 0xFFL) << 40) + (((long)key.get(blockOffset + 6) & 0xFFL) << 48) + (((long)key.get(blockOffset + 7) & 0xFFL) << 56);
            }

            private long rotl64(long v, int n) {
                return v << n | v >>> 64 - n;
            }

            private long fmix(long k) {
                k ^= k >>> 33;
                k *= -49064778989728563L;
                k ^= k >>> 33;
                k *= -4265267296055464877L;
                k ^= k >>> 33;
                return k;
            }

            private long murmur(ByteBuffer data) {
                int offset = data.position();
                int length = data.remaining();
                int nblocks = length >> 4;
                long h1 = 0L;
                long h2 = 0L;
                long c1 = -8663945395140668459L;
                long c2 = 5545529020109919103L;
                for (int i = 0; i < nblocks; ++i) {
                    long k1 = this.getblock(data, offset, i * 2 + 0);
                    long k2 = this.getblock(data, offset, i * 2 + 1);
                    k1 *= c1;
                    k1 = this.rotl64(k1, 31);
                    h1 ^= (k1 *= c2);
                    h1 = this.rotl64(h1, 27);
                    h1 += h2;
                    h1 = h1 * 5L + 1390208809L;
                    k2 *= c2;
                    k2 = this.rotl64(k2, 33);
                    h2 ^= (k2 *= c1);
                    h2 = this.rotl64(h2, 31);
                    h2 += h1;
                    h2 = h2 * 5L + 944331445L;
                }
                offset += nblocks * 16;
                long k1 = 0L;
                long k2 = 0L;
                switch (length & 0xF) {
                    case 15: {
                        k2 ^= (long)data.get(offset + 14) << 48;
                    }
                    case 14: {
                        k2 ^= (long)data.get(offset + 13) << 40;
                    }
                    case 13: {
                        k2 ^= (long)data.get(offset + 12) << 32;
                    }
                    case 12: {
                        k2 ^= (long)data.get(offset + 11) << 24;
                    }
                    case 11: {
                        k2 ^= (long)data.get(offset + 10) << 16;
                    }
                    case 10: {
                        k2 ^= (long)data.get(offset + 9) << 8;
                    }
                    case 9: {
                        k2 ^= (long)data.get(offset + 8) << 0;
                        k2 *= c2;
                        k2 = this.rotl64(k2, 33);
                        h2 ^= (k2 *= c1);
                    }
                    case 8: {
                        k1 ^= (long)data.get(offset + 7) << 56;
                    }
                    case 7: {
                        k1 ^= (long)data.get(offset + 6) << 48;
                    }
                    case 6: {
                        k1 ^= (long)data.get(offset + 5) << 40;
                    }
                    case 5: {
                        k1 ^= (long)data.get(offset + 4) << 32;
                    }
                    case 4: {
                        k1 ^= (long)data.get(offset + 3) << 24;
                    }
                    case 3: {
                        k1 ^= (long)data.get(offset + 2) << 16;
                    }
                    case 2: {
                        k1 ^= (long)data.get(offset + 1) << 8;
                    }
                    case 1: {
                        k1 ^= (long)data.get(offset);
                        k1 *= c1;
                        k1 = this.rotl64(k1, 31);
                        h1 ^= (k1 *= c2);
                    }
                }
                h1 ^= (long)length;
                h1 += (h2 ^= (long)length);
                h2 += h1;
                h1 = this.fmix(h1);
                h2 = this.fmix(h2);
                h1 += h2;
                h2 += h1;
                return h1;
            }

            @Override
            M3PToken fromString(String tokenStr) {
                return new M3PToken(Long.parseLong(tokenStr));
            }

            @Override
            DataType getTokenType() {
                return DataType.bigint();
            }

            @Override
            Token deserialize(ByteBuffer buffer, ProtocolVersion protocolVersion) {
                return new M3PToken(TypeCodec.bigint().deserialize(buffer, protocolVersion));
            }

            @Override
            Token minToken() {
                return MIN_TOKEN;
            }

            @Override
            M3PToken hash(ByteBuffer partitionKey) {
                long v = this.murmur(partitionKey);
                return new M3PToken(v == Long.MIN_VALUE ? Long.MAX_VALUE : v);
            }

            @Override
            List<Token> split(Token startToken, Token endToken, int numberOfSplits) {
                if (startToken.equals(endToken) && startToken.equals(MIN_TOKEN)) {
                    endToken = MAX_TOKEN;
                }
                BigInteger start = BigInteger.valueOf(((M3PToken)startToken).value);
                BigInteger end = BigInteger.valueOf(((M3PToken)endToken).value);
                BigInteger range = end.subtract(start);
                if (range.compareTo(BigInteger.ZERO) < 0) {
                    range = range.add(RING_LENGTH);
                }
                List<BigInteger> values = super.split(start, range, RING_END, RING_LENGTH, numberOfSplits);
                ArrayList tokens = Lists.newArrayListWithExpectedSize((int)values.size());
                for (BigInteger value : values) {
                    tokens.add(new M3PToken(value.longValue()));
                }
                return tokens;
            }
        }
    }

    static abstract class TokenLong64
    extends Token {
        TokenLong64() {
        }

        @Override
        public int compareTo(Token other) {
            assert (other instanceof TokenLong64);
            Long value = (Long)this.getValue();
            Long otherValue = (Long)other.getValue();
            return value.compareTo(otherValue);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TokenLong64)) {
                return false;
            }
            return this.getValue().equals(((TokenLong64)obj).getValue());
        }
    }

    static abstract class Factory {
        Factory() {
        }

        abstract Token fromString(String var1);

        abstract DataType getTokenType();

        abstract Token deserialize(ByteBuffer var1, ProtocolVersion var2);

        abstract Token minToken();

        abstract Token hash(ByteBuffer var1);

        abstract List<Token> split(Token var1, Token var2, int var3);

        protected List<BigInteger> split(BigInteger start, BigInteger range, BigInteger ringEnd, BigInteger ringLength, int numberOfSplits) {
            BigInteger[] tmp = range.divideAndRemainder(BigInteger.valueOf(numberOfSplits));
            BigInteger divider = tmp[0];
            int remainder = tmp[1].intValue();
            ArrayList results = Lists.newArrayListWithExpectedSize((int)(numberOfSplits - 1));
            BigInteger current = start;
            BigInteger dividerPlusOne = remainder == 0 ? null : divider.add(BigInteger.ONE);
            for (int i = 1; i < numberOfSplits; ++i) {
                current = current.add(remainder-- > 0 ? dividerPlusOne : divider);
                if (ringEnd != null && current.compareTo(ringEnd) > 0) {
                    current = current.subtract(ringLength);
                }
                results.add(current);
            }
            return results;
        }
    }
}

