/*
 * Decompiled with CFR 0.152.
 */
package shaded.sasdk.org.apache.http.impl.cookie;

import java.util.Date;
import shaded.sasdk.org.apache.http.annotation.Immutable;
import shaded.sasdk.org.apache.http.client.utils.DateUtils;
import shaded.sasdk.org.apache.http.cookie.MalformedCookieException;
import shaded.sasdk.org.apache.http.cookie.SetCookie;
import shaded.sasdk.org.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import shaded.sasdk.org.apache.http.util.Args;

@Immutable
public class BasicExpiresHandler
extends AbstractCookieAttributeHandler {
    private final String[] datepatterns;

    public BasicExpiresHandler(String[] datepatterns) {
        Args.notNull(datepatterns, "Array of date patterns");
        this.datepatterns = datepatterns;
    }

    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for expires attribute");
        }
        Date expiry = DateUtils.parseDate(value, this.datepatterns);
        if (expiry == null) {
            throw new MalformedCookieException("Unable to parse expires attribute: " + value);
        }
        cookie.setExpiryDate(expiry);
    }
}

