/*
 * Decompiled with CFR 0.152.
 */
package shaded.sasdk.org.apache.http.message;

import java.io.Serializable;
import shaded.sasdk.org.apache.http.ProtocolVersion;
import shaded.sasdk.org.apache.http.StatusLine;
import shaded.sasdk.org.apache.http.annotation.Immutable;
import shaded.sasdk.org.apache.http.message.BasicLineFormatter;
import shaded.sasdk.org.apache.http.util.Args;

@Immutable
public class BasicStatusLine
implements StatusLine,
Cloneable,
Serializable {
    private static final long serialVersionUID = -2443303766890459269L;
    private final ProtocolVersion protoVersion;
    private final int statusCode;
    private final String reasonPhrase;

    public BasicStatusLine(ProtocolVersion version, int statusCode, String reasonPhrase) {
        this.protoVersion = Args.notNull(version, "Version");
        this.statusCode = Args.notNegative(statusCode, "Status code");
        this.reasonPhrase = reasonPhrase;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public ProtocolVersion getProtocolVersion() {
        return this.protoVersion;
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public String toString() {
        return BasicLineFormatter.INSTANCE.formatStatusLine(null, this).toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

