/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.javasdk;

import com.sensorsdata.analytics.javasdk.exceptions.DebugModeException;
import com.sensorsdata.analytics.javasdk.exceptions.InvalidArgumentException;
import com.sensorsdata.analytics.javasdk.util.Base64Coder;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import shaded.sasdk.com.fasterxml.jackson.core.JsonProcessingException;
import shaded.sasdk.com.fasterxml.jackson.databind.DeserializationFeature;
import shaded.sasdk.com.fasterxml.jackson.databind.ObjectMapper;
import shaded.sasdk.com.fasterxml.jackson.databind.PropertyNamingStrategy;
import shaded.sasdk.org.apache.http.NameValuePair;
import shaded.sasdk.org.apache.http.client.entity.UrlEncodedFormEntity;
import shaded.sasdk.org.apache.http.client.methods.CloseableHttpResponse;
import shaded.sasdk.org.apache.http.client.methods.HttpPost;
import shaded.sasdk.org.apache.http.client.methods.HttpUriRequest;
import shaded.sasdk.org.apache.http.client.utils.URIBuilder;
import shaded.sasdk.org.apache.http.impl.client.CloseableHttpClient;
import shaded.sasdk.org.apache.http.impl.client.HttpClients;
import shaded.sasdk.org.apache.http.message.BasicNameValuePair;
import shaded.sasdk.org.apache.http.util.EntityUtils;

public class SensorsAnalytics {
    private boolean enableTimeFree = false;
    private static final String SDK_VERSION = "3.1.17";
    private static final Pattern KEY_PATTERN = Pattern.compile("^((?!^distinct_id$|^original_id$|^time$|^properties$|^id$|^first_id$|^second_id$|^users$|^events$|^event$|^user_id$|^date$|^datetime$)[a-zA-Z_$][a-zA-Z\\d_$]{0,99})$", 2);
    private final Consumer consumer;
    private final Map<String, Object> superProperties;

    public boolean isEnableTimeFree() {
        return this.enableTimeFree;
    }

    public void setEnableTimeFree(boolean enableTimeFree) {
        this.enableTimeFree = enableTimeFree;
    }

    public SensorsAnalytics(Consumer consumer) {
        this.consumer = consumer;
        this.superProperties = new ConcurrentHashMap<String, Object>();
        this.clearSuperProperties();
    }

    public void registerSuperProperties(Map<String, Object> superPropertiesMap) {
        for (Map.Entry<String, Object> item : superPropertiesMap.entrySet()) {
            this.superProperties.put(item.getKey(), item.getValue());
        }
    }

    public void clearSuperProperties() {
        this.superProperties.clear();
        this.superProperties.put("$lib", "Java");
        this.superProperties.put("$lib_version", SDK_VERSION);
    }

    public void track(String distinctId, boolean isLoginId, String eventName) throws InvalidArgumentException {
        this.addEvent(distinctId, isLoginId, null, "track", eventName, null);
    }

    public void track(String distinctId, boolean isLoginId, String eventName, Map<String, Object> properties) throws InvalidArgumentException {
        this.addEvent(distinctId, isLoginId, null, "track", eventName, properties);
    }

    public void trackSignUp(String loginId, String anonymousId) throws InvalidArgumentException {
        this.addEvent(loginId, false, anonymousId, "track_signup", "$SignUp", null);
    }

    public void trackSignUp(String loginId, String anonymousId, Map<String, Object> properties) throws InvalidArgumentException {
        this.addEvent(loginId, false, anonymousId, "track_signup", "$SignUp", properties);
    }

    public void profileSet(String distinctId, boolean isLoginId, Map<String, Object> properties) throws InvalidArgumentException {
        this.addEvent(distinctId, isLoginId, null, "profile_set", null, properties);
    }

    public void profileSet(String distinctId, boolean isLoginId, String property, Object value) throws InvalidArgumentException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(property, value);
        this.addEvent(distinctId, isLoginId, null, "profile_set", null, properties);
    }

    public void profileSetOnce(String distinctId, boolean isLoginId, Map<String, Object> properties) throws InvalidArgumentException {
        this.addEvent(distinctId, isLoginId, null, "profile_set_once", null, properties);
    }

    public void profileSetOnce(String distinctId, boolean isLoginId, String property, Object value) throws InvalidArgumentException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(property, value);
        this.addEvent(distinctId, isLoginId, null, "profile_set_once", null, properties);
    }

    public void profileIncrement(String distinctId, boolean isLoginId, Map<String, Object> properties) throws InvalidArgumentException {
        this.addEvent(distinctId, isLoginId, null, "profile_increment", null, properties);
    }

    public void profileIncrement(String distinctId, boolean isLoginId, String property, long value) throws InvalidArgumentException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(property, value);
        this.addEvent(distinctId, isLoginId, null, "profile_increment", null, properties);
    }

    public void profileAppend(String distinctId, boolean isLoginId, Map<String, Object> properties) throws InvalidArgumentException {
        this.addEvent(distinctId, isLoginId, null, "profile_append", null, properties);
    }

    public void profileAppend(String distinctId, boolean isLoginId, String property, String value) throws InvalidArgumentException {
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(property, values);
        this.addEvent(distinctId, isLoginId, null, "profile_append", null, properties);
    }

    public void profileUnset(String distinctId, boolean isLoginId, String property) throws InvalidArgumentException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(property, true);
        this.addEvent(distinctId, isLoginId, null, "profile_unset", null, properties);
    }

    public void profileUnset(String distinctId, boolean isLoginId, Map<String, Object> properties) throws InvalidArgumentException {
        if (properties == null) {
            return;
        }
        for (Map.Entry<String, Object> property : properties.entrySet()) {
            boolean value;
            if ("$project".equals(property.getKey()) || property.getValue() instanceof Boolean && (value = ((Boolean)property.getValue()).booleanValue())) continue;
            throw new InvalidArgumentException("The property value of " + property.getKey() + " should be true.");
        }
        this.addEvent(distinctId, isLoginId, null, "profile_unset", null, properties);
    }

    public void profileDelete(String distinctId, boolean isLoginId) throws InvalidArgumentException {
        this.addEvent(distinctId, isLoginId, null, "profile_delete", null, new HashMap<String, Object>());
    }

    public void itemSet(String itemType, String itemId, Map<String, Object> properties) throws InvalidArgumentException {
        this.addItem(itemType, itemId, "item_set", properties);
    }

    public void itemDelete(String itemType, String itemId, Map<String, Object> properties) throws InvalidArgumentException {
        this.addItem(itemType, itemId, "item_delete", properties);
    }

    public void flush() {
        this.consumer.flush();
    }

    public void shutdown() {
        this.consumer.close();
    }

    private void addEvent(String distinctId, boolean isLoginId, String originDistinctId, String actionType, String eventName, Map<String, Object> properties) throws InvalidArgumentException {
        this.assertKey("Distinct Id", distinctId);
        this.assertProperties(actionType, properties);
        if (actionType.equals("track")) {
            this.assertKeyWithRegex("Event Name", eventName);
        } else if (actionType.equals("track_signup")) {
            this.assertKey("Original Distinct Id", originDistinctId);
        }
        long time = System.currentTimeMillis();
        HashMap<String, Object> newProperties = null;
        if (properties != null) {
            newProperties = new HashMap<String, Object>(properties);
        }
        if (newProperties != null && newProperties.containsKey("$time")) {
            Date eventTime = (Date)newProperties.get("$time");
            newProperties.remove("$time");
            time = eventTime.getTime();
        }
        String eventProject = null;
        String eventToken = null;
        if (newProperties != null) {
            if (newProperties.containsKey("$project")) {
                eventProject = (String)newProperties.get("$project");
                newProperties.remove("$project");
            }
            if (newProperties.containsKey("$token")) {
                eventToken = (String)newProperties.get("$token");
                newProperties.remove("$token");
            }
        }
        HashMap<String, Object> eventProperties = new HashMap<String, Object>();
        if (actionType.equals("track") || actionType.equals("track_signup")) {
            eventProperties.putAll(this.superProperties);
        }
        if (newProperties != null) {
            eventProperties.putAll(newProperties);
        }
        if (isLoginId) {
            eventProperties.put("$is_login_id", true);
        }
        Map<String, String> libProperties = this.getLibProperties();
        HashMap<String, Object> event = new HashMap<String, Object>();
        event.put("type", actionType);
        event.put("time", time);
        event.put("distinct_id", distinctId);
        event.put("properties", eventProperties);
        event.put("lib", libProperties);
        event.put("_track_id", new Random().nextInt());
        if (eventProject != null) {
            event.put("project", eventProject);
        }
        if (eventToken != null) {
            event.put("token", eventToken);
        }
        if (this.enableTimeFree) {
            event.put("time_free", true);
        }
        if (actionType.equals("track")) {
            event.put("event", eventName);
        } else if (actionType.equals("track_signup")) {
            event.put("event", eventName);
            event.put("original_id", originDistinctId);
        }
        this.consumer.send(event);
    }

    private void addItem(String itemType, String itemId, String actionType, Map<String, Object> properties) throws InvalidArgumentException {
        this.assertKeyWithRegex("Item Type", itemType);
        this.assertKey("Item Id", itemId);
        this.assertProperties(actionType, properties);
        HashMap<String, Object> newProperties = null;
        if (properties != null) {
            newProperties = new HashMap<String, Object>(properties);
        }
        String eventProject = null;
        String eventToken = null;
        if (newProperties != null) {
            if (newProperties.containsKey("$project")) {
                eventProject = (String)newProperties.get("$project");
                newProperties.remove("$project");
            }
            if (newProperties.containsKey("$token")) {
                eventToken = (String)newProperties.get("$token");
                newProperties.remove("$token");
            }
        }
        HashMap<String, Object> eventProperties = new HashMap<String, Object>();
        if (newProperties != null) {
            eventProperties.putAll(newProperties);
        }
        Map<String, String> libProperties = this.getLibProperties();
        HashMap<String, Object> record = new HashMap<String, Object>();
        record.put("type", actionType);
        record.put("time", System.currentTimeMillis());
        record.put("properties", eventProperties);
        record.put("lib", libProperties);
        if (eventProject != null) {
            record.put("project", eventProject);
        }
        if (eventToken != null) {
            record.put("token", eventToken);
        }
        record.put("item_type", itemType);
        record.put("item_id", itemId);
        this.consumer.send(record);
    }

    private Map<String, String> getLibProperties() {
        StackTraceElement[] trace;
        HashMap<String, String> libProperties = new HashMap<String, String>();
        libProperties.put("$lib", "Java");
        libProperties.put("$lib_version", SDK_VERSION);
        libProperties.put("$lib_method", "code");
        if (this.superProperties.containsKey("$app_version")) {
            libProperties.put("$app_version", (String)this.superProperties.get("$app_version"));
        }
        if ((trace = new Exception().getStackTrace()).length > 3) {
            StackTraceElement traceElement = trace[3];
            libProperties.put("$lib_detail", String.format("%s##%s##%s##%s", traceElement.getClassName(), traceElement.getMethodName(), traceElement.getFileName(), traceElement.getLineNumber()));
        }
        return libProperties;
    }

    private void assertKey(String type, String key) throws InvalidArgumentException {
        if (key == null || key.length() < 1) {
            throw new InvalidArgumentException("The " + type + " is empty.");
        }
        if (key.length() > 255) {
            throw new InvalidArgumentException("The " + type + " is too long, max length is 255.");
        }
    }

    private void assertKeyWithRegex(String type, String key) throws InvalidArgumentException {
        this.assertKey(type, key);
        if (!KEY_PATTERN.matcher(key).matches()) {
            throw new InvalidArgumentException("The " + type + "'" + key + "' is invalid.");
        }
    }

    private void assertProperties(String eventType, Map<String, Object> properties) throws InvalidArgumentException {
        if (null == properties) {
            return;
        }
        for (Map.Entry<String, Object> property : properties.entrySet()) {
            String value;
            if (property.getKey().equals("$is_login_id")) {
                if (property.getValue() instanceof Boolean) continue;
                throw new InvalidArgumentException("The property value of '$is_login_id' should be Boolean.");
            }
            this.assertKeyWithRegex("property", property.getKey());
            if (!(property.getValue() instanceof Number || property.getValue() instanceof Date || property.getValue() instanceof String || property.getValue() instanceof Boolean || property.getValue() instanceof List)) {
                throw new InvalidArgumentException("The property '" + property.getKey() + "' should be a basic type: Number, String, Date, Boolean, List<String>.");
            }
            if (property.getKey().equals("$time") && !(property.getValue() instanceof Date)) {
                throw new InvalidArgumentException("The property '$time' should be a java.util.Date.");
            }
            if (property.getValue() instanceof List) {
                ListIterator<String> it = ((List)property.getValue()).listIterator();
                while (it.hasNext()) {
                    Object element = it.next();
                    if (!(element instanceof String)) {
                        throw new InvalidArgumentException("The property '" + property.getKey() + "' should be a list of String.");
                    }
                    if (((String)element).length() <= 8192) continue;
                    it.set(((String)element).substring(0, 8192));
                }
            }
            if (property.getValue() instanceof String && (value = (String)property.getValue()).length() > 8192) {
                property.setValue(value.substring(0, 8192));
            }
            if (eventType.equals("profile_increment")) {
                if (property.getValue() instanceof Number) continue;
                throw new InvalidArgumentException("The property value of PROFILE_INCREMENT should be a Number.");
            }
            if (!eventType.equals("profile_append") || property.getValue() instanceof List) continue;
            throw new InvalidArgumentException("The property value of PROFILE_INCREMENT should be a List<String>.");
        }
    }

    private static String strJoin(String[] arr, String sep) {
        StringBuilder sbStr = new StringBuilder();
        int il = arr.length;
        for (int i = 0; i < il; ++i) {
            if (i > 0) {
                sbStr.append(sep);
            }
            sbStr.append(arr[i]);
        }
        return sbStr.toString();
    }

    private static ObjectMapper getJsonObjectMapper() {
        ObjectMapper jsonObjectMapper = new ObjectMapper();
        jsonObjectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        jsonObjectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES);
        jsonObjectMapper.setTimeZone(TimeZone.getDefault());
        jsonObjectMapper.setDateFormat(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS"));
        return jsonObjectMapper;
    }

    private static class HttpConsumer
    implements Closeable {
        CloseableHttpClient httpClient;
        final String serverUrl;
        final Map<String, String> httpHeaders;
        final boolean compressData;

        HttpConsumer(String serverUrl, Map<String, String> httpHeaders) {
            this.serverUrl = serverUrl.trim();
            this.httpHeaders = httpHeaders;
            this.compressData = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void consume(String data) throws IOException, HttpConsumerException {
            HttpUriRequest request = this.getHttpRequest(data);
            CloseableHttpResponse response = null;
            if (this.httpClient == null) {
                this.httpClient = HttpClients.custom().setUserAgent("SensorsAnalytics Java SDK 3.1.17").build();
            }
            try {
                response = this.httpClient.execute(request);
                int httpStatusCode = response.getStatusLine().getStatusCode();
                if (httpStatusCode < 200 || httpStatusCode >= 300) {
                    String httpContent = new String(EntityUtils.toByteArray(response.getEntity()), "UTF-8");
                    throw new HttpConsumerException(String.format("Unexpected response %d from Sensors Analytics: %s", httpStatusCode, httpContent), data, httpStatusCode, httpContent);
                }
            }
            finally {
                if (response != null) {
                    response.close();
                }
            }
        }

        HttpUriRequest getHttpRequest(String data) throws IOException {
            HttpPost httpPost = new HttpPost(this.serverUrl);
            httpPost.setEntity(this.getHttpEntry(data));
            if (this.httpHeaders != null) {
                for (Map.Entry<String, String> entry : this.httpHeaders.entrySet()) {
                    httpPost.addHeader(entry.getKey(), entry.getValue());
                }
            }
            return httpPost;
        }

        UrlEncodedFormEntity getHttpEntry(String data) throws IOException {
            byte[] bytes = data.getBytes(Charset.forName("UTF-8"));
            ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
            if (this.compressData) {
                ByteArrayOutputStream os = new ByteArrayOutputStream(bytes.length);
                GZIPOutputStream gos = new GZIPOutputStream(os);
                gos.write(bytes);
                gos.close();
                byte[] compressed = os.toByteArray();
                os.close();
                nameValuePairs.add(new BasicNameValuePair("gzip", "1"));
                nameValuePairs.add(new BasicNameValuePair("data_list", new String(Base64Coder.encode(compressed))));
            } else {
                nameValuePairs.add(new BasicNameValuePair("gzip", "0"));
                nameValuePairs.add(new BasicNameValuePair("data_list", new String(Base64Coder.encode(bytes))));
            }
            return new UrlEncodedFormEntity((List<? extends NameValuePair>)nameValuePairs);
        }

        @Override
        public synchronized void close() {
            try {
                if (this.httpClient != null) {
                    this.httpClient.close();
                    this.httpClient = null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        static class HttpConsumerException
        extends Exception {
            final String sendingData;
            final int httpStatusCode;
            final String httpContent;

            HttpConsumerException(String error, String sendingData, int httpStatusCode, String httpContent) {
                super(error);
                this.sendingData = sendingData;
                this.httpStatusCode = httpStatusCode;
                this.httpContent = httpContent;
            }

            String getSendingData() {
                return this.sendingData;
            }

            int getHttpStatusCode() {
                return this.httpStatusCode;
            }

            String getHttpContent() {
                return this.httpContent;
            }
        }
    }

    public static enum LogSplitMode {
        DAY,
        HOUR;

    }

    static class InnerLoggingConsumer
    implements Consumer {
        private static final int BUFFER_LIMITATION = 0x40000000;
        private final ObjectMapper jsonMapper;
        private final String filenamePrefix;
        private final StringBuilder messageBuffer;
        private final int bufferSize;
        private final SimpleDateFormat simpleDateFormat;
        private final LoggingFileWriterFactory fileWriterFactory;
        private LoggingFileWriter fileWriter;

        public InnerLoggingConsumer(LoggingFileWriterFactory fileWriterFactory, String filenamePrefix, int bufferSize, LogSplitMode splitMode) throws IOException {
            this.fileWriterFactory = fileWriterFactory;
            this.filenamePrefix = filenamePrefix;
            this.jsonMapper = SensorsAnalytics.getJsonObjectMapper();
            this.messageBuffer = new StringBuilder(bufferSize);
            this.bufferSize = bufferSize;
            this.simpleDateFormat = splitMode == LogSplitMode.HOUR ? new SimpleDateFormat("yyyy-MM-dd-HH") : new SimpleDateFormat("yyyy-MM-dd");
        }

        @Override
        public synchronized void send(Map<String, Object> message) {
            if (this.messageBuffer.length() < 0x40000000) {
                try {
                    this.messageBuffer.append(this.jsonMapper.writeValueAsString(message));
                    this.messageBuffer.append("\n");
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException("fail to process json", e);
                }
            } else {
                throw new RuntimeException("logging buffer exceeded the allowed limitation.");
            }
            if (this.messageBuffer.length() >= this.bufferSize) {
                this.flush();
            }
        }

        private String constructFileName(Date now) {
            return this.filenamePrefix + "." + this.simpleDateFormat.format(now);
        }

        @Override
        public synchronized void flush() {
            if (this.messageBuffer.length() == 0) {
                return;
            }
            String filename = this.constructFileName(new Date());
            if (this.fileWriter != null && !this.fileWriter.isValid(filename)) {
                this.fileWriterFactory.closeFileWriter(this.fileWriter);
                this.fileWriter = null;
            }
            if (this.fileWriter == null) {
                try {
                    this.fileWriter = this.fileWriterFactory.getFileWriter(this.filenamePrefix, filename);
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.fileWriter.write(this.messageBuffer)) {
                this.messageBuffer.setLength(0);
            }
        }

        @Override
        public synchronized void close() {
            this.flush();
            if (this.fileWriter != null) {
                this.fileWriterFactory.closeFileWriter(this.fileWriter);
                this.fileWriter = null;
            }
        }
    }

    static interface LoggingFileWriterFactory {
        public LoggingFileWriter getFileWriter(String var1, String var2) throws FileNotFoundException;

        public void closeFileWriter(LoggingFileWriter var1);
    }

    static interface LoggingFileWriter {
        public boolean isValid(String var1);

        public boolean write(StringBuilder var1);

        public void close();
    }

    public static class ConcurrentLoggingConsumer
    extends InnerLoggingConsumer {
        public ConcurrentLoggingConsumer(String filenamePrefix) throws IOException {
            this(filenamePrefix, null);
        }

        public ConcurrentLoggingConsumer(String filenamePrefix, int bufferSize) throws IOException {
            this(filenamePrefix, null, bufferSize);
        }

        public ConcurrentLoggingConsumer(String filenamePrefix, String lockFileName) throws IOException {
            this(filenamePrefix, lockFileName, 8192);
        }

        public ConcurrentLoggingConsumer(String filenamePrefix, String lockFileName, int bufferSize) throws IOException {
            this(filenamePrefix, lockFileName, bufferSize, LogSplitMode.DAY);
        }

        public ConcurrentLoggingConsumer(String filenamePrefix, String lockFileName, int bufferSize, LogSplitMode splitMode) throws IOException {
            super(new InnerLoggingFileWriterFactory(lockFileName), filenamePrefix, bufferSize, splitMode);
        }

        static class InnerLoggingFileWriter
        implements LoggingFileWriter {
            private final String fileName;
            private final FileOutputStream outputStream;
            private final FileOutputStream lockStream;
            private int refCount;
            private static final Map<String, InnerLoggingFileWriter> instances = new HashMap<String, InnerLoggingFileWriter>();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            static InnerLoggingFileWriter getInstance(String fileName, String lockFileName) throws FileNotFoundException {
                Map<String, InnerLoggingFileWriter> map = instances;
                synchronized (map) {
                    if (!instances.containsKey(fileName)) {
                        instances.put(fileName, new InnerLoggingFileWriter(fileName, lockFileName));
                    }
                    InnerLoggingFileWriter writer = instances.get(fileName);
                    ++writer.refCount;
                    return writer;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            static void removeInstance(InnerLoggingFileWriter writer) {
                Map<String, InnerLoggingFileWriter> map = instances;
                synchronized (map) {
                    --writer.refCount;
                    if (writer.refCount == 0) {
                        writer.close();
                        instances.remove(writer.fileName);
                    }
                }
            }

            private InnerLoggingFileWriter(String fileName, String lockFileName) throws FileNotFoundException {
                this.outputStream = new FileOutputStream(fileName, true);
                this.lockStream = lockFileName != null ? new FileOutputStream(lockFileName, true) : this.outputStream;
                this.fileName = fileName;
                this.refCount = 0;
            }

            @Override
            public void close() {
                try {
                    this.outputStream.close();
                }
                catch (Exception e) {
                    throw new RuntimeException("fail to close output stream.", e);
                }
            }

            @Override
            public boolean isValid(String fileName) {
                return this.fileName.equals(fileName);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean write(StringBuilder sb) {
                FileOutputStream fileOutputStream = this.lockStream;
                synchronized (fileOutputStream) {
                    FileLock lock = null;
                    try {
                        FileChannel channel = this.lockStream.getChannel();
                        lock = channel.lock(0L, Long.MAX_VALUE, false);
                        this.outputStream.write(sb.toString().getBytes("UTF-8"));
                    }
                    catch (Exception e) {
                        throw new RuntimeException("fail to write file.", e);
                    }
                    finally {
                        if (lock != null) {
                            try {
                                lock.release();
                            }
                            catch (IOException e) {
                                throw new RuntimeException("fail to release file lock.", e);
                            }
                        }
                    }
                }
                return true;
            }
        }

        static class InnerLoggingFileWriterFactory
        implements LoggingFileWriterFactory {
            private String lockFileName;

            InnerLoggingFileWriterFactory(String lockFileName) {
                this.lockFileName = lockFileName;
            }

            @Override
            public LoggingFileWriter getFileWriter(String fileName, String scheduleFileName) throws FileNotFoundException {
                return InnerLoggingFileWriter.getInstance(scheduleFileName, this.lockFileName);
            }

            @Override
            public void closeFileWriter(LoggingFileWriter writer) {
                InnerLoggingFileWriter.removeInstance((InnerLoggingFileWriter)writer);
            }
        }
    }

    @Deprecated
    public static class LoggingConsumer
    extends InnerLoggingConsumer {
        public LoggingConsumer(String filenamePrefix) throws IOException {
            this(filenamePrefix, 8192);
        }

        public LoggingConsumer(String filenamePrefix, int bufferSize) throws IOException {
            super(new LoggingFileWriterFactory(){

                @Override
                public LoggingFileWriter getFileWriter(String fileName, String scheduleFileName) throws FileNotFoundException {
                    return new InnerLoggingFileWriter(fileName, scheduleFileName);
                }

                @Override
                public void closeFileWriter(LoggingFileWriter writer) {
                    writer.close();
                }
            }, filenamePrefix, bufferSize, LogSplitMode.DAY);
        }

        static class InnerLoggingFileWriter
        implements LoggingFileWriter {
            private final String fileName;
            private File outputFile;
            private FileOutputStream outputStream;
            private final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");

            InnerLoggingFileWriter(String fileName, String scheduleFileName) throws FileNotFoundException {
                String realFileName;
                this.outputFile = new File(fileName);
                this.fileName = scheduleFileName;
                if (this.outputFile.exists() && !(realFileName = fileName + "." + this.simpleDateFormat.format(this.outputFile.lastModified())).equals(this.fileName)) {
                    File target = new File(realFileName);
                    int count = 0;
                    while (target.exists()) {
                        target = new File(realFileName + "." + ++count);
                    }
                    if (!this.outputFile.renameTo(target)) {
                        throw new RuntimeException("Failed to rename [" + this.outputFile.getName() + "] to [" + target.getName() + "]");
                    }
                    this.outputFile = new File(fileName);
                }
                this.outputStream = new FileOutputStream(this.outputFile, true);
            }

            @Override
            public void close() {
                try {
                    this.outputStream.close();
                }
                catch (Exception e) {
                    throw new RuntimeException("fail to close output stream.", e);
                }
            }

            @Override
            public boolean isValid(String fileName) {
                return this.fileName.equals(fileName);
            }

            @Override
            public boolean write(StringBuilder sb) {
                FileLock lock = null;
                try {
                    FileChannel channel = this.outputStream.getChannel();
                    lock = channel.lock(0L, Long.MAX_VALUE, false);
                    this.outputStream.write(sb.toString().getBytes("UTF-8"));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    if (lock != null) {
                        try {
                            lock.release();
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
                return true;
            }
        }
    }

    public static class ConsoleConsumer
    implements Consumer {
        private final ObjectMapper jsonMapper = SensorsAnalytics.access$100();
        private final Writer writer;

        public ConsoleConsumer(Writer writer) {
            this.writer = writer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void send(Map<String, Object> message) {
            try {
                Writer writer = this.writer;
                synchronized (writer) {
                    this.writer.write(this.jsonMapper.writeValueAsString(message));
                    this.writer.write("\n");
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to dump message with ConsoleConsumer.", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() {
            Writer writer = this.writer;
            synchronized (writer) {
                try {
                    this.writer.flush();
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to flush with ConsoleConsumer.", e);
                }
            }
        }

        @Override
        public void close() {
            this.flush();
        }
    }

    @Deprecated
    public static class AsyncBatchConsumer
    implements Consumer {
        private static final int MAX_FLUSH_BULK_SIZE = 50;
        private final List<Map<String, Object>> messageList = new ArrayList<Map<String, Object>>();
        private final HttpConsumer httpConsumer;
        private final ObjectMapper jsonMapper;
        private final ThreadPoolExecutor executor;
        private final AsyncBatchConsumerCallback callback;
        private final int bulkSize;

        public AsyncBatchConsumer(String serverUrl, int bulkSize, ThreadPoolExecutor executor, AsyncBatchConsumerCallback callback) {
            this.httpConsumer = new HttpConsumer(serverUrl, null);
            this.jsonMapper = SensorsAnalytics.getJsonObjectMapper();
            this.bulkSize = Math.min(50, bulkSize);
            this.executor = executor;
            this.callback = callback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void send(Map<String, Object> message) {
            List<Map<String, Object>> list = this.messageList;
            synchronized (list) {
                this.messageList.add(message);
                if (this.messageList.size() >= this.bulkSize) {
                    this.flush();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() {
            List<Map<String, Object>> list = this.messageList;
            synchronized (list) {
                try {
                    final String sendingData = this.jsonMapper.writeValueAsString(this.messageList);
                    Future<Boolean> task = this.executor.submit(new Callable<Boolean>(){

                        @Override
                        public Boolean call() throws Exception {
                            int reties = 0;
                            while (reties < 5) {
                                try {
                                    AsyncBatchConsumer.this.httpConsumer.consume(sendingData);
                                    break;
                                }
                                catch (IOException e) {
                                    try {
                                        Thread.sleep(1000L);
                                    }
                                    catch (InterruptedException e1) {
                                        Thread.currentThread().interrupt();
                                    }
                                    ++reties;
                                }
                                catch (HttpConsumer.HttpConsumerException e) {
                                    try {
                                        Thread.sleep(1000L);
                                    }
                                    catch (InterruptedException e1) {
                                        Thread.currentThread().interrupt();
                                    }
                                    ++reties;
                                }
                            }
                            return reties < 5;
                        }
                    });
                    if (this.callback != null) {
                        this.callback.onFlushTask(task);
                    }
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    this.messageList.clear();
                }
            }
        }

        @Override
        public void close() {
            this.flush();
            this.httpConsumer.close();
            this.executor.shutdown();
            try {
                this.executor.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Deprecated
    public static interface AsyncBatchConsumerCallback {
        public void onFlushTask(Future<Boolean> var1);
    }

    public static class BatchConsumer
    implements Consumer {
        private static final int MAX_FLUSH_BULK_SIZE = 1000;
        private static final int MAX_CACHE_SIZE = 6000;
        private static final int MIN_CACHE_SIZE = 3000;
        private final List<Map<String, Object>> messageList = new LinkedList<Map<String, Object>>();
        private final HttpConsumer httpConsumer;
        private final ObjectMapper jsonMapper;
        private final int bulkSize;
        private final boolean throwException;
        private final int maxCacheSize;

        public BatchConsumer(String serverUrl) {
            this(serverUrl, 50);
        }

        public BatchConsumer(String serverUrl, int bulkSize) {
            this(serverUrl, bulkSize, false);
        }

        public BatchConsumer(String serverUrl, int bulkSize, boolean throwException) {
            this(serverUrl, bulkSize, 0, throwException);
        }

        public BatchConsumer(String serverUrl, int bulkSize, int maxCacheSize, boolean throwException) {
            this.httpConsumer = new HttpConsumer(serverUrl, null);
            this.jsonMapper = SensorsAnalytics.getJsonObjectMapper();
            this.bulkSize = Math.min(1000, bulkSize);
            this.maxCacheSize = maxCacheSize > 6000 ? 6000 : (maxCacheSize > 0 && maxCacheSize < 3000 ? 3000 : maxCacheSize);
            this.throwException = throwException;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void send(Map<String, Object> message) {
            List<Map<String, Object>> list = this.messageList;
            synchronized (list) {
                int size = this.messageList.size();
                if (this.maxCacheSize <= 0 || size < this.maxCacheSize) {
                    this.messageList.add(message);
                    ++size;
                }
                if (size >= this.bulkSize) {
                    this.flush();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() {
            List<Map<String, Object>> list = this.messageList;
            synchronized (list) {
                while (!this.messageList.isEmpty()) {
                    String sendingData = null;
                    List<Map<String, Object>> sendList = this.messageList.subList(0, Math.min(this.bulkSize, this.messageList.size()));
                    try {
                        sendingData = this.jsonMapper.writeValueAsString(sendList);
                    }
                    catch (JsonProcessingException e) {
                        sendList.clear();
                        if (!this.throwException) continue;
                        throw new RuntimeException("Failed to serialize data.", e);
                    }
                    try {
                        this.httpConsumer.consume(sendingData);
                        sendList.clear();
                    }
                    catch (Exception e) {
                        if (this.throwException) {
                            throw new RuntimeException("Failed to dump message with BatchConsumer.", e);
                        }
                        return;
                    }
                }
            }
        }

        @Override
        public void close() {
            this.flush();
            this.httpConsumer.close();
        }
    }

    public static class DebugConsumer
    implements Consumer {
        final HttpConsumer httpConsumer;
        final ObjectMapper jsonMapper;

        public DebugConsumer(String serverUrl, boolean writeData) {
            String debugUrl = null;
            try {
                URIBuilder builder = new URIBuilder(new URI(serverUrl));
                String[] urlPathes = builder.getPath().split("/");
                urlPathes[urlPathes.length - 1] = "debug";
                builder.setPath(SensorsAnalytics.strJoin(urlPathes, "/"));
                debugUrl = builder.build().toURL().toString();
            }
            catch (URISyntaxException e) {
                throw new DebugModeException(e);
            }
            catch (MalformedURLException e) {
                throw new DebugModeException(e);
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            if (!writeData) {
                headers.put("Dry-Run", "true");
            }
            this.httpConsumer = new HttpConsumer(debugUrl, headers);
            this.jsonMapper = SensorsAnalytics.getJsonObjectMapper();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void send(Map<String, Object> message) {
            ArrayList<Map<String, Object>> messageList = new ArrayList<Map<String, Object>>();
            messageList.add(message);
            String sendingData = null;
            try {
                sendingData = this.jsonMapper.writeValueAsString(messageList);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException("Failed to serialize data.", e);
            }
            System.out.println("==========================================================================");
            try {
                HttpConsumer e = this.httpConsumer;
                synchronized (e) {
                    this.httpConsumer.consume(sendingData);
                }
                System.out.println(String.format("valid message: %s", sendingData));
            }
            catch (IOException e) {
                throw new DebugModeException("Failed to send message with DebugConsumer.", e);
            }
            catch (HttpConsumer.HttpConsumerException e) {
                System.out.println(String.format("invalid message: %s", e.getSendingData()));
                System.out.println(String.format("http status code: %d", e.getHttpStatusCode()));
                System.out.println(String.format("http content: %s", e.getHttpContent()));
                throw new DebugModeException(e);
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
            this.httpConsumer.close();
        }
    }

    public static interface Consumer {
        public void send(Map<String, Object> var1);

        public void flush();

        public void close();
    }
}

