/*
 * Decompiled with CFR 0.152.
 */
package shaded.sasdk.com.fasterxml.jackson.databind.ser.std;

import java.lang.reflect.Type;
import java.util.Collection;
import shaded.sasdk.com.fasterxml.jackson.annotation.JsonFormat;
import shaded.sasdk.com.fasterxml.jackson.databind.AnnotationIntrospector;
import shaded.sasdk.com.fasterxml.jackson.databind.BeanProperty;
import shaded.sasdk.com.fasterxml.jackson.databind.JavaType;
import shaded.sasdk.com.fasterxml.jackson.databind.JsonMappingException;
import shaded.sasdk.com.fasterxml.jackson.databind.JsonNode;
import shaded.sasdk.com.fasterxml.jackson.databind.JsonSerializer;
import shaded.sasdk.com.fasterxml.jackson.databind.SerializerProvider;
import shaded.sasdk.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import shaded.sasdk.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import shaded.sasdk.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import shaded.sasdk.com.fasterxml.jackson.databind.ser.ContextualSerializer;
import shaded.sasdk.com.fasterxml.jackson.databind.ser.std.StdSerializer;

public abstract class StaticListSerializerBase<T extends Collection<?>>
extends StdSerializer<T>
implements ContextualSerializer {
    protected final JsonSerializer<String> _serializer;
    protected final Boolean _unwrapSingle;

    protected StaticListSerializerBase(Class<?> cls) {
        super(cls, false);
        this._serializer = null;
        this._unwrapSingle = null;
    }

    protected StaticListSerializerBase(StaticListSerializerBase<?> src, JsonSerializer<?> ser, Boolean unwrapSingle) {
        super(src);
        this._serializer = ser;
        this._unwrapSingle = unwrapSingle;
    }

    public abstract JsonSerializer<?> _withResolved(BeanProperty var1, JsonSerializer<?> var2, Boolean var3);

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializers, BeanProperty property) throws JsonMappingException {
        JsonFormat.Value format;
        JsonSerializer<Object> ser = null;
        Boolean unwrapSingle = null;
        if (property != null) {
            Object serDef;
            AnnotationIntrospector intr = serializers.getAnnotationIntrospector();
            AnnotatedMember m = property.getMember();
            if (m != null && (serDef = intr.findContentSerializer(m)) != null) {
                ser = serializers.serializerInstance(m, serDef);
            }
        }
        if ((format = this.findFormatOverrides(serializers, property, this.handledType())) != null) {
            unwrapSingle = format.getFeature(JsonFormat.Feature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED);
        }
        if (ser == null) {
            ser = this._serializer;
        }
        if (this.isDefaultSerializer(ser = (ser = this.findConvertingContentSerializer(serializers, property, ser)) == null ? serializers.findValueSerializer(String.class, property) : serializers.handleSecondaryContextualization(ser, property))) {
            ser = null;
        }
        if (ser == this._serializer && unwrapSingle == this._unwrapSingle) {
            return this;
        }
        return this._withResolved(property, ser, unwrapSingle);
    }

    @Override
    @Deprecated
    public boolean isEmpty(T value) {
        return this.isEmpty((SerializerProvider)null, value);
    }

    @Override
    public boolean isEmpty(SerializerProvider provider, T value) {
        return value == null || value.size() == 0;
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode("array", true).set("items", this.contentSchema());
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        this.acceptContentVisitor(visitor.expectArrayFormat(typeHint));
    }

    protected abstract JsonNode contentSchema();

    protected abstract void acceptContentVisitor(JsonArrayFormatVisitor var1) throws JsonMappingException;
}

