/*
 * Decompiled with CFR 0.152.
 */
package shaded.sasdk.org.apache.http.impl.client;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import shaded.sasdk.org.apache.http.HttpException;
import shaded.sasdk.org.apache.http.HttpHost;
import shaded.sasdk.org.apache.http.HttpRequest;
import shaded.sasdk.org.apache.http.annotation.ThreadSafe;
import shaded.sasdk.org.apache.http.client.ClientProtocolException;
import shaded.sasdk.org.apache.http.client.config.RequestConfig;
import shaded.sasdk.org.apache.http.client.methods.CloseableHttpResponse;
import shaded.sasdk.org.apache.http.client.methods.Configurable;
import shaded.sasdk.org.apache.http.client.methods.HttpExecutionAware;
import shaded.sasdk.org.apache.http.client.methods.HttpRequestWrapper;
import shaded.sasdk.org.apache.http.client.protocol.HttpClientContext;
import shaded.sasdk.org.apache.http.conn.ClientConnectionManager;
import shaded.sasdk.org.apache.http.conn.ClientConnectionRequest;
import shaded.sasdk.org.apache.http.conn.HttpClientConnectionManager;
import shaded.sasdk.org.apache.http.conn.ManagedClientConnection;
import shaded.sasdk.org.apache.http.conn.routing.HttpRoute;
import shaded.sasdk.org.apache.http.conn.scheme.SchemeRegistry;
import shaded.sasdk.org.apache.http.impl.DefaultConnectionReuseStrategy;
import shaded.sasdk.org.apache.http.impl.client.CloseableHttpClient;
import shaded.sasdk.org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import shaded.sasdk.org.apache.http.impl.execchain.MinimalClientExec;
import shaded.sasdk.org.apache.http.params.BasicHttpParams;
import shaded.sasdk.org.apache.http.params.HttpParams;
import shaded.sasdk.org.apache.http.protocol.BasicHttpContext;
import shaded.sasdk.org.apache.http.protocol.HttpContext;
import shaded.sasdk.org.apache.http.protocol.HttpRequestExecutor;
import shaded.sasdk.org.apache.http.util.Args;

@ThreadSafe
class MinimalHttpClient
extends CloseableHttpClient {
    private final HttpClientConnectionManager connManager;
    private final MinimalClientExec requestExecutor;
    private final HttpParams params;

    public MinimalHttpClient(HttpClientConnectionManager connManager) {
        this.connManager = Args.notNull(connManager, "HTTP connection manager");
        this.requestExecutor = new MinimalClientExec(new HttpRequestExecutor(), connManager, DefaultConnectionReuseStrategy.INSTANCE, DefaultConnectionKeepAliveStrategy.INSTANCE);
        this.params = new BasicHttpParams();
    }

    protected CloseableHttpResponse doExecute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
        Args.notNull(target, "Target host");
        Args.notNull(request, "HTTP request");
        HttpExecutionAware execAware = null;
        if (request instanceof HttpExecutionAware) {
            execAware = (HttpExecutionAware)((Object)request);
        }
        try {
            HttpRequestWrapper wrapper = HttpRequestWrapper.wrap(request);
            HttpClientContext localcontext = HttpClientContext.adapt(context != null ? context : new BasicHttpContext());
            HttpRoute route = new HttpRoute(target);
            RequestConfig config = null;
            if (request instanceof Configurable) {
                config = ((Configurable)((Object)request)).getConfig();
            }
            if (config != null) {
                localcontext.setRequestConfig(config);
            }
            return this.requestExecutor.execute(route, wrapper, localcontext, execAware);
        }
        catch (HttpException httpException) {
            throw new ClientProtocolException(httpException);
        }
    }

    public HttpParams getParams() {
        return this.params;
    }

    public void close() {
        this.connManager.shutdown();
    }

    public ClientConnectionManager getConnectionManager() {
        return new ClientConnectionManager(){

            public void shutdown() {
                MinimalHttpClient.this.connManager.shutdown();
            }

            public ClientConnectionRequest requestConnection(HttpRoute route, Object state) {
                throw new UnsupportedOperationException();
            }

            public void releaseConnection(ManagedClientConnection conn, long validDuration, TimeUnit timeUnit) {
                throw new UnsupportedOperationException();
            }

            public SchemeRegistry getSchemeRegistry() {
                throw new UnsupportedOperationException();
            }

            public void closeIdleConnections(long idletime, TimeUnit tunit) {
                MinimalHttpClient.this.connManager.closeIdleConnections(idletime, tunit);
            }

            public void closeExpiredConnections() {
                MinimalHttpClient.this.connManager.closeExpiredConnections();
            }
        };
    }
}

