/*
 * Decompiled with CFR 0.152.
 */
package shaded.sasdk.org.apache.http.impl.client;

import shaded.sasdk.org.apache.http.HeaderElement;
import shaded.sasdk.org.apache.http.HttpResponse;
import shaded.sasdk.org.apache.http.annotation.Immutable;
import shaded.sasdk.org.apache.http.conn.ConnectionKeepAliveStrategy;
import shaded.sasdk.org.apache.http.message.BasicHeaderElementIterator;
import shaded.sasdk.org.apache.http.protocol.HttpContext;
import shaded.sasdk.org.apache.http.util.Args;

@Immutable
public class DefaultConnectionKeepAliveStrategy
implements ConnectionKeepAliveStrategy {
    public static final DefaultConnectionKeepAliveStrategy INSTANCE = new DefaultConnectionKeepAliveStrategy();

    public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
        Args.notNull(response, "HTTP response");
        BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
        while (it.hasNext()) {
            HeaderElement he = it.nextElement();
            String param = he.getName();
            String value = he.getValue();
            if (value == null || !param.equalsIgnoreCase("timeout")) continue;
            try {
                return Long.parseLong(value) * 1000L;
            }
            catch (NumberFormatException ignore) {
            }
        }
        return -1L;
    }
}

