/*
 * Decompiled with CFR 0.152.
 */
package shaded.sasdk.org.apache.http.protocol;

import java.io.IOException;
import shaded.sasdk.org.apache.http.HttpEntity;
import shaded.sasdk.org.apache.http.HttpEntityEnclosingRequest;
import shaded.sasdk.org.apache.http.HttpException;
import shaded.sasdk.org.apache.http.HttpRequest;
import shaded.sasdk.org.apache.http.HttpRequestInterceptor;
import shaded.sasdk.org.apache.http.HttpVersion;
import shaded.sasdk.org.apache.http.ProtocolVersion;
import shaded.sasdk.org.apache.http.annotation.Immutable;
import shaded.sasdk.org.apache.http.protocol.HttpContext;
import shaded.sasdk.org.apache.http.util.Args;

@Immutable
public class RequestExpectContinue
implements HttpRequestInterceptor {
    private final boolean activeByDefault;

    @Deprecated
    public RequestExpectContinue() {
        this(false);
    }

    public RequestExpectContinue(boolean activeByDefault) {
        this.activeByDefault = activeByDefault;
    }

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            boolean active;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (active = request.getParams().getBooleanParameter("http.protocol.expect-continue", this.activeByDefault))) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

