/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.commons.beanutils.MethodUtils;

public class MappedPropertyDescriptor
extends PropertyDescriptor {
    private Class mappedPropertyType;
    private Method mappedReadMethod;
    private Method mappedWriteMethod;
    private static final Class[] stringClassArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = MappedPropertyDescriptor.class$("java.lang.String")) : class$java$lang$String};
    static /* synthetic */ Class class$java$lang$String;

    public MappedPropertyDescriptor(String propertyName, Class beanClass) throws IntrospectionException {
        super(propertyName, null, null);
        if (propertyName == null || propertyName.length() == 0) {
            throw new IntrospectionException("bad property name: " + propertyName + " on class: " + beanClass.getClass().getName());
        }
        this.setName(propertyName);
        String base = MappedPropertyDescriptor.capitalizePropertyName(propertyName);
        try {
            try {
                this.mappedReadMethod = MappedPropertyDescriptor.getMethod(beanClass, "get" + base, stringClassArray);
            }
            catch (IntrospectionException e) {
                this.mappedReadMethod = MappedPropertyDescriptor.getMethod(beanClass, "is" + base, stringClassArray);
            }
            Class[] params = new Class[]{class$java$lang$String == null ? (class$java$lang$String = MappedPropertyDescriptor.class$("java.lang.String")) : class$java$lang$String, this.mappedReadMethod.getReturnType()};
            this.mappedWriteMethod = MappedPropertyDescriptor.getMethod(beanClass, "set" + base, params);
        }
        catch (IntrospectionException e) {
            // empty catch block
        }
        if (this.mappedReadMethod == null) {
            this.mappedWriteMethod = MappedPropertyDescriptor.getMethod(beanClass, "set" + base, 2);
        }
        if (this.mappedReadMethod == null && this.mappedWriteMethod == null) {
            throw new IntrospectionException("Property '" + propertyName + "' not found on " + beanClass.getName());
        }
        this.findMappedPropertyType();
    }

    public MappedPropertyDescriptor(String propertyName, Class beanClass, String mappedGetterName, String mappedSetterName) throws IntrospectionException {
        super(propertyName, null, null);
        if (propertyName == null || propertyName.length() == 0) {
            throw new IntrospectionException("bad property name: " + propertyName);
        }
        this.setName(propertyName);
        this.mappedReadMethod = MappedPropertyDescriptor.getMethod(beanClass, mappedGetterName, stringClassArray);
        if (this.mappedReadMethod != null) {
            Class[] params = new Class[]{class$java$lang$String == null ? (class$java$lang$String = MappedPropertyDescriptor.class$("java.lang.String")) : class$java$lang$String, this.mappedReadMethod.getReturnType()};
            this.mappedWriteMethod = MappedPropertyDescriptor.getMethod(beanClass, mappedSetterName, params);
        } else {
            this.mappedWriteMethod = MappedPropertyDescriptor.getMethod(beanClass, mappedSetterName, 2);
        }
        this.findMappedPropertyType();
    }

    public MappedPropertyDescriptor(String propertyName, Method mappedGetter, Method mappedSetter) throws IntrospectionException {
        super(propertyName, mappedGetter, mappedSetter);
        if (propertyName == null || propertyName.length() == 0) {
            throw new IntrospectionException("bad property name: " + propertyName);
        }
        this.setName(propertyName);
        this.mappedReadMethod = mappedGetter;
        this.mappedWriteMethod = mappedSetter;
        this.findMappedPropertyType();
    }

    public Class getMappedPropertyType() {
        return this.mappedPropertyType;
    }

    public Method getMappedReadMethod() {
        return this.mappedReadMethod;
    }

    public void setMappedReadMethod(Method mappedGetter) throws IntrospectionException {
        this.mappedReadMethod = mappedGetter;
        this.findMappedPropertyType();
    }

    public Method getMappedWriteMethod() {
        return this.mappedWriteMethod;
    }

    public void setMappedWriteMethod(Method mappedSetter) throws IntrospectionException {
        this.mappedWriteMethod = mappedSetter;
        this.findMappedPropertyType();
    }

    private void findMappedPropertyType() throws IntrospectionException {
        this.mappedPropertyType = null;
        if (this.mappedReadMethod != null) {
            if (this.mappedReadMethod.getParameterTypes().length != 1) {
                throw new IntrospectionException("bad mapped read method arg count");
            }
            this.mappedPropertyType = this.mappedReadMethod.getReturnType();
            if (this.mappedPropertyType == Void.TYPE) {
                throw new IntrospectionException("mapped read method " + this.mappedReadMethod.getName() + " returns void");
            }
        }
        if (this.mappedWriteMethod != null) {
            Class<?>[] params = this.mappedWriteMethod.getParameterTypes();
            if (params.length != 2) {
                throw new IntrospectionException("bad mapped write method arg count");
            }
            if (this.mappedPropertyType != null && this.mappedPropertyType != params[1]) {
                throw new IntrospectionException("type mismatch between mapped read and write methods");
            }
            this.mappedPropertyType = params[1];
        }
    }

    private static String capitalizePropertyName(String s) {
        if (s.length() == 0) {
            return s;
        }
        char[] chars = s.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    private static Method internalGetMethod(Class initial, String methodName, int parameterCount) {
        for (Class clazz = initial; clazz != null; clazz = clazz.getSuperclass()) {
            Method[] methods = clazz.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                int mods;
                Method method = methods[i];
                if (method == null || !Modifier.isPublic(mods = method.getModifiers()) || Modifier.isStatic(mods) || !method.getName().equals(methodName) || method.getParameterTypes().length != parameterCount) continue;
                return method;
            }
        }
        Class<?>[] interfaces = initial.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Method method = MappedPropertyDescriptor.internalGetMethod(interfaces[i], methodName, parameterCount);
            if (method == null) continue;
            return method;
        }
        return null;
    }

    private static Method getMethod(Class clazz, String methodName, int parameterCount) throws IntrospectionException {
        if (methodName == null) {
            return null;
        }
        Method method = MappedPropertyDescriptor.internalGetMethod(clazz, methodName, parameterCount);
        if (method != null) {
            return method;
        }
        throw new IntrospectionException("No method \"" + methodName + "\" with " + parameterCount + " parameter(s)");
    }

    private static Method getMethod(Class clazz, String methodName, Class[] parameterTypes) throws IntrospectionException {
        if (methodName == null) {
            return null;
        }
        Method method = MethodUtils.getMatchingAccessibleMethod(clazz, methodName, parameterTypes);
        if (method != null) {
            return method;
        }
        int parameterCount = parameterTypes == null ? 0 : parameterTypes.length;
        throw new IntrospectionException("No method \"" + methodName + "\" with " + parameterCount + " parameter(s) of matching types.");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

