/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.locale.converters;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.apache.commons.beanutils.locale.BaseLocaleConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DateLocaleConverter
extends BaseLocaleConverter {
    private Log log = LogFactory.getLog((Class)(class$org$apache$commons$beanutils$locale$converters$DateLocaleConverter == null ? (class$org$apache$commons$beanutils$locale$converters$DateLocaleConverter = DateLocaleConverter.class$("org.apache.commons.beanutils.locale.converters.DateLocaleConverter")) : class$org$apache$commons$beanutils$locale$converters$DateLocaleConverter));
    boolean isLenient = false;
    private static final String defaultChars = DateLocaleConverter.initDefaultChars();
    static /* synthetic */ Class class$org$apache$commons$beanutils$locale$converters$DateLocaleConverter;

    public DateLocaleConverter() {
        this(false);
    }

    public DateLocaleConverter(boolean locPattern) {
        this(Locale.getDefault(), locPattern);
    }

    public DateLocaleConverter(Locale locale) {
        this(locale, false);
    }

    public DateLocaleConverter(Locale locale, boolean locPattern) {
        this(locale, (String)null, locPattern);
    }

    public DateLocaleConverter(Locale locale, String pattern) {
        this(locale, pattern, false);
    }

    public DateLocaleConverter(Locale locale, String pattern, boolean locPattern) {
        super(locale, pattern, locPattern);
    }

    public DateLocaleConverter(Object defaultValue) {
        this(defaultValue, false);
    }

    public DateLocaleConverter(Object defaultValue, boolean locPattern) {
        this(defaultValue, Locale.getDefault(), locPattern);
    }

    public DateLocaleConverter(Object defaultValue, Locale locale) {
        this(defaultValue, locale, false);
    }

    public DateLocaleConverter(Object defaultValue, Locale locale, boolean locPattern) {
        this(defaultValue, locale, null, locPattern);
    }

    public DateLocaleConverter(Object defaultValue, Locale locale, String pattern) {
        this(defaultValue, locale, pattern, false);
    }

    public DateLocaleConverter(Object defaultValue, Locale locale, String pattern, boolean locPattern) {
        super(defaultValue, locale, pattern, locPattern);
    }

    public boolean isLenient() {
        return this.isLenient;
    }

    public void setLenient(boolean lenient) {
        this.isLenient = lenient;
    }

    protected Object parse(Object value, String pattern) throws ParseException {
        if (this.locPattern) {
            pattern = this.convertLocalizedPattern(pattern, this.locale);
        }
        DateFormat formatter = pattern == null ? DateFormat.getDateInstance(3, this.locale) : new SimpleDateFormat(pattern, this.locale);
        formatter.setLenient(this.isLenient);
        return formatter.parse((String)value);
    }

    private String convertLocalizedPattern(String localizedPattern, Locale locale) {
        if (localizedPattern == null) {
            return null;
        }
        DateFormatSymbols localizedSymbols = new DateFormatSymbols(locale);
        String localChars = localizedSymbols.getLocalPatternChars();
        if (defaultChars.equals(localChars)) {
            return localizedPattern;
        }
        String convertedPattern = null;
        try {
            convertedPattern = this.convertPattern(localizedPattern, localChars, defaultChars);
        }
        catch (Exception ex) {
            this.log.warn((Object)("Converting pattern '" + localizedPattern + "' for " + locale), (Throwable)ex);
        }
        return convertedPattern;
    }

    private String convertPattern(String pattern, String fromChars, String toChars) {
        StringBuffer converted = new StringBuffer();
        boolean quoted = false;
        for (int i = 0; i < pattern.length(); ++i) {
            char thisChar = pattern.charAt(i);
            if (quoted) {
                if (thisChar == '\'') {
                    quoted = false;
                }
            } else if (thisChar == '\'') {
                quoted = true;
            } else if (thisChar >= 'a' && thisChar <= 'z' || thisChar >= 'A' && thisChar <= 'Z') {
                int index = fromChars.indexOf(thisChar);
                if (index == -1) {
                    throw new IllegalArgumentException("Illegal pattern character '" + thisChar + "'");
                }
                thisChar = toChars.charAt(index);
            }
            converted.append(thisChar);
        }
        if (quoted) {
            throw new IllegalArgumentException("Unfinished quote in pattern");
        }
        return converted.toString();
    }

    private static String initDefaultChars() {
        DateFormatSymbols defaultSymbols = new DateFormatSymbols(Locale.US);
        return defaultSymbols.getLocalPatternChars();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

