/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import org.apache.lucene.store.IndexInput;

public abstract class ConfigurableBufferedIndexInput
extends IndexInput {
    public static final int DEFAULT_BUFFER_SIZE = 1024;
    protected byte[] buffer;
    protected long bufferStart = 0L;
    protected int bufferLength = 0;
    protected int bufferPosition = 0;
    protected int bufferSize = 1024;

    protected void initBuffer(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public byte readByte() throws IOException {
        if (this.bufferPosition >= this.bufferLength) {
            this.refill();
        }
        return this.buffer[this.bufferPosition++];
    }

    public void readBytes(byte[] b, int offset, int len) throws IOException {
        if (len < this.bufferSize) {
            for (int i = 0; i < len; ++i) {
                b[i + offset] = this.readByte();
            }
        } else {
            long start = this.getFilePointer();
            this.seekInternal(start);
            this.readInternal(b, offset, len);
            this.bufferStart = start + (long)len;
            this.bufferPosition = 0;
            this.bufferLength = 0;
        }
    }

    protected void refill() throws IOException {
        long start = this.bufferStart + (long)this.bufferPosition;
        long end = start + (long)this.bufferSize;
        if (end > this.length()) {
            end = this.length();
        }
        this.bufferLength = (int)(end - start);
        if (this.bufferLength <= 0) {
            throw new IOException("read past EOF");
        }
        if (this.buffer == null) {
            this.buffer = new byte[this.bufferSize];
        }
        this.readInternal(this.buffer, 0, this.bufferLength);
        this.bufferStart = start;
        this.bufferPosition = 0;
    }

    protected abstract void readInternal(byte[] var1, int var2, int var3) throws IOException;

    public long getFilePointer() {
        return this.bufferStart + (long)this.bufferPosition;
    }

    public void seek(long pos) throws IOException {
        if (pos >= this.bufferStart && pos < this.bufferStart + (long)this.bufferLength) {
            this.bufferPosition = (int)(pos - this.bufferStart);
        } else {
            this.bufferStart = pos;
            this.bufferPosition = 0;
            this.bufferLength = 0;
            this.seekInternal(pos);
        }
    }

    protected abstract void seekInternal(long var1) throws IOException;

    public Object clone() {
        ConfigurableBufferedIndexInput clone = (ConfigurableBufferedIndexInput)((Object)super.clone());
        if (this.buffer != null) {
            clone.buffer = new byte[this.bufferSize];
            System.arraycopy(this.buffer, 0, clone.buffer, 0, this.bufferLength);
        }
        return clone;
    }
}

