/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.cache.first;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.CompassException;
import org.compass.core.cache.first.DefaultFirstLevelCache;
import org.compass.core.cache.first.FirstLevelCache;
import org.compass.core.cache.first.NullFirstLevelCache;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.ConfigurationException;
import org.compass.core.util.ClassUtils;

public class FirstLevelCacheFactory
implements CompassConfigurable {
    private static final Log log = LogFactory.getLog((Class)FirstLevelCacheFactory.class);
    private Class firstLevelCacheClass;

    public void configure(CompassSettings settings) throws CompassException {
        String transIsolationSetting = settings.getSetting("compass.transaction.isolation", null);
        if (transIsolationSetting != null && transIsolationSetting.equalsIgnoreCase("batch_insert")) {
            this.firstLevelCacheClass = NullFirstLevelCache.class;
        } else {
            String firstLevelCacheSetting = settings.getSetting("compass.cache.first", DefaultFirstLevelCache.class.getName());
            try {
                this.firstLevelCacheClass = ClassUtils.forName(firstLevelCacheSetting);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException("Failed to find class name [" + firstLevelCacheSetting + "] for first level cache", e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using first level cache [" + this.firstLevelCacheClass.getName() + "]"));
        }
    }

    public FirstLevelCache createFirstLevelCache() throws CompassException {
        try {
            return (FirstLevelCache)this.firstLevelCacheClass.newInstance();
        }
        catch (Exception e) {
            throw new CompassException("Failed to create first level cache", e);
        }
    }
}

