/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.converter.basic;

import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.compass.core.converter.ConversionException;
import org.compass.core.converter.basic.AbstractFormatConverter;
import org.compass.core.converter.basic.ThreadSafeFormat;
import org.compass.core.mapping.ResourcePropertyMapping;

public class DateConverter
extends AbstractFormatConverter {
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd-HH-mm-ss-S-a";

    protected String doGetDefaultFormat() {
        return DEFAULT_DATE_FORMAT;
    }

    protected ThreadSafeFormat.FormatterFactory doCreateFormatterFactory() {
        return new DateFormatter();
    }

    public Object fromString(String str, ResourcePropertyMapping resourcePropertyMapping) throws ConversionException {
        try {
            return this.formatter.parse(str);
        }
        catch (ParseException e) {
            throw new ConversionException("Failed to parse date [" + str + "]", e);
        }
    }

    public String toString(Object o, ResourcePropertyMapping resourcePropertyMapping) throws ConversionException {
        return this.formatter.format(o);
    }

    private static class DateFormatter
    implements ThreadSafeFormat.FormatterFactory {
        private String format;
        private Locale locale;

        private DateFormatter() {
        }

        public void configure(String format, Locale locale) {
            this.format = format;
            this.locale = locale;
        }

        public Format create() {
            if (this.locale != null) {
                return new SimpleDateFormat(this.format, this.locale);
            }
            return new SimpleDateFormat(this.format);
        }
    }
}

