/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.converter.dynamic;

import org.compass.core.Property;
import org.compass.core.Resource;
import org.compass.core.converter.ConversionException;
import org.compass.core.converter.basic.AbstractBasicConverter;
import org.compass.core.converter.basic.FormatConverter;
import org.compass.core.converter.dynamic.DynamicConverter;
import org.compass.core.engine.SearchEngine;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.ResourcePropertyMapping;
import org.compass.core.marshall.MarshallingContext;

public abstract class AbstractDynamicConverter
extends AbstractBasicConverter
implements DynamicConverter {
    private FormatConverter formatConverter;
    private Class type;

    public DynamicConverter copy() {
        try {
            DynamicConverter converter = (DynamicConverter)this.getClass().newInstance();
            converter.setType(this.getType());
            converter.setFormatConverter(this.formatConverter);
            return converter;
        }
        catch (Exception e) {
            throw new ConversionException("This should not happen", e);
        }
    }

    public void setFormatConverter(FormatConverter formatConverter) {
        this.formatConverter = formatConverter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean marshall(Resource resource, Object root, Mapping mapping, MarshallingContext context) throws ConversionException {
        ResourcePropertyMapping resourcePropertyMapping = (ResourcePropertyMapping)mapping;
        SearchEngine searchEngine = context.getSearchEngine();
        if (root == null && !this.handleNulls(context)) {
            return false;
        }
        String sValue = this.getNullValue(context);
        if (root != null) {
            Object value = this.evaluate(root, resourcePropertyMapping);
            if (value == null) {
                if (!this.handleNulls(context)) return false;
                sValue = this.getNullValue(context);
            } else {
                sValue = this.formatConverter == null ? value.toString() : this.formatConverter.toString(value, resourcePropertyMapping);
            }
        }
        Property p = searchEngine.createProperty(sValue, resourcePropertyMapping);
        this.doSetBoost(p, root, resourcePropertyMapping, context);
        resource.addProperty(p);
        if (resourcePropertyMapping.getStore() == Property.Store.NO) return false;
        return true;
    }

    protected abstract Object evaluate(Object var1, ResourcePropertyMapping var2) throws ConversionException;

    public Object unmarshall(Resource resource, Mapping mapping, MarshallingContext context) throws ConversionException {
        return null;
    }

    public Object fromString(String str, ResourcePropertyMapping resourcePropertyMapping) throws ConversionException {
        return null;
    }

    public Class getType() {
        return this.type;
    }

    public void setType(Class type) {
        this.type = type;
    }
}

