/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.converter.extended;

import org.compass.core.Property;
import org.compass.core.Resource;
import org.compass.core.converter.ConversionException;
import org.compass.core.converter.Converter;
import org.compass.core.engine.SearchEngine;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.ResourcePropertyMapping;
import org.compass.core.marshall.MarshallingContext;

public class PrimitiveByteArrayConverter
implements Converter {
    public boolean marshall(Resource resource, Object root, Mapping mapping, MarshallingContext context) throws ConversionException {
        ResourcePropertyMapping resourcePropertyMapping = (ResourcePropertyMapping)mapping;
        SearchEngine searchEngine = context.getSearchEngine();
        if (root == null && !this.handleNulls(context)) {
            return false;
        }
        String propertyName = resourcePropertyMapping.getPath().getPath();
        byte[] value = (byte[])root;
        Property p = searchEngine.createProperty(propertyName, value, resourcePropertyMapping.getStore());
        p.setBoost(resourcePropertyMapping.getBoost());
        resource.addProperty(p);
        return resourcePropertyMapping.getStore() != Property.Store.NO;
    }

    public Object unmarshall(Resource resource, Mapping mapping, MarshallingContext context) throws ConversionException {
        ResourcePropertyMapping resourcePropertyMapping = (ResourcePropertyMapping)mapping;
        if (resourcePropertyMapping.getStore() == Property.Store.NO) {
            return null;
        }
        String propertyName = resourcePropertyMapping.getPath().getPath();
        Property p = resource.getProperty(propertyName);
        if (p == null) {
            return null;
        }
        return p.getBinaryValue();
    }

    protected boolean handleNulls(MarshallingContext context) {
        return context.handleNulls();
    }
}

