/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermPositionVector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.TokenSources;
import org.compass.core.CompassHighlighter;
import org.compass.core.Resource;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.engine.SearchEngineHighlighter;
import org.compass.core.lucene.LuceneResource;
import org.compass.core.lucene.engine.LuceneDelegatedClose;
import org.compass.core.lucene.engine.LuceneSearchEngine;
import org.compass.core.lucene.engine.LuceneSearchEngineQuery;
import org.compass.core.lucene.engine.analyzer.LuceneAnalyzerManager;
import org.compass.core.lucene.engine.highlighter.LuceneHighlighterManager;
import org.compass.core.lucene.engine.highlighter.LuceneHighlighterSettings;

public class LuceneSearchEngineHighlighter
implements SearchEngineHighlighter,
LuceneDelegatedClose {
    private IndexReader indexReader;
    private boolean closed;
    private Query query;
    private LuceneHighlighterSettings highlighterSettings;
    private LuceneAnalyzerManager analyzerManager;
    private LuceneHighlighterManager highlighterManager;
    private int maxNumFragments = -1;
    private Analyzer analyzer;
    private String separator;
    private int maxBytesToAnalyze = -1;
    private CompassHighlighter.TextTokenizer textTokenizer;

    public LuceneSearchEngineHighlighter(LuceneSearchEngineQuery searchEngineQuery, IndexReader indexReader, LuceneSearchEngine searchEngine) throws SearchEngineException {
        this.indexReader = indexReader;
        this.highlighterManager = searchEngine.getSearchEngineFactory().getHighlighterManager();
        this.highlighterSettings = this.highlighterManager.getDefaultHighlighterSettings();
        this.analyzerManager = searchEngine.getSearchEngineFactory().getAnalyzerManager();
        if (this.highlighterSettings.isRewriteQuery()) {
            try {
                this.query = searchEngineQuery.getQuery().rewrite(indexReader);
            }
            catch (IOException e) {
                throw new SearchEngineException("Failed to rewrite query [" + this.query + "] for highlighter", e);
            }
        }
        this.clear();
    }

    public SearchEngineHighlighter clear() {
        this.analyzer = this.analyzerManager.getDefaultAnalyzer();
        this.maxNumFragments = -1;
        this.separator = null;
        this.maxBytesToAnalyze = -1;
        return this;
    }

    public SearchEngineHighlighter setMaxNumFragments(int maxNumFragments) throws SearchEngineException {
        this.maxNumFragments = maxNumFragments;
        return this;
    }

    public SearchEngineHighlighter setMaxBytesToAnalyze(int maxBytesToAnalyze) throws SearchEngineException {
        this.maxBytesToAnalyze = maxBytesToAnalyze;
        return this;
    }

    public SearchEngineHighlighter setAnalyzer(String analyzerName) throws SearchEngineException {
        this.analyzer = this.analyzerManager.getAnalyzerMustExist(analyzerName);
        return this;
    }

    public SearchEngineHighlighter setAnalyzer(Resource resource) throws SearchEngineException {
        this.analyzer = this.analyzerManager.getAnalyzerByResource(resource);
        return this;
    }

    public SearchEngineHighlighter setHighlighter(String highlighterName) throws SearchEngineException {
        this.highlighterSettings = this.highlighterManager.getHighlighterSettingsMustExists(highlighterName);
        return this;
    }

    public SearchEngineHighlighter setSeparator(String separator) throws SearchEngineException {
        this.separator = separator;
        return this;
    }

    public SearchEngineHighlighter setTextTokenizer(CompassHighlighter.TextTokenizer textTokenizer) throws SearchEngineException {
        this.textTokenizer = textTokenizer;
        return this;
    }

    public String fragment(Resource resource, String propertyName) throws SearchEngineException {
        return this.fragment(resource, propertyName, this.getTextFromResource(resource, propertyName));
    }

    public String fragment(Resource resource, String propertyName, String text) throws SearchEngineException {
        Highlighter highlighter = this.createHighlighter(propertyName);
        TokenStream tokenStream = this.createTokenStream(resource, propertyName, text);
        try {
            return highlighter.getBestFragment(tokenStream, text);
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to highlight fragments for alias [" + resource.getAlias() + "] and property [" + propertyName + "]");
        }
    }

    public String[] fragments(Resource resource, String propertyName) throws SearchEngineException {
        return this.fragments(resource, propertyName, this.getTextFromResource(resource, propertyName));
    }

    public String[] fragments(Resource resource, String propertyName, String text) throws SearchEngineException {
        Highlighter highlighter = this.createHighlighter(propertyName);
        TokenStream tokenStream = this.createTokenStream(resource, propertyName, text);
        try {
            return highlighter.getBestFragments(tokenStream, text, this.getMaxNumFragments());
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to highlight fragments for alias [" + resource.getAlias() + "] and property [" + propertyName + "]");
        }
    }

    public String fragmentsWithSeparator(Resource resource, String propertyName) throws SearchEngineException {
        return this.fragmentsWithSeparator(resource, propertyName, this.getTextFromResource(resource, propertyName));
    }

    public String fragmentsWithSeparator(Resource resource, String propertyName, String text) throws SearchEngineException {
        Highlighter highlighter = this.createHighlighter(propertyName);
        TokenStream tokenStream = this.createTokenStream(resource, propertyName, text);
        try {
            String actualSeparator = this.separator;
            if (actualSeparator == null) {
                actualSeparator = this.highlighterSettings.getSeparator();
            }
            return highlighter.getBestFragments(tokenStream, text, this.getMaxNumFragments(), actualSeparator);
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to highlight fragments for alias [" + resource.getAlias() + "] and property [" + propertyName + "]");
        }
    }

    protected TokenStream createTokenStream(Resource resource, String propertyName, String text) throws SearchEngineException {
        CompassHighlighter.TextTokenizer actualTextTokenizer = this.highlighterSettings.getTextTokenizer();
        if (this.textTokenizer != null) {
            actualTextTokenizer = this.textTokenizer;
        }
        if (actualTextTokenizer == CompassHighlighter.TextTokenizer.AUTO) {
            TokenStream tokenStream = this.createTokenStreamFromTermPositions(resource, propertyName);
            if (tokenStream == null) {
                tokenStream = this.analyzer.tokenStream(propertyName, (Reader)new StringReader(text));
            }
            return tokenStream;
        }
        if (actualTextTokenizer == CompassHighlighter.TextTokenizer.ANALYZER) {
            return this.analyzer.tokenStream(propertyName, (Reader)new StringReader(text));
        }
        if (actualTextTokenizer == CompassHighlighter.TextTokenizer.TERM_VECTOR) {
            TokenStream tokenStream = this.createTokenStreamFromTermPositions(resource, propertyName);
            if (tokenStream == null) {
                throw new SearchEngineException("Highlighter configured/set to use term vector, but no term vector is available");
            }
            return tokenStream;
        }
        throw new SearchEngineException("No handling for text tokenizer [" + actualTextTokenizer + "]");
    }

    protected TokenStream createTokenStreamFromTermPositions(Resource resource, String propertyName) throws SearchEngineException {
        TermFreqVector tfv;
        int docId = ((LuceneResource)resource).getDocNum();
        try {
            tfv = this.indexReader.getTermFreqVector(docId, propertyName);
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to read term vector info", e);
        }
        if (tfv != null && tfv instanceof TermPositionVector) {
            return TokenSources.getTokenStream((TermPositionVector)((TermPositionVector)tfv));
        }
        return null;
    }

    protected Highlighter createHighlighter(String propertyName) throws SearchEngineException {
        Highlighter highlighter = new Highlighter(this.highlighterSettings.getFormatter(), this.highlighterSettings.getEncoder(), this.createScorer(propertyName));
        highlighter.setTextFragmenter(this.highlighterSettings.getFragmenter());
        if (this.maxBytesToAnalyze == -1) {
            highlighter.setMaxDocBytesToAnalyze(this.highlighterSettings.getMaxBytesToAnalyze());
        } else {
            highlighter.setMaxDocBytesToAnalyze(this.maxBytesToAnalyze);
        }
        return highlighter;
    }

    protected Scorer createScorer(String propertyName) throws SearchEngineException {
        if (this.highlighterSettings.isComputeIdf()) {
            if (propertyName == null) {
                throw new SearchEngineException("When using a formatter that requires idf or setting the [computeIdf] setting, a resource property name must be provided");
            }
            return new QueryScorer(this.query, this.indexReader, propertyName);
        }
        return new QueryScorer(this.query);
    }

    private String getTextFromResource(Resource resource, String propertyName) {
        String text = resource.get(propertyName);
        if (text == null) {
            throw new SearchEngineException("No text is stored for property [" + propertyName + "] and alias [" + resource.getAlias() + "]");
        }
        return text;
    }

    private int getMaxNumFragments() {
        if (this.maxNumFragments == -1) {
            return this.highlighterSettings.getMaxNumFragments();
        }
        return this.maxNumFragments;
    }

    public void close() throws SearchEngineException {
        if (this.closed) {
            return;
        }
        this.closed = true;
    }
}

