/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.analyzer.synonym;

import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.compass.core.CompassException;
import org.compass.core.config.CompassSettings;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.engine.analyzer.LuceneAnalyzerTokenFilterProvider;
import org.compass.core.lucene.engine.analyzer.synonym.SynonymFilter;
import org.compass.core.lucene.engine.analyzer.synonym.SynonymLookupProvider;
import org.compass.core.util.ClassUtils;

public class SynonymAnalyzerTokenFilterProvider
implements LuceneAnalyzerTokenFilterProvider {
    private SynonymLookupProvider synonymLookupProvider;

    public void configure(CompassSettings settings) throws CompassException {
        String lookupProviderClassName = settings.getSetting("lookup");
        if (lookupProviderClassName == null) {
            throw new SearchEngineException("Failed to locate synonym lookup provider, verify that you set the [lookup] setting for the group");
        }
        try {
            this.synonymLookupProvider = (SynonymLookupProvider)ClassUtils.forName(lookupProviderClassName).newInstance();
        }
        catch (Exception e) {
            throw new SearchEngineException("Failed to create lookup synonym provider [" + lookupProviderClassName + "]", e);
        }
        this.synonymLookupProvider.configure(settings);
    }

    public TokenFilter createTokenFilter(TokenStream tokenStream) {
        return new SynonymFilter(tokenStream, this.synonymLookupProvider);
    }
}

