/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.optimizer;

import java.io.IOException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.LuceneSubIndexInfo;
import org.apache.lucene.store.Directory;
import org.compass.core.CompassException;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.engine.manager.LuceneSearchEngineIndexManager;
import org.compass.core.lucene.engine.optimizer.AbstractLuceneSearchEngineOptimizer;

public class AggressiveOptimizer
extends AbstractLuceneSearchEngineOptimizer
implements CompassConfigurable {
    private long mergeFactor;

    public void configure(CompassSettings settings) throws CompassException {
        this.mergeFactor = settings.getSettingAsLong("compass.engine.optimizer.aggressive.mergeFactor", 10L);
    }

    public boolean canBeScheduled() {
        return true;
    }

    protected boolean isOptimizeOnlyIfIndexChanged() {
        return true;
    }

    public boolean doNeedOptimizing(String subIndex, LuceneSubIndexInfo indexInfo) {
        if ((long)indexInfo.size() >= this.mergeFactor) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Need to optimize sub-index [" + subIndex + "]. Optimizing " + indexInfo.size() + " segments into one segment."));
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doOptimize(String subIndex, LuceneSubIndexInfo indexInfo) throws SearchEngineException {
        Directory dir;
        IndexWriter indexWriter;
        LuceneSearchEngineIndexManager indexManager;
        block6: {
            indexManager = this.getSearchEngineFactory().getLuceneIndexManager();
            indexWriter = null;
            dir = null;
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Optimizing sub-index [" + subIndex + "]"));
                }
                long time = System.currentTimeMillis();
                dir = indexManager.getStore().getDirectoryBySubIndex(subIndex, false);
                indexWriter = indexManager.openIndexWriter(dir, false);
                long lockTime = System.currentTimeMillis() - time;
                time = System.currentTimeMillis();
                indexWriter.optimize();
                long optimizeTime = System.currentTimeMillis() - time;
                if (!this.log.isDebugEnabled()) break block6;
                this.log.debug((Object)("Optimization of sub-index [" + subIndex + "] took [" + (optimizeTime + lockTime) + "ms], Locking took [" + lockTime + "ms], and optimization took [" + optimizeTime + "ms]."));
            }
            catch (IOException e) {
                try {
                    if (!e.getMessage().startsWith("Lock obtain")) {
                        throw new SearchEngineException("Failed to optimize sub-index [" + subIndex + "]", e);
                    }
                    this.log.warn((Object)("Failed to obtain lock on sub-index [" + subIndex + "], will do it next time."));
                }
                catch (Throwable throwable) {
                    indexManager.closeIndexWriter(subIndex, indexWriter, dir);
                    throw throwable;
                }
                indexManager.closeIndexWriter(subIndex, indexWriter, dir);
            }
        }
        indexManager.closeIndexWriter(subIndex, indexWriter, dir);
    }
}

