/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.queryparser;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.CompassException;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.ConfigurationException;
import org.compass.core.lucene.engine.LuceneSearchEngineFactory;
import org.compass.core.lucene.engine.queryparser.DefaultLuceneQueryParser;
import org.compass.core.lucene.engine.queryparser.LuceneQueryParser;
import org.compass.core.util.ClassUtils;

public class LuceneQueryParserManager
implements CompassConfigurable {
    private static final Log log = LogFactory.getLog((Class)LuceneQueryParserManager.class);
    private HashMap queryParsers = new HashMap();

    public LuceneQueryParserManager(LuceneSearchEngineFactory searchEngineFactory) {
    }

    public void configure(CompassSettings settings) throws CompassException {
        Map queryParserSettingGroups = settings.getSettingGroups("compass.engine.queryParser");
        Iterator it = queryParserSettingGroups.entrySet().iterator();
        while (it.hasNext()) {
            LuceneQueryParser queryParser;
            String queryParserType;
            Map.Entry entry = it.next();
            String queryParserName = (String)entry.getKey();
            CompassSettings queryParserSettings = (CompassSettings)entry.getValue();
            if (log.isInfoEnabled()) {
                log.info((Object)("Building query parser [" + queryParserName + "]"));
            }
            if ((queryParserType = queryParserSettings.getSetting("type")) == null) {
                throw new ConfigurationException("Failed to locate query parser [" + queryParserName + "] type, it must be set");
            }
            try {
                queryParser = (LuceneQueryParser)ClassUtils.forName(queryParserType).newInstance();
            }
            catch (Exception e) {
                throw new ConfigurationException("Failed to create query parser class [" + queryParserType + "]", e);
            }
            if (queryParser instanceof CompassConfigurable) {
                ((CompassConfigurable)((Object)queryParser)).configure(queryParserSettings);
            }
            this.queryParsers.put(queryParserName, queryParser);
        }
        if (this.queryParsers.get("default") == null) {
            this.queryParsers.put("default", new DefaultLuceneQueryParser());
        }
    }

    public LuceneQueryParser getDefaultQueryParser() {
        return this.getQueryParser("default");
    }

    public LuceneQueryParser getQueryParser(String queryParserName) throws IllegalArgumentException {
        LuceneQueryParser queryParser = (LuceneQueryParser)this.queryParsers.get(queryParserName);
        if (queryParser == null) {
            throw new IllegalArgumentException("No query parser is configured under [" + queryParserName + "]");
        }
        return queryParser;
    }
}

