/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.store;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.store.Directory;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.engine.store.LuceneSearchEngineStore;

public class LuceneStoreTemplate {
    private static Log log = LogFactory.getLog((Class)LuceneStoreTemplate.class);
    private LuceneSearchEngineStore searchEngineStore;

    public LuceneStoreTemplate(LuceneSearchEngineStore searchEngineStore) {
        this.searchEngineStore = searchEngineStore;
    }

    public Object executeForSubIndex(String subIndex, boolean create, LuceneSearchEngineStore.LuceneStoreCallback callback) throws SearchEngineException {
        Directory dir = this.searchEngineStore.getDirectoryBySubIndex(subIndex, create);
        return this.execute(subIndex, dir, callback);
    }

    public Object execute(String subIndex, Directory dir, LuceneSearchEngineStore.LuceneStoreCallback callback) throws SearchEngineException {
        try {
            return callback.doWithStore(dir);
        }
        catch (Exception e) {
            Exception ex;
            block8: {
                ex = e;
                try {
                    if (dir != null) {
                        this.searchEngineStore.closeDirectory(subIndex, dir);
                    }
                }
                catch (Exception e2) {
                    if (ex == null) {
                        ex = e2;
                        break block8;
                    }
                    log.warn((Object)"Caught an exception trying to close the lucene directory with other exception pending, logging and ignoring", (Throwable)e2);
                }
            }
            if (ex != null) {
                if (ex instanceof SearchEngineException) {
                    throw (SearchEngineException)ex;
                }
                throw new SearchEngineException("Failed while executing a lucene directory based operation", ex);
            }
            return null;
        }
    }
}

