/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.mapping.osem;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.ResourcePropertyMapping;
import org.compass.core.mapping.osem.AbstractCollectionMapping;
import org.compass.core.mapping.osem.ClassMapping;
import org.compass.core.mapping.osem.ClassPropertyMapping;
import org.compass.core.mapping.osem.ClassPropertyMetaDataMapping;
import org.compass.core.mapping.osem.ComponentMapping;
import org.compass.core.mapping.osem.ConstantMetaDataMapping;
import org.compass.core.mapping.osem.DynamicMetaDataMapping;
import org.compass.core.mapping.osem.HasRefAliasMapping;
import org.compass.core.mapping.osem.ObjectMapping;
import org.compass.core.mapping.osem.ParentMapping;
import org.compass.core.mapping.osem.ReferenceMapping;
import org.compass.core.util.Assert;

public abstract class OsemMappingIterator {
    public static void iterateMappings(ClassMappingCallback callback, ClassMapping classMapping) {
        OsemMappingIterator.iterateMappings(callback, classMapping, true);
    }

    public static void iterateMappings(ClassMappingCallback callback, ClassMapping classMapping, boolean recursive) {
        callback.onBeginClassMapping(classMapping);
        Iterator mappingsIt = classMapping.mappingsIt();
        while (mappingsIt.hasNext()) {
            Mapping m = (Mapping)mappingsIt.next();
            if (m instanceof ClassPropertyMapping) {
                ClassPropertyMapping classPropertyMapping = (ClassPropertyMapping)m;
                OsemMappingIterator.iteratePropertyMapping(callback, classMapping, classPropertyMapping);
                continue;
            }
            if (m instanceof ParentMapping) {
                callback.onParentMapping(classMapping, (ParentMapping)m);
                continue;
            }
            if (m instanceof DynamicMetaDataMapping) {
                DynamicMetaDataMapping dynamicMetaDataMapping = (DynamicMetaDataMapping)m;
                callback.onDynamicMetaDataMapping(classMapping, dynamicMetaDataMapping);
                callback.onResourcePropertyMapping(dynamicMetaDataMapping);
                continue;
            }
            if (m instanceof ComponentMapping) {
                ComponentMapping componentMapping = (ComponentMapping)m;
                OsemMappingIterator.iterateComponentMapping(callback, classMapping, componentMapping, recursive);
                continue;
            }
            if (m instanceof ReferenceMapping) {
                ReferenceMapping referenceMapping = (ReferenceMapping)m;
                OsemMappingIterator.iterateReferenceMapping(callback, classMapping, referenceMapping, recursive);
                continue;
            }
            if (m instanceof ConstantMetaDataMapping) {
                ConstantMetaDataMapping constantMetaDataMapping = (ConstantMetaDataMapping)m;
                boolean drillDown = callback.onBeginMultipleMapping(classMapping, constantMetaDataMapping);
                if (drillDown) {
                    callback.onConstantMetaDataMappaing(classMapping, constantMetaDataMapping);
                    callback.onResourcePropertyMapping(constantMetaDataMapping);
                }
                callback.onEndMultiplMapping(classMapping, constantMetaDataMapping);
                continue;
            }
            if (!(m instanceof AbstractCollectionMapping)) continue;
            AbstractCollectionMapping colMapping = (AbstractCollectionMapping)m;
            callback.onBeginCollectionMapping(colMapping);
            Mapping elementMapping = colMapping.getElementMapping();
            if (elementMapping instanceof ClassPropertyMapping) {
                ClassPropertyMapping classPropertyMapping = (ClassPropertyMapping)elementMapping;
                OsemMappingIterator.iteratePropertyMapping(callback, classMapping, classPropertyMapping);
            } else if (elementMapping instanceof ComponentMapping) {
                ComponentMapping componentMapping = (ComponentMapping)elementMapping;
                OsemMappingIterator.iterateComponentMapping(callback, classMapping, componentMapping, recursive);
            } else if (elementMapping instanceof ReferenceMapping) {
                ReferenceMapping referenceMapping = (ReferenceMapping)elementMapping;
                OsemMappingIterator.iterateReferenceMapping(callback, classMapping, referenceMapping, recursive);
            }
            callback.onEndCollectionMapping(colMapping);
        }
        callback.onEndClassMapping(classMapping);
    }

    private static void iterateReferenceMapping(ClassMappingCallback callback, ClassMapping classMapping, ReferenceMapping referenceMapping, boolean recursive) {
        boolean drillDown = callback.onBeginMultipleMapping(classMapping, referenceMapping);
        if (drillDown) {
            callback.onReferenceMapping(classMapping, referenceMapping);
            if (recursive) {
                ClassMapping[] refMappings = referenceMapping.getRefClassMappings();
                for (int i = 0; i < refMappings.length; ++i) {
                    OsemMappingIterator.iterateMappings(callback, refMappings[i]);
                }
                if (referenceMapping.getRefCompMapping() != null) {
                    OsemMappingIterator.iterateMappings(callback, referenceMapping.getRefCompMapping());
                }
            }
        }
        callback.onEndMultiplMapping(classMapping, referenceMapping);
    }

    private static void iterateComponentMapping(ClassMappingCallback callback, ClassMapping classMapping, ComponentMapping componentMapping, boolean recursive) {
        boolean drillDown = callback.onBeginMultipleMapping(classMapping, componentMapping);
        if (drillDown) {
            callback.onComponentMapping(classMapping, componentMapping);
            if (recursive) {
                ClassMapping[] refMappings = componentMapping.getRefClassMappings();
                for (int i = 0; i < refMappings.length; ++i) {
                    OsemMappingIterator.iterateMappings(callback, refMappings[i]);
                }
            }
        }
        callback.onEndMultiplMapping(classMapping, componentMapping);
    }

    private static void iteratePropertyMapping(ClassMappingCallback callback, ClassMapping classMapping, ClassPropertyMapping classPropertyMapping) {
        boolean drillDown = callback.onBeginMultipleMapping(classMapping, classPropertyMapping);
        if (drillDown) {
            callback.onClassPropertyMapping(classMapping, classPropertyMapping);
            Iterator resIt = classPropertyMapping.mappingsIt();
            while (resIt.hasNext()) {
                ClassPropertyMetaDataMapping classPropertyMetaDataMapping = (ClassPropertyMetaDataMapping)resIt.next();
                callback.onClassPropertyMetaDataMapping(classPropertyMetaDataMapping);
                callback.onResourcePropertyMapping(classPropertyMetaDataMapping);
            }
        }
        callback.onEndMultiplMapping(classMapping, classPropertyMapping);
    }

    public static class ClassPropertyAndResourcePropertyGatherer
    implements ClassMappingCallback {
        private ArrayList classPropertyMappings = new ArrayList();
        private ArrayList resourcePropertyMappings = new ArrayList();
        private HashMap ignoreInheritedDuplicatesClassMappings = new HashMap();

        public ArrayList getClassPropertyMappings() {
            return this.classPropertyMappings;
        }

        public ArrayList getResourcePropertyMappings() {
            return this.resourcePropertyMappings;
        }

        public void onBeginClassMapping(ClassMapping classMapping) {
        }

        public void onEndClassMapping(ClassMapping classMapping) {
        }

        public boolean onBeginMultipleMapping(ClassMapping classMapping, Mapping mapping) {
            HashMap byAlias;
            ClassMapping[] classMappings;
            if (mapping instanceof HasRefAliasMapping && (classMappings = ((HasRefAliasMapping)mapping).getRefClassMappings()).length > 1) {
                HashMap byAlias2 = new HashMap();
                for (int i = 0; i < classMappings.length; ++i) {
                    this.ignoreInheritedDuplicatesClassMappings.put(new Integer(System.identityHashCode(classMappings[i])), byAlias2);
                }
            }
            if ((byAlias = (HashMap)this.ignoreInheritedDuplicatesClassMappings.get(new Integer(System.identityHashCode(classMapping)))) != null && mapping instanceof ObjectMapping) {
                ObjectMapping actualObjectMapping;
                ObjectMapping objectMapping = (ObjectMapping)mapping;
                Assert.notNull(objectMapping.getDefinedInAlias(), "Internal Compass Error, Defined in Alias not found for [" + objectMapping.getPropertyName() + "] in alias [" + classMapping.getAlias() + "]");
                HashMap<String, ObjectMapping> propByAlias = (HashMap<String, ObjectMapping>)byAlias.get(objectMapping.getDefinedInAlias());
                if (propByAlias == null) {
                    propByAlias = new HashMap<String, ObjectMapping>();
                    byAlias.put(objectMapping.getDefinedInAlias(), propByAlias);
                }
                if ((actualObjectMapping = (ObjectMapping)propByAlias.get(objectMapping.getPropertyName())) != null) {
                    this.onDuplicateMapping(classMapping, actualObjectMapping, objectMapping);
                    return false;
                }
                propByAlias.put(objectMapping.getPropertyName(), objectMapping);
            }
            return true;
        }

        protected void onDuplicateMapping(ClassMapping classMapping, ObjectMapping actualMapping, ObjectMapping duplicateMapping) {
        }

        public void onEndMultiplMapping(ClassMapping classMapping, Mapping mapping) {
        }

        public void onBeginCollectionMapping(AbstractCollectionMapping collectionMapping) {
        }

        public void onEndCollectionMapping(AbstractCollectionMapping collectionMapping) {
        }

        public void onClassPropertyMapping(ClassMapping classMapping, ClassPropertyMapping classPropertyMapping) {
            this.classPropertyMappings.add(classPropertyMapping);
        }

        public void onParentMapping(ClassMapping classMapping, ParentMapping parentMapping) {
        }

        public void onComponentMapping(ClassMapping classMapping, ComponentMapping componentMapping) {
        }

        public void onReferenceMapping(ClassMapping classMapping, ReferenceMapping referenceMapping) {
        }

        public void onConstantMetaDataMappaing(ClassMapping classMapping, ConstantMetaDataMapping constantMetaDataMapping) {
        }

        public void onClassPropertyMetaDataMapping(ClassPropertyMetaDataMapping classPropertyMetaDataMapping) {
        }

        public void onDynamicMetaDataMapping(ClassMapping classMapping, DynamicMetaDataMapping dynamicMetaDataMapping) {
        }

        public void onResourcePropertyMapping(ResourcePropertyMapping resourcePropertyMapping) {
            this.resourcePropertyMappings.add(resourcePropertyMapping);
        }
    }

    public static interface ClassMappingCallback {
        public void onBeginClassMapping(ClassMapping var1);

        public void onEndClassMapping(ClassMapping var1);

        public boolean onBeginMultipleMapping(ClassMapping var1, Mapping var2);

        public void onEndMultiplMapping(ClassMapping var1, Mapping var2);

        public void onBeginCollectionMapping(AbstractCollectionMapping var1);

        public void onEndCollectionMapping(AbstractCollectionMapping var1);

        public void onClassPropertyMapping(ClassMapping var1, ClassPropertyMapping var2);

        public void onComponentMapping(ClassMapping var1, ComponentMapping var2);

        public void onReferenceMapping(ClassMapping var1, ReferenceMapping var2);

        public void onParentMapping(ClassMapping var1, ParentMapping var2);

        public void onConstantMetaDataMappaing(ClassMapping var1, ConstantMetaDataMapping var2);

        public void onClassPropertyMetaDataMapping(ClassPropertyMetaDataMapping var1);

        public void onDynamicMetaDataMapping(ClassMapping var1, DynamicMetaDataMapping var2);

        public void onResourcePropertyMapping(ResourcePropertyMapping var1);
    }
}

