/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.transaction.manager;

import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.config.CompassSettings;
import org.compass.core.transaction.TransactionException;
import org.compass.core.transaction.TransactionManagerLookup;

public class WebSphere
implements TransactionManagerLookup {
    private static final Log log = LogFactory.getLog((Class)WebSphere.class);
    private int version;

    public TransactionManager getTransactionManager(CompassSettings settings) throws TransactionException {
        try {
            Class<?> clazz;
            try {
                clazz = Class.forName("com.ibm.ws.Transaction.TransactionManagerFactory");
                this.version = 5;
                log.debug((Object)"Found WebSphere 5.1+");
            }
            catch (Exception e) {
                try {
                    clazz = Class.forName("com.ibm.ejs.jts.jta.TransactionManagerFactory");
                    this.version = 5;
                    log.debug((Object)"Found WebSphere 5.0");
                }
                catch (Exception e2) {
                    clazz = Class.forName("com.ibm.ejs.jts.jta.JTSXA");
                    this.version = 4;
                    log.debug((Object)"Found WebSphere 4");
                }
            }
            return (TransactionManager)clazz.getMethod("getTransactionManager", null).invoke(null, null);
        }
        catch (Exception e) {
            throw new TransactionException("Could not obtain WebSphere JTSXA instance", e);
        }
    }

    public String getUserTransactionName() {
        return this.version == 5 ? "java:comp/UserTransaction" : "jta/usertransaction";
    }
}

