/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.compass.core.config.ConfigurationException;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class DTDEntityResolver
implements EntityResolver,
Serializable {
    private static final long serialVersionUID = 3256440291954406962L;
    private static final String URL = "http://www.opensymphony.com/compass/dtd/";
    private transient ClassLoader resourceLoader;

    public DTDEntityResolver() {
    }

    public DTDEntityResolver(ClassLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        if (systemId != null && systemId.startsWith("http://compass.sourceforge.net")) {
            throw new IllegalArgumentException("Using old format for DTD, please use the url [http://www.opensymphony.com/compass/dtd/]");
        }
        if (systemId != null && systemId.startsWith("http://static.compassframework")) {
            throw new IllegalArgumentException("Using old format for DTD, please use the url [http://www.opensymphony.com/compass/dtd/]");
        }
        if (systemId != null && systemId.startsWith(URL)) {
            InputStream dtdStream;
            String location = "/org/compass/core/" + systemId.substring(URL.length());
            InputStream inputStream = dtdStream = this.resourceLoader == null ? this.getClass().getResourceAsStream(location) : this.resourceLoader.getResourceAsStream(location);
            if (dtdStream == null) {
                throw new ConfigurationException("DTD system id [" + systemId + "] not found at [" + location + "], " + "please check it has the correct location. Have you included compass in your class path?");
            }
            InputSource source = new InputSource(dtdStream);
            source.setPublicId(publicId);
            source.setSystemId(systemId);
            return source;
        }
        throw new ConfigurationException("DTD system id [" + systemId + "] not found, please check it has the " + "correct location");
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.resourceLoader = this.getClass().getClassLoader();
    }
}

