/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.hibernate;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.compass.core.CompassCallbackWithoutResult;
import org.compass.core.CompassException;
import org.compass.core.CompassSession;
import org.compass.core.spi.InternalCompassSession;
import org.compass.core.util.ClassUtils;
import org.compass.core.util.FieldInvoker;
import org.compass.core.util.MethodInvoker;
import org.compass.gps.CompassGpsException;
import org.compass.gps.PassiveMirrorGpsDevice;
import org.compass.gps.device.hibernate.AbstractHibernateGpsDevice;
import org.compass.gps.device.hibernate.HibernateGpsDeviceException;
import org.compass.gps.device.hibernate.HibernateMirrorFilter;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.event.PostDeleteEvent;
import org.hibernate.event.PostDeleteEventListener;
import org.hibernate.event.PostInsertEvent;
import org.hibernate.event.PostInsertEventListener;
import org.hibernate.event.PostUpdateEvent;
import org.hibernate.event.PostUpdateEventListener;
import org.hibernate.impl.SessionFactoryImpl;
import org.hibernate.metadata.ClassMetadata;

public class Hibernate3GpsDevice
extends AbstractHibernateGpsDevice
implements PassiveMirrorGpsDevice {
    private boolean mirrorDataChanges = true;
    private SessionFactory sessionFactory;
    private Configuration configuration;
    private HibernateMirrorFilter mirrorFilter;
    private boolean ignoreMirrorExceptions;

    public Hibernate3GpsDevice() {
    }

    public Hibernate3GpsDevice(String name, SessionFactory sessionFactory) {
        this.setName(name);
        this.sessionFactory = sessionFactory;
    }

    public Hibernate3GpsDevice(String name, Configuration configuration) {
        this.setName(name);
        this.configuration = configuration;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setMirrorFilter(HibernateMirrorFilter mirrorFilter) {
        this.mirrorFilter = mirrorFilter;
    }

    protected void doStart() throws CompassGpsException {
        super.doStart();
        if (this.sessionFactory == null) {
            if (this.configuration == null) {
                throw new HibernateGpsDeviceException(this.buildMessage("Must set configuration or sessionFactory"));
            }
            try {
                this.sessionFactory = this.configuration.buildSessionFactory();
            }
            catch (HibernateException e) {
                throw new HibernateGpsDeviceException(this.buildMessage("Failed to create session factory"), e);
            }
        }
        if (this.isMirrorDataChanges()) {
            SessionFactory actualSessionFactory = this.doGetActualSessionFactory();
            try {
                ClassUtils.forName("org.hibernate.event.SessionEventListenerConfig");
                this.registerEventsForHibernate30(actualSessionFactory);
            }
            catch (ClassNotFoundException e) {
                this.registerEventsForHibernate31(actualSessionFactory);
            }
        }
    }

    protected void doStop() throws CompassGpsException {
    }

    protected SessionFactory doGetActualSessionFactory() {
        return this.sessionFactory;
    }

    public boolean isMirrorDataChanges() {
        return this.mirrorDataChanges;
    }

    public void setMirrorDataChanges(boolean mirrorDataChanges) {
        this.mirrorDataChanges = mirrorDataChanges;
    }

    public boolean isIgnoreMirrorExceptions() {
        return this.ignoreMirrorExceptions;
    }

    public void setIgnoreMirrorExceptions(boolean ignoreMirrorExceptions) {
        this.ignoreMirrorExceptions = ignoreMirrorExceptions;
    }

    protected AbstractHibernateGpsDevice.HibernateSessionWrapper doGetHibernateSessionWrapper() {
        return new Hibernate3SessionWrapper(this.sessionFactory);
    }

    protected AbstractHibernateGpsDevice.HibernateEntityInfo[] doGetHibernateEntitiesInfo() throws HibernateGpsDeviceException {
        ArrayList<String> classesToIndex = new ArrayList<String>();
        try {
            Map allClassMetaData = this.sessionFactory.getAllClassMetadata();
            Iterator it = allClassMetaData.keySet().iterator();
            while (it.hasNext()) {
                Class mappedClass;
                Class superClass;
                String entityname = (String)it.next();
                ClassMetadata classMetadata = (ClassMetadata)allClassMetaData.get(entityname);
                if (this.isInherited(classMetadata) && (superClass = (mappedClass = classMetadata.getMappedClass(EntityMode.POJO)).getSuperclass()) != null && this.compassGps.hasMappingForEntityForIndex(superClass)) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug((Object)this.buildMessage("entity [" + entityname + "] is inherited and super class [" + superClass + "] has compass mapping, filtering it out"));
                    continue;
                }
                if (this.isFilteredForIndex(entityname)) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug((Object)this.buildMessage("entity [" + entityname + "] is marked to be filtered, filtering it out"));
                    continue;
                }
                if (this.compassGps.hasMappingForEntityForIndex(entityname)) {
                    classesToIndex.add(entityname);
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug((Object)this.buildMessage("entity [" + entityname + "] will be indexed"));
                    continue;
                }
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)this.buildMessage("entity [" + entityname + "] does not have compass mapping, filtering it out"));
            }
        }
        catch (Exception e) {
            throw new HibernateGpsDeviceException(this.buildMessage("Failed to fetch all class meta data"), e);
        }
        AbstractHibernateGpsDevice.HibernateEntityInfo[] infos = new AbstractHibernateGpsDevice.HibernateEntityInfo[classesToIndex.size()];
        for (int i = 0; i < infos.length; ++i) {
            infos[i] = new AbstractHibernateGpsDevice.HibernateEntityInfo();
            infos[i].entityname = (String)classesToIndex.get(i);
            infos[i].selectQuery = "from " + infos[i].entityname;
        }
        return infos;
    }

    protected List doGetObjects(AbstractHibernateGpsDevice.HibernateEntityInfo info, int from, int count, AbstractHibernateGpsDevice.HibernateSessionWrapper sessionWrapper) throws HibernateGpsDeviceException {
        List values;
        Session session = ((Hibernate3SessionWrapper)sessionWrapper).getSession();
        try {
            Query query = session.createQuery(info.selectQuery).setFirstResult(from).setMaxResults(count);
            values = query.list();
        }
        catch (Exception e) {
            throw new HibernateGpsDeviceException(this.buildMessage("Failed to open session to fetch data for class [" + info.entityname + "]"), e);
        }
        return values;
    }

    private void registerEventsForHibernate30(SessionFactory sessionFactory) {
        try {
            Class sessionEventListenerConfigClass = ClassUtils.forName("org.hibernate.event.SessionEventListenerConfig");
            FieldInvoker sessionFactorySessionEventListenerConfig = new FieldInvoker(SessionFactoryImpl.class, "sessionEventListenerConfig").prepare();
            Object sessionEventListenerConfig = sessionFactorySessionEventListenerConfig.get(sessionFactory);
            FieldInvoker eventListener = new FieldInvoker(sessionEventListenerConfigClass, "postInsertEventListener").prepare();
            eventListener.set(sessionEventListenerConfig, new Hibernate3GpsDevicePostInsert((PostInsertEventListener)eventListener.get(sessionEventListenerConfig), this.mirrorFilter));
            eventListener = new FieldInvoker(sessionEventListenerConfigClass, "postUpdateEventListener").prepare();
            eventListener.set(sessionEventListenerConfig, new Hibernate3GpsDevicePostUpdate((PostUpdateEventListener)eventListener.get(sessionEventListenerConfig), this.mirrorFilter));
            eventListener = new FieldInvoker(sessionEventListenerConfigClass, "postDeleteEventListener").prepare();
            eventListener.set(sessionEventListenerConfig, new Hibernate3GpsDevicePostDelete((PostDeleteEventListener)eventListener.get(sessionEventListenerConfig), this.mirrorFilter));
        }
        catch (Exception e) {
            throw new HibernateGpsDeviceException(this.buildMessage("Failed to inject compass gps device events into hibernate 3.0 session factory [" + sessionFactory.getClass().getName() + "]"), e);
        }
    }

    private void registerEventsForHibernate31(SessionFactory sessionFactory) {
        try {
            Class eventListenersClass = ClassUtils.forName("org.hibernate.event.EventListeners");
            Object eventListeners = new FieldInvoker(SessionFactoryImpl.class, "eventListeners").prepare().get(sessionFactory);
            FieldInvoker eventListener = new FieldInvoker(eventListenersClass, "postInsertEventListeners").prepare();
            PostInsertEventListener[] postInsertEventListener = (PostInsertEventListener[])eventListener.get(eventListeners);
            PostInsertEventListener[] tempPostInsertEventListener = new PostInsertEventListener[postInsertEventListener.length + 1];
            System.arraycopy(postInsertEventListener, 0, tempPostInsertEventListener, 0, postInsertEventListener.length);
            tempPostInsertEventListener[postInsertEventListener.length] = new Hibernate3GpsDevicePostInsert(null, this.mirrorFilter);
            eventListener.set(eventListeners, tempPostInsertEventListener);
            eventListener = new FieldInvoker(eventListenersClass, "postUpdateEventListeners").prepare();
            PostUpdateEventListener[] postUpdateEventListener = (PostUpdateEventListener[])eventListener.get(eventListeners);
            PostUpdateEventListener[] tempPostUpdateEventListener = new PostUpdateEventListener[postUpdateEventListener.length + 1];
            System.arraycopy(postUpdateEventListener, 0, tempPostUpdateEventListener, 0, postUpdateEventListener.length);
            tempPostUpdateEventListener[postUpdateEventListener.length] = new Hibernate3GpsDevicePostUpdate(null, this.mirrorFilter);
            eventListener.set(eventListeners, tempPostUpdateEventListener);
            eventListener = new FieldInvoker(eventListenersClass, "postDeleteEventListeners").prepare();
            PostDeleteEventListener[] postDeleteEventListener = (PostDeleteEventListener[])eventListener.get(eventListeners);
            PostDeleteEventListener[] tempPostDeleteEventListener = new PostDeleteEventListener[postDeleteEventListener.length + 1];
            System.arraycopy(postDeleteEventListener, 0, tempPostDeleteEventListener, 0, postDeleteEventListener.length);
            tempPostDeleteEventListener[postDeleteEventListener.length] = new Hibernate3GpsDevicePostDelete(null, this.mirrorFilter);
            eventListener.set(eventListeners, tempPostDeleteEventListener);
        }
        catch (Exception e) {
            throw new HibernateGpsDeviceException(this.buildMessage("Failed to inject compass gps device events into hibernate 3.1 session factory [" + sessionFactory.getClass().getName() + "]"), e);
        }
    }

    protected boolean isInherited(ClassMetadata classMetadata) throws HibernateGpsDeviceException {
        try {
            return classMetadata.isInherited();
        }
        catch (Throwable t) {
            try {
                ClassUtils.forName("org.hibernate.event.SessionEventListenerConfig");
                return this.isInherited30(classMetadata);
            }
            catch (ClassNotFoundException e) {
                return this.isInherited31(classMetadata);
            }
        }
    }

    private boolean isInherited30(ClassMetadata classMetadata) throws HibernateGpsDeviceException {
        try {
            Class basicEntityPersisterClass = ClassUtils.forName("org.hibernate.persister.entity.BasicEntityPersister");
            Object entityMetamodel = new FieldInvoker(basicEntityPersisterClass, "entityMetamodel").prepare().get(classMetadata);
            MethodInvoker isInheritedMethodInvoker = new MethodInvoker();
            isInheritedMethodInvoker.setTargetObject(entityMetamodel);
            isInheritedMethodInvoker.setTargetMethod("isInherited");
            Boolean isInherited = (Boolean)isInheritedMethodInvoker.prepare().invoke();
            return isInherited;
        }
        catch (Exception e) {
            throw new HibernateGpsDeviceException(this.buildMessage("Failed to check for inheritence for 3.0"), e);
        }
    }

    private boolean isInherited31(ClassMetadata classMetadata) throws HibernateGpsDeviceException {
        try {
            Class abstractEntityPersisterClass = ClassUtils.forName("org.hibernate.persister.entity.AbstractEntityPersister");
            Object entityMetamodel = new FieldInvoker(abstractEntityPersisterClass, "entityMetamodel").prepare().get(classMetadata);
            MethodInvoker isInheritedMethodInvoker = new MethodInvoker();
            isInheritedMethodInvoker.setTargetObject(entityMetamodel);
            isInheritedMethodInvoker.setTargetMethod("isInherited");
            Boolean isInherited = (Boolean)isInheritedMethodInvoker.prepare().invoke();
            return isInherited;
        }
        catch (Exception e) {
            throw new HibernateGpsDeviceException(this.buildMessage("Failed to check for inheritence for 3.1"), e);
        }
    }

    private class Hibernate3GpsDevicePostDelete
    implements PostDeleteEventListener {
        private static final long serialVersionUID = 3258126955726385720L;
        private PostDeleteEventListener postDeleteEventListener;
        private HibernateMirrorFilter mirrorFilter;

        public Hibernate3GpsDevicePostDelete(PostDeleteEventListener postDeleteEventListener, HibernateMirrorFilter mirrorFilter) {
            this.postDeleteEventListener = postDeleteEventListener;
            this.mirrorFilter = mirrorFilter;
        }

        public void onPostDelete(PostDeleteEvent postDeleteEvent) {
            if (this.postDeleteEventListener != null) {
                this.postDeleteEventListener.onPostDelete(postDeleteEvent);
            }
            if (!Hibernate3GpsDevice.this.shouldMirrorDataChanges() || Hibernate3GpsDevice.this.isPerformingIndexOperation()) {
                return;
            }
            final Object entity = postDeleteEvent.getEntity();
            if (!Hibernate3GpsDevice.this.compassGps.hasMappingForEntityForMirror(entity.getClass())) {
                return;
            }
            if (this.mirrorFilter != null && this.mirrorFilter.shouldFilterDelete(postDeleteEvent)) {
                return;
            }
            try {
                if (Hibernate3GpsDevice.this.log.isDebugEnabled()) {
                    Hibernate3GpsDevice.this.log.debug((Object)Hibernate3GpsDevice.this.buildMessage("Deleting [" + entity + "]"));
                }
                Hibernate3GpsDevice.this.compassGps.executeForMirror(new CompassCallbackWithoutResult(){

                    protected void doInCompassWithoutResult(CompassSession session) throws CompassException {
                        session.delete(entity);
                    }
                });
            }
            catch (Exception e) {
                if (Hibernate3GpsDevice.this.isIgnoreMirrorExceptions()) {
                    Hibernate3GpsDevice.this.log.error((Object)Hibernate3GpsDevice.this.buildMessage("Failed while deleting [" + entity + "]"), (Throwable)e);
                }
                throw new HibernateGpsDeviceException(Hibernate3GpsDevice.this.buildMessage("Failed while deleting [" + entity + "]"), e);
            }
        }
    }

    private class Hibernate3GpsDevicePostUpdate
    implements PostUpdateEventListener {
        private static final long serialVersionUID = 3833181428363113528L;
        private PostUpdateEventListener postUpdateEventListener;
        private HibernateMirrorFilter mirrorFilter;

        public Hibernate3GpsDevicePostUpdate(PostUpdateEventListener postUpdateEventListener, HibernateMirrorFilter mirrorFilter) {
            this.postUpdateEventListener = postUpdateEventListener;
            this.mirrorFilter = mirrorFilter;
        }

        public void onPostUpdate(PostUpdateEvent postUpdateEvent) {
            if (this.postUpdateEventListener != null) {
                this.postUpdateEventListener.onPostUpdate(postUpdateEvent);
            }
            if (!Hibernate3GpsDevice.this.shouldMirrorDataChanges() || Hibernate3GpsDevice.this.isPerformingIndexOperation()) {
                return;
            }
            final Object entity = postUpdateEvent.getEntity();
            if (!Hibernate3GpsDevice.this.compassGps.hasMappingForEntityForMirror(entity.getClass())) {
                return;
            }
            if (this.mirrorFilter != null && this.mirrorFilter.shouldFilterUpdate(postUpdateEvent)) {
                return;
            }
            try {
                if (Hibernate3GpsDevice.this.log.isDebugEnabled()) {
                    Hibernate3GpsDevice.this.log.debug((Object)Hibernate3GpsDevice.this.buildMessage("Updating [" + entity + "]"));
                }
                Hibernate3GpsDevice.this.compassGps.executeForMirror(new CompassCallbackWithoutResult(){

                    protected void doInCompassWithoutResult(CompassSession session) throws CompassException {
                        session.save(entity);
                    }
                });
            }
            catch (Exception e) {
                if (Hibernate3GpsDevice.this.isIgnoreMirrorExceptions()) {
                    Hibernate3GpsDevice.this.log.error((Object)Hibernate3GpsDevice.this.buildMessage("Failed while updating [" + entity + "]"), (Throwable)e);
                }
                throw new HibernateGpsDeviceException(Hibernate3GpsDevice.this.buildMessage("Failed while updating [" + entity + "]"), e);
            }
        }
    }

    private class Hibernate3GpsDevicePostInsert
    implements PostInsertEventListener {
        private static final long serialVersionUID = 3544677273799308593L;
        private PostInsertEventListener postInsertEventListener;
        private HibernateMirrorFilter mirrorFilter;

        public Hibernate3GpsDevicePostInsert(PostInsertEventListener postInsertEventListener, HibernateMirrorFilter mirrorFilter) {
            this.postInsertEventListener = postInsertEventListener;
            this.mirrorFilter = mirrorFilter;
        }

        public void onPostInsert(final PostInsertEvent postInsertEvent) {
            if (this.postInsertEventListener != null) {
                this.postInsertEventListener.onPostInsert(postInsertEvent);
            }
            if (!Hibernate3GpsDevice.this.shouldMirrorDataChanges() || Hibernate3GpsDevice.this.isPerformingIndexOperation()) {
                return;
            }
            final Object entity = postInsertEvent.getEntity();
            if (!Hibernate3GpsDevice.this.compassGps.hasMappingForEntityForMirror(entity.getClass())) {
                return;
            }
            if (this.mirrorFilter != null && this.mirrorFilter.shouldFilterInsert(postInsertEvent)) {
                return;
            }
            try {
                if (Hibernate3GpsDevice.this.log.isDebugEnabled()) {
                    Hibernate3GpsDevice.this.log.debug((Object)Hibernate3GpsDevice.this.buildMessage("Creating [" + entity + "]"));
                }
                Hibernate3GpsDevice.this.compassGps.executeForMirror(new CompassCallbackWithoutResult(){

                    protected void doInCompassWithoutResult(CompassSession session) throws CompassException {
                        ((InternalCompassSession)session).getMarshallingStrategy().marshallIds(entity, (Object)postInsertEvent.getId());
                        session.create(entity);
                    }
                });
            }
            catch (Exception e) {
                if (Hibernate3GpsDevice.this.isIgnoreMirrorExceptions()) {
                    Hibernate3GpsDevice.this.log.error((Object)Hibernate3GpsDevice.this.buildMessage("Failed while creating [" + entity + "]"), (Throwable)e);
                }
                throw new HibernateGpsDeviceException(Hibernate3GpsDevice.this.buildMessage("Failed while creating [" + entity + "]"), e);
            }
        }
    }

    private class Hibernate3SessionWrapper
    implements AbstractHibernateGpsDevice.HibernateSessionWrapper {
        private SessionFactory sessionFactory;
        private Session session;
        private Transaction tr;

        public Hibernate3SessionWrapper(SessionFactory sessionFactory) {
            this.sessionFactory = sessionFactory;
        }

        public Session getSession() {
            return this.session;
        }

        public void open() throws HibernateGpsDeviceException {
            try {
                this.session = this.sessionFactory.openSession();
            }
            catch (HibernateException e) {
                throw new HibernateGpsDeviceException(Hibernate3GpsDevice.this.buildMessage("Failed to open session to fetch data"), e);
            }
            try {
                this.tr = this.session.beginTransaction();
            }
            catch (HibernateException e) {
                throw new HibernateGpsDeviceException(Hibernate3GpsDevice.this.buildMessage("Failed to begin transaction to fetch data"), e);
            }
        }

        public void close() {
            if (this.tr != null) {
                try {
                    this.tr.commit();
                }
                catch (HibernateException e) {
                    throw new HibernateGpsDeviceException("Failed to commit hibernate transaction");
                }
            }
            try {
                this.session.close();
            }
            catch (HibernateException e) {
                Hibernate3GpsDevice.this.log.error((Object)"Failed to close Hibernate session", (Throwable)e);
            }
        }

        public void closeOnError() {
            if (this.tr != null) {
                try {
                    this.tr.rollback();
                }
                catch (HibernateException e1) {
                    Hibernate3GpsDevice.this.log.error((Object)Hibernate3GpsDevice.this.buildMessage("Failed to rollback hibernate transaction"), (Throwable)e1);
                }
            }
            try {
                this.session.close();
            }
            catch (HibernateException e) {
                Hibernate3GpsDevice.this.log.error((Object)Hibernate3GpsDevice.this.buildMessage("Failed to close Hibernate session"), (Throwable)e);
            }
        }
    }
}

