/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.jpa;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Query;
import org.compass.core.CompassSession;
import org.compass.core.util.Assert;
import org.compass.gps.CompassGpsException;
import org.compass.gps.PassiveMirrorGpsDevice;
import org.compass.gps.device.AbstractGpsDevice;
import org.compass.gps.device.jpa.DefaultEntityManagerWrapper;
import org.compass.gps.device.jpa.DefaultJpaQueryProvider;
import org.compass.gps.device.jpa.EntityManagerWrapper;
import org.compass.gps.device.jpa.JpaGpsDeviceException;
import org.compass.gps.device.jpa.JpaQueryProvider;
import org.compass.gps.device.jpa.NativeEntityManagerFactoryExtractor;
import org.compass.gps.device.jpa.entities.EntityInformation;
import org.compass.gps.device.jpa.entities.JpaEntitiesLocator;
import org.compass.gps.device.jpa.entities.JpaEntitiesLocatorDetector;
import org.compass.gps.device.jpa.lifecycle.JpaEntityLifecycleInjector;
import org.compass.gps.device.jpa.lifecycle.JpaEntityLifecycleInjectorDetector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaGpsDevice
extends AbstractGpsDevice
implements PassiveMirrorGpsDevice {
    private boolean mirrorDataChanges = true;
    private int fetchCount = 200;
    private EntityManagerFactory entityManagerFactory;
    private EntityManagerWrapper entityManagerWrapper;
    private JpaEntityLifecycleInjector lifecycleInjector;
    private boolean injectEntityLifecycleListener;
    private NativeEntityManagerFactoryExtractor nativeEntityManagerFactoryExtractor;
    private JpaEntitiesLocator entitiesLocator;
    private EntityInformation[] entetiesInformation;
    private Map<Class<?>, JpaQueryProvider> queryProviderByClass = new HashMap();
    private Map<String, JpaQueryProvider> queryProviderByName = new HashMap<String, JpaQueryProvider>();

    public JpaGpsDevice() {
    }

    public JpaGpsDevice(String name, EntityManagerFactory entityManagerFactory) {
        this.setName(name);
        this.setEntityManagerFactory(entityManagerFactory);
    }

    @Override
    protected void doStart() throws CompassGpsException {
        Assert.notNull(this.entityManagerFactory, this.buildMessage("Must set JPA EntityManagerFactory"));
        if (this.entityManagerWrapper == null) {
            this.entityManagerWrapper = new DefaultEntityManagerWrapper();
        }
        this.entityManagerWrapper.setUp(this.entityManagerFactory);
        EntityManagerFactory nativeEntityManagerFactory = this.entityManagerFactory;
        if (this.nativeEntityManagerFactoryExtractor != null) {
            if ((nativeEntityManagerFactory = this.nativeEntityManagerFactoryExtractor.extractNative(nativeEntityManagerFactory)) == null) {
                throw new JpaGpsDeviceException(this.buildMessage("Native EntityManager extractor returned null"));
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)this.buildMessage("Using native EntityManagerFactory [" + nativeEntityManagerFactory.getClass().getName() + "] extracted by [" + this.nativeEntityManagerFactoryExtractor.getClass().getName() + "]"));
            }
        }
        if (this.entitiesLocator == null) {
            this.entitiesLocator = JpaEntitiesLocatorDetector.detectLocator(nativeEntityManagerFactory);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)this.buildMessage("Using index entityLocator [" + this.entitiesLocator.getClass().getName() + "]"));
            }
        }
        for (EntityInformation entityInformation : this.entetiesInformation = this.entitiesLocator.locate(nativeEntityManagerFactory, this)) {
            if (this.queryProviderByClass.get(entityInformation.getEntityClass()) != null) {
                entityInformation.setQueryProvider(this.queryProviderByClass.get(entityInformation.getEntityClass()));
            }
            if (this.queryProviderByName.get(entityInformation.getEntityName()) == null) continue;
            entityInformation.setQueryProvider(this.queryProviderByName.get(entityInformation.getEntityName()));
        }
        if (this.injectEntityLifecycleListener && this.mirrorDataChanges) {
            if (this.lifecycleInjector == null) {
                this.lifecycleInjector = JpaEntityLifecycleInjectorDetector.detectInjector(nativeEntityManagerFactory);
            }
            if (this.lifecycleInjector == null) {
                throw new JpaGpsDeviceException(this.buildMessage("Failed to locate lifecycleInjector"));
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)this.buildMessage("Using lifecycleInjector [" + this.lifecycleInjector.getClass().getName() + "]"));
            }
            this.lifecycleInjector.injectLifecycle(nativeEntityManagerFactory, this);
        }
    }

    @Override
    protected void doIndex(CompassSession session) throws CompassGpsException {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)this.buildMessage("Indexing the database with fetch count [" + this.fetchCount + "]"));
        }
        for (EntityInformation entityInformation : this.entetiesInformation) {
            if (this.isFilteredForIndex(entityInformation.getEntityName())) continue;
            try {
                int current = 0;
                this.entityManagerWrapper.open();
                EntityManager entityManager = this.entityManagerWrapper.getEntityManager();
                while (true) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)this.buildMessage("Indexing entities [" + entityInformation.getEntityName() + "] range [" + current + "-" + (current + this.fetchCount) + "] using query [" + entityInformation.getQueryProvider() + "]"));
                    }
                    Query query = entityInformation.getQueryProvider().createQuery(entityManager, entityInformation);
                    query.setFirstResult(current);
                    query.setMaxResults(this.fetchCount);
                    List results = query.getResultList();
                    for (Object result : results) {
                        session.create(result);
                    }
                    session.evictAll();
                    entityManager.clear();
                    if (results.size() < this.fetchCount) break;
                    current += this.fetchCount;
                }
                this.entityManagerWrapper.close();
            }
            catch (Exception e) {
                this.log.error((Object)this.buildMessage("Failed to index the database"), (Throwable)e);
                this.entityManagerWrapper.closeOnError();
                if (!(e instanceof JpaGpsDeviceException)) {
                    throw new JpaGpsDeviceException(this.buildMessage("Failed to index the database"), e);
                }
                throw (JpaGpsDeviceException)e;
            }
        }
    }

    @Override
    public boolean isMirrorDataChanges() {
        return this.mirrorDataChanges;
    }

    @Override
    public void setMirrorDataChanges(boolean mirrorDataChanges) {
        this.mirrorDataChanges = mirrorDataChanges;
    }

    public void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public void setEntityManagerWrapper(EntityManagerWrapper entityManagerWrapper) {
        this.entityManagerWrapper = entityManagerWrapper;
    }

    public void setNativeEntityManagerFactoryExtractor(NativeEntityManagerFactoryExtractor nativeEntityManagerFactoryExtractor) {
        this.nativeEntityManagerFactoryExtractor = nativeEntityManagerFactoryExtractor;
    }

    public void setInjectEntityLifecycleListener(boolean injectEntityLifecycleListener) {
        this.injectEntityLifecycleListener = injectEntityLifecycleListener;
    }

    public void setLifecycleInjector(JpaEntityLifecycleInjector lifecycleInjector) {
        this.lifecycleInjector = lifecycleInjector;
    }

    public void setEntitiesLocator(JpaEntitiesLocator entitiesLocator) {
        this.entitiesLocator = entitiesLocator;
    }

    public void setFetchCount(int fetchCount) {
        this.fetchCount = fetchCount;
    }

    public void setIndexSelectQuery(Class<?> entityClass, String selectQuery) {
        this.setIndexQueryProvider(entityClass, (JpaQueryProvider)new DefaultJpaQueryProvider(selectQuery));
    }

    public void setIndexSelectQuery(String entityName, String selectQuery) {
        this.setIndexQueryProvider(entityName, (JpaQueryProvider)new DefaultJpaQueryProvider(selectQuery));
    }

    public void setIndexQueryProvider(Class<?> entityClass, JpaQueryProvider queryProvider) {
        this.queryProviderByClass.put(entityClass, queryProvider);
    }

    public void setIndexQueryProvider(String entityName, JpaQueryProvider queryProvider) {
        this.queryProviderByName.put(entityName, queryProvider);
    }
}

