/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.impl;

import java.util.Iterator;
import java.util.Properties;
import org.compass.core.Compass;
import org.compass.core.CompassCallback;
import org.compass.core.CompassException;
import org.compass.core.CompassTemplate;
import org.compass.core.CompassTransaction;
import org.compass.core.config.CompassSettings;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.engine.SearchEngineIndexManager;
import org.compass.core.lucene.engine.LuceneSearchEngineFactory;
import org.compass.core.spi.InternalCompass;
import org.compass.gps.CompassGpsDevice;
import org.compass.gps.CompassGpsException;
import org.compass.gps.impl.AbstractCompassGps;

public class SingleCompassGps
extends AbstractCompassGps {
    private Compass compass;
    private CompassTemplate compassTemplate;
    private Compass indexCompass;
    private CompassTemplate indexCompassTemplate;
    private CompassTransaction.TransactionIsolation indexTransactionIsolation = CompassTransaction.TransactionIsolation.BATCH_INSERT;
    private Properties indexSettings;
    private CompassSettings indexCompassSettings;

    public SingleCompassGps() {
    }

    public SingleCompassGps(Compass compass) {
        this.compass = compass;
    }

    protected void doStart() throws CompassGpsException {
        if (this.compass == null) {
            throw new IllegalArgumentException("Must set the compass property");
        }
        CompassTransaction.TransactionIsolation defaultIsolation = ((LuceneSearchEngineFactory)((InternalCompass)this.compass).getSearchEngineFactory()).getLuceneSettings().getTransactionIsolation();
        if (defaultIsolation == CompassTransaction.TransactionIsolation.BATCH_INSERT) {
            throw new IllegalArgumentException("The compass instance is configured with transaction isolation of batch_insert, there is no need since this CompassGps will execute the index operation with batch_index automatically,  and mirroring with the configured transaction isolation");
        }
        this.indexCompassSettings = new CompassSettings();
        if (this.indexSettings != null) {
            this.indexCompassSettings.addSettings(this.indexSettings);
        }
        if (this.indexCompassSettings.getSetting("compass.engine.connection.subContext") == null) {
            this.indexCompassSettings.setSetting("compass.engine.connection.subContext", "gpsindex");
        }
        this.indexCompassSettings.setBooleanSetting("compass.transaction.disableAutoJoinSession", true);
        this.compassTemplate = new CompassTemplate(this.compass);
    }

    protected void doStop() throws CompassGpsException {
    }

    protected void doIndex() throws CompassGpsException {
        boolean stoppedOptimizer = false;
        boolean stoppedIndexManager = false;
        if (this.compass.getSearchEngineOptimizer().isRunning()) {
            this.compass.getSearchEngineOptimizer().stop();
            stoppedOptimizer = true;
        }
        if (this.compass.getSearchEngineIndexManager().isRunning()) {
            this.compass.getSearchEngineIndexManager().stop();
            stoppedIndexManager = true;
        }
        this.indexCompass = this.compass.clone(this.indexCompassSettings);
        this.indexCompass.getSearchEngineIndexManager().deleteIndex();
        this.indexCompass.getSearchEngineIndexManager().createIndex();
        this.indexCompassTemplate = new CompassTemplate(this.indexCompass);
        this.indexCompass.getSearchEngineIndexManager().clearCache();
        this.compass.getSearchEngineIndexManager().replaceIndex(this.indexCompass.getSearchEngineIndexManager(), new SearchEngineIndexManager.ReplaceIndexCallback(){

            public void buildIndexIfNeeded() throws SearchEngineException {
                Iterator it = SingleCompassGps.this.devices.values().iterator();
                while (it.hasNext()) {
                    CompassGpsDevice device = (CompassGpsDevice)it.next();
                    device.index();
                }
            }
        });
        this.indexCompass.getSearchEngineIndexManager().clearCache();
        try {
            this.indexCompass.getSearchEngineIndexManager().deleteIndex();
        }
        catch (CompassException e) {
            this.log.debug((Object)"Failed to delete gps index after indexing, ignoring", (Throwable)e);
        }
        this.indexCompass.close();
        this.indexCompass = null;
        this.indexCompassTemplate = null;
        if (stoppedOptimizer) {
            this.compass.getSearchEngineOptimizer().start();
        }
        if (stoppedIndexManager) {
            this.compass.getSearchEngineIndexManager().start();
        }
    }

    public void executeForIndex(CompassCallback callback) throws CompassException {
        if (this.indexCompassTemplate == null) {
            this.compassTemplate.execute(this.indexTransactionIsolation, callback);
            return;
        }
        this.indexCompassTemplate.execute(this.indexTransactionIsolation, callback);
    }

    public void executeForMirror(CompassCallback callback) throws CompassException {
        this.compassTemplate.execute(callback);
    }

    public boolean hasMappingForEntityForIndex(Class clazz) throws CompassException {
        return this.hasMappingForEntity(clazz, this.getIndexCompass());
    }

    public boolean hasMappingForEntityForIndex(String name) throws CompassException {
        return this.hasMappingForEntity(name, this.getIndexCompass());
    }

    public boolean hasMappingForEntityForMirror(Class clazz) throws CompassException {
        return this.hasMappingForEntity(clazz, this.compass);
    }

    public boolean hasMappingForEntityForMirror(String name) throws CompassException {
        return this.hasMappingForEntity(name, this.compass);
    }

    public Compass getIndexCompass() {
        if (this.indexCompass == null) {
            return this.compass;
        }
        return this.indexCompass;
    }

    public Compass getMirrorCompass() {
        return this.compass;
    }

    public void setCompass(Compass compass) {
        this.compass = compass;
    }

    public void setIndexTransactionIsolation(CompassTransaction.TransactionIsolation indexTransactionIsolation) {
        this.indexTransactionIsolation = indexTransactionIsolation;
    }

    public void setIndexSettings(Properties indexSettings) {
        this.indexSettings = indexSettings;
    }

    public void setIndexSettings(CompassSettings indexSettings) {
        this.indexSettings = indexSettings.getProperties();
    }
}

