/*
 * Decompiled with CFR 0.152.
 */
package org.compass.spring.transaction;

import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.compass.core.CompassException;
import org.compass.core.CompassSession;
import org.compass.core.CompassTransaction;
import org.compass.core.config.CompassSettings;
import org.compass.core.spi.InternalCompassSession;
import org.compass.core.transaction.AbstractTransactionFactory;
import org.compass.core.transaction.InternalCompassTransaction;
import org.compass.core.transaction.TransactionException;
import org.compass.spring.transaction.SpringSyncTransaction;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.ExistingSpringTxCompassHelper;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class SpringSyncTransactionFactory
extends AbstractTransactionFactory {
    private static ThreadLocal transactionManagerHolder = new ThreadLocal();
    private static String transactionManagerKey = SpringSyncTransactionFactory.class.getName();
    private PlatformTransactionManager transactionManager;
    private transient Map currentSessionMap = new Hashtable();

    public static void setTransactionManager(PlatformTransactionManager transactionManager) {
        transactionManagerHolder.set(transactionManager);
    }

    protected void doConfigure(CompassSettings settings) {
        this.transactionManager = (PlatformTransactionManager)transactionManagerHolder.get();
        if (this.transactionManager == null) {
            this.transactionManager = (PlatformTransactionManager)settings.getRegistry(transactionManagerKey);
        }
        if (this.transactionManager != null) {
            settings.setRegistry(transactionManagerKey, this.transactionManager);
        }
        transactionManagerHolder.set(null);
    }

    protected boolean isWithinExistingTransaction(InternalCompassSession session) throws CompassException {
        return ExistingSpringTxCompassHelper.isExistingTransaction(this.transactionManager);
    }

    protected InternalCompassTransaction doBeginTransaction(InternalCompassSession session, CompassTransaction.TransactionIsolation transactionIsolation) throws CompassException {
        SpringSyncTransaction tr = new SpringSyncTransaction();
        tr.begin(this.transactionManager, session, transactionIsolation, this.commitBeforeCompletion);
        return tr;
    }

    protected InternalCompassTransaction doContinueTransaction(InternalCompassSession session) throws CompassException {
        SpringSyncTransaction tr = new SpringSyncTransaction();
        tr.join();
        return tr;
    }

    public CompassSession getTransactionBoundSession() throws CompassException {
        TransactionSynchronization sync = this.lookupTransactionSynchronization();
        if (sync == null) {
            return null;
        }
        return (CompassSession)this.currentSessionMap.get(sync);
    }

    protected void doBindSessionToTransaction(CompassTransaction tr, CompassSession session) throws CompassException {
        TransactionSynchronization sync = this.lookupTransactionSynchronization();
        if (sync == null) {
            throw new TransactionException("Failed to find compass registered spring synchronization");
        }
        this.currentSessionMap.put(sync, session);
    }

    public void unbindSessionFromTransaction(TransactionSynchronization sync) {
        this.currentSessionMap.remove(sync);
    }

    private TransactionSynchronization lookupTransactionSynchronization() throws TransactionException {
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            if (this.transactionManager == null) {
                throw new TransactionException("Either spring trnasction synchronization is not active, or a spring transaction has not been started, you might want to check if transactionManager is set on LocalCompassBean configuration, so compass can start one by itself");
            }
            return null;
        }
        List syncs = TransactionSynchronizationManager.getSynchronizations();
        for (int i = 0; i < syncs.size(); ++i) {
            SpringSyncTransaction.SpringTransactionSynchronization springSync;
            Object sync = syncs.get(i);
            if (!(sync instanceof SpringSyncTransaction.SpringTransactionSynchronization) || (springSync = (SpringSyncTransaction.SpringTransactionSynchronization)sync).getSession().getCompass() != this.compass) continue;
            return springSync;
        }
        return null;
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }
}

