/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import groovy.transform.Memoized;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.classgen.VariableScopeVisitor;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.AbstractASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;

@GroovyASTTransformation(phase=CompilePhase.SEMANTIC_ANALYSIS)
public class MemoizedASTTransformation
extends AbstractASTTransformation {
    private static final String CLOSURE_CALL_METHOD_NAME = "call";
    private static final Class<Memoized> MY_CLASS = Memoized.class;
    private static final ClassNode MY_TYPE = ClassHelper.make(MY_CLASS);
    private static final String MY_TYPE_NAME = "@" + MY_TYPE.getNameWithoutPackage();
    private static final String PROTECTED_CACHE_SIZE_NAME = "protectedCacheSize";
    private static final String MAX_CACHE_SIZE_NAME = "maxCacheSize";
    private static final String CLOSURE_LABEL = "Closure";
    private static final String METHOD_LABEL = "Priv";
    private static final String MEMOIZE_METHOD_NAME = "memoize";
    private static final String MEMOIZE_AT_MOST_METHOD_NAME = "memoizeAtMost";
    private static final String MEMOIZE_AT_LEAST_METHOD_NAME = "memoizeAtLeast";
    private static final String MEMOIZE_BETWEEN_METHOD_NAME = "memoizeBetween";

    public void visit(ASTNode[] nodes, SourceUnit source) {
        if (nodes == null) {
            return;
        }
        this.init(nodes, source);
        AnnotationNode annotationNode = (AnnotationNode)nodes[0];
        AnnotatedNode annotatedNode = (AnnotatedNode)nodes[1];
        if (MY_TYPE.equals(annotationNode.getClassNode()) && annotatedNode instanceof MethodNode) {
            MethodNode methodNode = (MethodNode)annotatedNode;
            if (methodNode.isAbstract()) {
                this.addError("Annotation " + MY_TYPE_NAME + " cannot be used for abstract methods.", methodNode);
                return;
            }
            if (methodNode.isVoidMethod()) {
                this.addError("Annotation " + MY_TYPE_NAME + " cannot be used for void methods.", methodNode);
                return;
            }
            ClassNode ownerClassNode = methodNode.getDeclaringClass();
            MethodNode privateMethod = this.buildPrivateDelegatingMethod(methodNode, ownerClassNode);
            ownerClassNode.addMethod(privateMethod);
            int modifiers = 18;
            if (methodNode.isStatic()) {
                modifiers |= 8;
            }
            int protectedCacheSize = this.getIntMemberValue(annotationNode, PROTECTED_CACHE_SIZE_NAME);
            int maxCacheSize = this.getIntMemberValue(annotationNode, MAX_CACHE_SIZE_NAME);
            MethodCallExpression memoizeClosureCallExpression = this.buildMemoizeClosureCallExpression(privateMethod, protectedCacheSize, maxCacheSize);
            String memoizedClosureFieldName = MemoizedASTTransformation.buildUniqueName(ownerClassNode, CLOSURE_LABEL, methodNode);
            FieldNode memoizedClosureField = new FieldNode(memoizedClosureFieldName, modifiers, ClassHelper.CLOSURE_TYPE.getPlainNodeReference(), null, memoizeClosureCallExpression);
            ownerClassNode.addField(memoizedClosureField);
            BlockStatement newCode = new BlockStatement();
            ArgumentListExpression args = new ArgumentListExpression(methodNode.getParameters());
            MethodCallExpression closureCallExpression = new MethodCallExpression((Expression)new FieldExpression(memoizedClosureField), CLOSURE_CALL_METHOD_NAME, (Expression)args);
            closureCallExpression.setImplicitThis(false);
            newCode.addStatement(new ReturnStatement(closureCallExpression));
            methodNode.setCode(newCode);
            VariableScopeVisitor visitor = new VariableScopeVisitor(source);
            visitor.visitClass(ownerClassNode);
        }
    }

    private static Parameter[] cloneParams(Parameter[] source) {
        Parameter[] result = new Parameter[source.length];
        for (int i = 0; i < source.length; ++i) {
            Parameter dstParam;
            Parameter srcParam = source[i];
            result[i] = dstParam = new Parameter(srcParam.getOriginType(), srcParam.getName());
        }
        return result;
    }

    private MethodNode buildPrivateDelegatingMethod(MethodNode annotatedMethod, ClassNode ownerClassNode) {
        Statement code = annotatedMethod.getCode();
        int access = 2;
        if (annotatedMethod.isStatic()) {
            access = 10;
        }
        MethodNode privateMethod = new MethodNode(MemoizedASTTransformation.buildUniqueName(ownerClassNode, METHOD_LABEL, annotatedMethod), access, annotatedMethod.getReturnType(), MemoizedASTTransformation.cloneParams(annotatedMethod.getParameters()), annotatedMethod.getExceptions(), code);
        List<AnnotationNode> sourceAnnotations = annotatedMethod.getAnnotations();
        privateMethod.addAnnotations(new ArrayList<AnnotationNode>(sourceAnnotations));
        return privateMethod;
    }

    private int getIntMemberValue(AnnotationNode node, String name) {
        Object value = this.getMemberValue(node, name);
        if (value != null && value instanceof Integer) {
            return (Integer)value;
        }
        return 0;
    }

    private MethodCallExpression buildMemoizeClosureCallExpression(MethodNode privateMethod, int protectedCacheSize, int maxCacheSize) {
        MethodCallExpression mce;
        Parameter[] srcParams = privateMethod.getParameters();
        Parameter[] newParams = MemoizedASTTransformation.cloneParams(srcParams);
        ArrayList<Expression> argList = new ArrayList<Expression>(newParams.length);
        for (int i = 0; i < srcParams.length; ++i) {
            argList.add(new VariableExpression(newParams[i]));
        }
        ClosureExpression expression = new ClosureExpression(newParams, new ExpressionStatement(new MethodCallExpression((Expression)new VariableExpression("this"), privateMethod.getName(), (Expression)new ArgumentListExpression(argList))));
        if (protectedCacheSize == 0 && maxCacheSize == 0) {
            mce = new MethodCallExpression((Expression)expression, MEMOIZE_METHOD_NAME, MethodCallExpression.NO_ARGUMENTS);
        } else if (protectedCacheSize == 0) {
            mce = new MethodCallExpression((Expression)expression, MEMOIZE_AT_MOST_METHOD_NAME, (Expression)new ArgumentListExpression(new ConstantExpression(maxCacheSize)));
        } else if (maxCacheSize == 0) {
            mce = new MethodCallExpression((Expression)expression, MEMOIZE_AT_LEAST_METHOD_NAME, (Expression)new ArgumentListExpression(new ConstantExpression(protectedCacheSize)));
        } else {
            ArgumentListExpression args = new ArgumentListExpression(new Expression[]{new ConstantExpression(protectedCacheSize), new ConstantExpression(maxCacheSize)});
            mce = new MethodCallExpression((Expression)expression, MEMOIZE_BETWEEN_METHOD_NAME, (Expression)args);
        }
        mce.setImplicitThis(false);
        return mce;
    }

    private static String buildUniqueName(ClassNode owner, String ident, MethodNode methodNode) {
        StringBuilder nameBuilder = new StringBuilder("memoizedMethod" + ident + "$").append(methodNode.getName());
        if (methodNode.getParameters() != null) {
            for (Parameter parameter : methodNode.getParameters()) {
                nameBuilder.append(parameter.getType().getNameWithoutPackage());
            }
        }
        while (owner.getField(nameBuilder.toString()) != null) {
            nameBuilder.insert(0, "_");
        }
        return nameBuilder.toString();
    }
}

