/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.jdbc.IfxStatement;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.JavaToIfxType;
import com.informix.util.IfxErrMsg;
import com.informix.util.dateUtil;
import com.informix.util.memoryUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class IfxVarChar
extends IfxObject {
    private static final int h = 255;
    private String i;

    IfxVarChar() throws SQLException {
        this.setIfxType(13);
    }

    IfxVarChar(String string) throws SQLException {
        block3: {
            block2: {
                this.setIfxType(13);
                this.i = string;
                if (this.i != null) break block2;
                this.nullify();
                if (IfxStatement.t == 0) break block3;
            }
            this.unnullify();
        }
    }

    public byte[] toIfx() throws SQLException {
        try {
            String string = this.conn.getdbEncoding();
            return JavaToIfxType.JavaToIfxChar(this.i, string);
        }
        catch (IOException iOException) {
            throw IfxErrMsg.getSQLException(-79783, this.conn);
        }
    }

    public byte[] toIfxTuple() throws SQLException {
        try {
            block6: {
                byte[] byArray;
                block8: {
                    block7: {
                        if (!this.isNull()) break block6;
                        if (!((IfxSqliConnect)this.conn).r()) break block7;
                        byArray = new byte[2];
                        if (IfxStatement.t == 0) break block8;
                    }
                    byArray = new byte[this.encodedLength + 1];
                }
                memoryUtil.byfill(byArray, (byte)0);
                byArray[0] = 1;
                return byArray;
            }
            String string = this.conn.getdbEncoding();
            byte[] byArray = JavaToIfxType.JavaToIfxVarChar(this.i, string, this.encodedLength);
            if (((IfxSqliConnect)this.conn).r()) {
                int n = 1 + (0xFF & byArray[0]);
                byte[] byArray2 = new byte[n];
                System.arraycopy(byArray, 0, byArray2, 0, n);
                return byArray2;
            }
            return byArray;
        }
        catch (IOException iOException) {
            throw IfxErrMsg.getSQLException(-79783, this.conn);
        }
    }

    public void fromIfx(byte[] byArray) throws SQLException {
        this.fromIfx(byArray, 0, byArray.length);
    }

    public void fromIfx(byte[] byArray, int n, int n2) throws SQLException {
        try {
            block8: {
                int n3;
                block7: {
                    n3 = byArray[n] & 0xFF;
                    if (n3 == 1 && byArray[n + 1] == 0) {
                        this.i = null;
                        this.nullify();
                        return;
                    }
                    if (n3 != 0) break block7;
                    this.i = new String("");
                    if (IfxStatement.t == 0) break block8;
                }
                String string = this.conn.getdbEncoding();
                if (n2 > 0) {
                    n3 = Math.min(n3, n2);
                }
                this.i = IfxToJavaType.IfxToJavaChar(byArray, n + 1, n3, string);
            }
            this.unnullify();
        }
        catch (IOException iOException) {
            throw IfxErrMsg.getSQLException(-79783, this.conn);
        }
    }

    public Object toObject() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.i;
    }

    public String toString() {
        if (this.isNull()) {
            return null;
        }
        return this.i;
    }

    public void fromString(String string) throws SQLException {
        this.fromString(string, true);
    }

    public void fromString(String string, boolean bl) throws SQLException {
        block3: {
            block5: {
                String string2;
                block4: {
                    int n;
                    block2: {
                        n = IfxStatement.t;
                        if (string != null) break block2;
                        this.nullify();
                        if (n == 0) break block3;
                    }
                    this.clearWarning();
                    string2 = null;
                    string2 = bl ? string.trim() : string;
                    if (string2.length() <= 255) break block4;
                    this.i = string2.substring(0, 255);
                    if (n == 0) break block5;
                }
                this.i = string2;
            }
            this.unnullify();
        }
    }

    public byte toByte() throws SQLException {
        byte by;
        if (this.isNull()) {
            return 0;
        }
        try {
            by = Byte.parseByte(this.i);
        }
        catch (Exception exception) {
            throw new SQLException(IfxErrMsg.getMessage(-79716, this.conn) + exception.toString(), IfxErrMsg.getSQLSTATE(-79716), -79716);
        }
        return by;
    }

    public void fromByte(Byte by) throws SQLException {
        block3: {
            block2: {
                if (by != null) break block2;
                this.nullify();
                if (IfxStatement.t == 0) break block3;
            }
            this.fromByte((byte)by);
        }
    }

    public void fromByte(byte by) throws SQLException {
        this.i = String.valueOf(by);
        this.unnullify();
    }

    public boolean toBoolean() throws SQLException {
        if (this.isNull()) {
            return false;
        }
        return this.i.equalsIgnoreCase("1") || this.i.equalsIgnoreCase("true") || this.i.equalsIgnoreCase("t");
    }

    public void fromBoolean(Boolean bl) throws SQLException {
        block3: {
            block2: {
                if (bl != null) break block2;
                this.nullify();
                if (IfxStatement.t == 0) break block3;
            }
            this.fromBoolean((boolean)bl);
        }
    }

    public void fromBoolean(boolean bl) throws SQLException {
        block3: {
            block2: {
                if (!bl) break block2;
                this.i = "true";
                if (IfxStatement.t == 0) break block3;
            }
            this.i = "false";
        }
        this.unnullify();
    }

    public int toInt() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        try {
            Integer n = new Integer(this.i);
            return n;
        }
        catch (Exception exception) {
            throw new SQLException(IfxErrMsg.getMessage(-79716, this.conn) + exception.toString(), IfxErrMsg.getSQLSTATE(-79716), -79716);
        }
    }

    public void fromInt(Integer n) throws SQLException {
        block3: {
            block2: {
                if (n != null) break block2;
                this.nullify();
                if (IfxStatement.t == 0) break block3;
            }
            this.fromInt((int)n);
        }
    }

    public void fromInt(int n) throws SQLException {
        this.i = Integer.toString(n);
        this.unnullify();
    }

    public void fromDecimal(BigDecimal bigDecimal) throws SQLException {
        block3: {
            block2: {
                if (bigDecimal != null) break block2;
                this.nullify();
                if (IfxStatement.t == 0) break block3;
            }
            this.i = bigDecimal.toString();
            this.unnullify();
        }
    }

    public short toShort() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        try {
            Short s = new Short(this.i);
            return s;
        }
        catch (Exception exception) {
            throw new SQLException(IfxErrMsg.getMessage(-79716) + exception.toString(), IfxErrMsg.getSQLSTATE(-79716), -79716);
        }
    }

    public void fromShort(Short s) throws SQLException {
        block3: {
            block2: {
                if (s != null) break block2;
                this.nullify();
                if (IfxStatement.t == 0) break block3;
            }
            this.fromShort((short)s);
        }
    }

    public void fromShort(short s) throws SQLException {
        this.i = String.valueOf(s);
        this.unnullify();
    }

    public long toLong() throws SQLException {
        if (this.isNull()) {
            return 0L;
        }
        try {
            return Long.parseLong(this.i);
        }
        catch (Exception exception) {
            throw new SQLException(IfxErrMsg.getMessage(-79716, this.conn) + exception.toString(), IfxErrMsg.getSQLSTATE(-79716), -79716);
        }
    }

    public void fromLong(Long l) throws SQLException {
        block3: {
            block2: {
                if (l != null) break block2;
                this.nullify();
                if (IfxStatement.t == 0) break block3;
            }
            this.fromLong((long)l);
        }
    }

    public void fromLong(long l) throws SQLException {
        this.i = String.valueOf(l);
        this.unnullify();
    }

    public float toFloat() throws SQLException {
        if (this.isNull()) {
            return 0.0f;
        }
        Float f2 = Float.valueOf(this.i);
        return f2.floatValue();
    }

    public void fromFloat(Float f2) throws SQLException {
        block3: {
            block2: {
                if (f2 != null) break block2;
                this.nullify();
                if (IfxStatement.t == 0) break block3;
            }
            this.fromFloat(f2.floatValue());
        }
    }

    public void fromFloat(float f2) throws SQLException {
        this.i = String.valueOf(f2);
        this.unnullify();
    }

    public Date toDate() throws SQLException {
        Date date = null;
        if (this.isNull()) {
            return null;
        }
        try {
            date = dateUtil.convertDateObj(this.i, this.conn);
        }
        catch (Exception exception) {
            throw new SQLException(IfxErrMsg.getMessage(-79716, this.conn) + exception.toString(), IfxErrMsg.getSQLSTATE(-79716), -79716);
        }
        return date;
    }

    public void fromDate(Date date) throws SQLException {
        block3: {
            block2: {
                if (date != null) break block2;
                this.nullify();
                if (IfxStatement.t == 0) break block3;
            }
            this.i = dateUtil.convertDateStr(date, this.conn);
            this.unnullify();
        }
    }

    public Time toTime() throws SQLException {
        Time time;
        long l = 0L;
        if (this.isNull()) {
            return null;
        }
        try {
            boolean bl = true;
            Object object = dateUtil.convertDateTimeObj(this.i, this.conn, bl);
            l = ((java.util.Date)object).getTime();
            time = new Time(l);
        }
        catch (Exception exception) {
            throw new SQLException(IfxErrMsg.getMessage(-79716, this.conn) + exception.toString(), IfxErrMsg.getSQLSTATE(-79716), -79716);
        }
        return time;
    }

    public void fromTime(Time time) throws SQLException {
        block3: {
            block2: {
                if (time != null) break block2;
                this.nullify();
                if (IfxStatement.t == 0) break block3;
            }
            long l = time.getTime();
            this.i = dateUtil.convertDateTimeStr(time, this.conn, l);
            this.unnullify();
        }
    }

    public Timestamp toTimestamp() throws SQLException {
        Timestamp timestamp;
        if (this.isNull()) {
            return null;
        }
        try {
            boolean bl = false;
            timestamp = (Timestamp)dateUtil.convertDateTimeObj(this.i, this.conn, bl);
        }
        catch (Exception exception) {
            throw new SQLException(IfxErrMsg.getMessage(-79716, this.conn) + exception.toString(), IfxErrMsg.getSQLSTATE(-79716), -79716);
        }
        return timestamp;
    }

    public void fromTimestamp(Timestamp timestamp) throws SQLException {
        block3: {
            block2: {
                if (timestamp != null) break block2;
                this.nullify();
                if (IfxStatement.t == 0) break block3;
            }
            long l = timestamp.getTime();
            this.i = dateUtil.convertDateTimeStr(timestamp, this.conn, l);
            this.unnullify();
        }
    }

    public double toDouble() throws SQLException {
        if (this.isNull()) {
            return 0.0;
        }
        Double d2 = Double.valueOf(this.i);
        return d2;
    }

    public void fromDouble(Double d2) throws SQLException {
        block3: {
            block2: {
                if (d2 != null) break block2;
                this.nullify();
                if (IfxStatement.t == 0) break block3;
            }
            this.fromDouble((double)d2);
        }
    }

    public void fromDouble(double d2) throws SQLException {
        this.i = String.valueOf(d2);
        this.unnullify();
    }

    public BigDecimal toDecimal() throws SQLException {
        BigDecimal bigDecimal;
        if (this.isNull()) {
            return null;
        }
        try {
            bigDecimal = new BigDecimal(this.i);
        }
        catch (NumberFormatException numberFormatException) {
            throw IfxErrMsg.getSQLException(-79716, numberFormatException.toString(), this.conn);
        }
        return bigDecimal;
    }

    public void fromBigDecimal(BigDecimal bigDecimal) throws SQLException {
        block3: {
            block2: {
                if (bigDecimal != null) break block2;
                this.nullify();
                if (IfxStatement.t == 0) break block3;
            }
            this.i = bigDecimal.toString();
            this.unnullify();
        }
    }

    public boolean equals(Object object) {
        if (this.isNull() || object == null || !(object instanceof IfxVarChar)) {
            return false;
        }
        IfxVarChar ifxVarChar = (IfxVarChar)object;
        if (ifxVarChar.isNull()) {
            return false;
        }
        return this.i.equals(ifxVarChar.i);
    }

    public InputStream toAsciiStream() throws SQLException {
        byte[] byArray;
        block5: {
            if (this.isNull()) {
                return null;
            }
            try {
                String string = this.conn.getdbEncoding();
                if (string != null) {
                    byArray = this.i.getBytes(string);
                    if (IfxStatement.t == 0) break block5;
                }
                byArray = this.i.getBytes();
            }
            catch (IOException iOException) {
                throw IfxErrMsg.getSQLException(-79783, this.conn);
            }
        }
        return new ByteArrayInputStream(byArray);
    }

    public void fromAsciiStream(InputStream inputStream, int n) throws SQLException {
        block5: {
            block7: {
                int n2;
                block6: {
                    n2 = IfxStatement.t;
                    this.a(3, "IfxVarChar: fromAsciiStream()");
                    if (inputStream == null) break block5;
                    this.a(3, "IfxVarChar: fromAsciiStream(): length = " + n);
                    if (n != 0) break block6;
                    this.i = "";
                    if (n2 == 0) break block7;
                }
                byte[] byArray = new byte[n];
                int n3 = 0;
                try {
                    block2: while (true) {
                        int n4 = inputStream.read(byArray, n3, n);
                        this.a(3, "IfxVarChar: fromAsciiStream(): readLen=" + n4);
                        this.a(3, "IfxVarChar: fromAsciiStream(): length = " + (n -= n4));
                        this.a(3, "IfxVarChar: fromAsciiStream(): offset =" + (n3 += n4));
                        do {
                            if (n > 0) continue block2;
                        } while (n2 != 0);
                        break;
                    }
                }
                catch (Exception exception) {
                    throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
                }
                this.i = new String(byArray);
                this.a(3, "IfxVarChar: value = " + this.i);
            }
            this.unnullify();
        }
    }

    public void fromInputStream(InputStream inputStream, int n) throws SQLException {
        this.fromAsciiStream(inputStream, n);
    }

    public InputStream toInputStream() throws SQLException {
        return this.toAsciiStream();
    }

    public void fromCharacterStream(Reader reader, int n) throws SQLException {
        block5: {
            block7: {
                int n2;
                block6: {
                    n2 = IfxStatement.t;
                    this.a(3, "IfxVarChar: fromCharacterStream()");
                    if (reader == null) break block5;
                    this.a(3, "IfxVarChar: fromCharacterStream():length =" + n);
                    if (n != 0) break block6;
                    this.i = "";
                    if (n2 == 0) break block7;
                }
                char[] cArray = new char[n];
                int n3 = 0;
                BufferedReader bufferedReader = new BufferedReader(reader);
                try {
                    block2: while (true) {
                        int n4 = reader.read(cArray, n3, n);
                        this.a(3, "IfxVarChar: fromcharacterStream():readLen=" + n4);
                        this.a(3, "IfxVarChar: fromCharacterStream():length=" + (n -= n4));
                        this.a(3, "IfxVarChar: fromCharacterStream():offset=" + (n3 += n4));
                        do {
                            if (n > 0) continue block2;
                        } while (n2 != 0);
                        break;
                    }
                }
                catch (Exception exception) {
                    throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
                }
                this.i = new String(cArray);
                this.a(3, "IfxVarChar: value = " + this.i);
            }
            this.unnullify();
        }
    }

    public Reader toCharacterStream() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        this.a(99, "IfxVarChar: toCharacterStream()");
        this.a(3, "IfxVarChar: toCharacterStream(): value = " + this.i);
        return new StringReader(this.i);
    }
}

