/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.dvs.rsi.de.model.internal;

import com.ibm.rules.dvs.rsi.de.ObjectModelHelper;
import com.ibm.rules.dvs.rsi.de.model.internal.CommonBusinessObjectModelServices;
import com.ibm.rules.engine.lang.semantics.SemObjectModel;
import com.ibm.rules.engine.lang.semantics.SemType;
import com.ibm.rules.engine.runtime.dataie.BusinessDataIEService;
import com.ibm.rules.engine.runtime.dataie.ImportContext;
import com.ibm.rules.engine.runtime.dataie.model.BeanNode;
import com.ibm.rules.engine.runtime.dataie.model.BuiltinNode;
import com.ibm.rules.engine.runtime.dataie.model.CollectionNode;
import com.ibm.rules.engine.runtime.dataie.model.EnumValueNode;
import com.ibm.rules.engine.runtime.dataie.model.MapNode;
import com.ibm.rules.engine.runtime.dataie.model.Node;
import com.ibm.rules.engine.runtime.dataie.model.NodeKind;
import com.ibm.rules.engine.runtime.dataie.model.StringNode;
import com.ibm.rules.res.message.internal.LocalizedMessageHelper;
import ilog.rules.dvs.rsi.IlrBOMTypeDescriptor;
import ilog.rules.dvs.rsi.IlrObjectModelServices;
import ilog.rules.dvs.rsi.exception.IlrBOMTypeNotFoundException;
import ilog.rules.dvs.rsi.exception.IlrObjectFactoryParametersException;
import ilog.rules.dvs.rsi.exception.IlrUnsupportedBOMTypeException;
import ilog.rules.dvs.rsi.internal.IlrCommonMessageHelper;
import ilog.rules.dvs.rsi.internal.IlrDefaultBOMTypeDescriptor;
import ilog.rules.dvs.rsi.ofactory.IlrObjectFactoryParameter;
import ilog.rules.dvs.rsi.ofactory.IlrObjectFactoryParameterValue;
import ilog.rules.dvs.rsi.ofactory.internal.IlrMetaArray;
import ilog.rules.dvs.rsi.ofactory.internal.IlrMetaObject;
import ilog.rules.dvs.rsi.utils.IlrHRSerializationUtils;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class CommonObjectModelServices
extends CommonBusinessObjectModelServices
implements IlrObjectModelServices {
    private static final String META_OBJECT_CLASSNAME = IlrMetaObject.class.getName();
    private static final String META_ARRAY_CLASSNAME = IlrMetaArray.class.getName();
    private static final LocalizedMessageHelper MESSAGE_HELPER = IlrCommonMessageHelper.getLocalizedMessageHelper();
    protected BusinessDataIEService businessDataIEService = null;

    public CommonObjectModelServices(SemObjectModel bom, BusinessDataIEService service) {
        super(bom);
        this.businessDataIEService = service;
    }

    @Override
    public Object createObjectInstance(IlrBOMTypeDescriptor theBOMTypeOfTheObject, Map<String, IlrObjectFactoryParameterValue> theFactoryInputParameters) throws IlrUnsupportedBOMTypeException, IlrObjectFactoryParametersException {
        if (this.isArrayType(theBOMTypeOfTheObject.getFullyQualifiedName())) {
            return this.createArrayObjectInstance(theBOMTypeOfTheObject, theFactoryInputParameters);
        }
        CommonBusinessObjectModelServices.FactorySignature.SignatureType signatureType = this.internalGetObjectFactorySignature(theBOMTypeOfTheObject).getType();
        if (CommonBusinessObjectModelServices.FactorySignature.SignatureType.BEAN.equals((Object)signatureType)) {
            return this.createObjectInstanceWithBeanFactory(theBOMTypeOfTheObject, theFactoryInputParameters);
        }
        return this.createObjectInstanceWithFormatterFactory(theBOMTypeOfTheObject, theFactoryInputParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> getXOMClassMappingForBOMType(String theBOMTypeFullyQualifiedName) throws ClassNotFoundException, IlrUnsupportedBOMTypeException {
        if (theBOMTypeFullyQualifiedName == null) {
            throw new IllegalArgumentException();
        }
        Node collectionNode = (Node)this.getNewXOMArrayInstanceForBOMType(theBOMTypeFullyQualifiedName, 0);
        Object emptyArray = null;
        BusinessDataIEService businessDataIEService = this.businessDataIEService;
        synchronized (businessDataIEService) {
            emptyArray = this.businessDataIEService.createImportContext().importObject(collectionNode);
        }
        return emptyArray.getClass().getComponentType();
    }

    @Override
    public Object getNewXOMArrayInstanceForBOMType(String theBOMTypeFullyQualifiedName, int theArrayLength) throws ClassNotFoundException, IlrUnsupportedBOMTypeException {
        if (theBOMTypeFullyQualifiedName == null || theArrayLength < 0) {
            throw new IllegalArgumentException();
        }
        SemType type = ObjectModelHelper.getTypeFromModel(this.bom, theBOMTypeFullyQualifiedName);
        if (type == null) {
            throw new IlrBOMTypeNotFoundException(new IlrDefaultBOMTypeDescriptor(theBOMTypeFullyQualifiedName, null));
        }
        CollectionNode collectionNode = CollectionNode.createNodeForArray((String)theBOMTypeFullyQualifiedName, (int)theArrayLength);
        return collectionNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> convertToXOM(Map<String, Object> map, boolean preprocess) throws IlrObjectFactoryParametersException {
        HashMap<String, Object> returnedMap = null;
        if (map != null) {
            returnedMap = new HashMap<String, Object>(map.size());
            BusinessDataIEService businessDataIEService = this.businessDataIEService;
            synchronized (businessDataIEService) {
                ImportContext importContext = this.businessDataIEService.createImportContext();
                for (String key : map.keySet()) {
                    Object currentObject = map.get(key);
                    if (currentObject.getClass().getName().equals(META_OBJECT_CLASSNAME) || currentObject.getClass().getName().equals(META_ARRAY_CLASSNAME)) {
                        currentObject = this.getObject(currentObject);
                    }
                    if (preprocess) {
                        currentObject = this.transformObject(currentObject);
                    }
                    Object xomObject = null;
                    if (currentObject instanceof Node) {
                        try {
                            xomObject = importContext.importObject((Node)currentObject);
                        }
                        catch (Exception e) {
                            throw new IlrObjectFactoryParametersException(MESSAGE_HELPER.getLocalizedMessage(IlrCommonMessageHelper.ERROR_CANNOT_CONVERT_BOM_INSTANCE_TO_XOM, new Object[]{((Node)currentObject).getNodeName()}), e);
                        }
                    } else {
                        xomObject = currentObject;
                    }
                    returnedMap.put(key, xomObject);
                }
            }
        }
        return returnedMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object createObjectInstanceWithBeanFactory(IlrBOMTypeDescriptor theBOMTypeOfTheObject, Map<String, IlrObjectFactoryParameterValue> theFactoryInputParameters) throws IlrUnsupportedBOMTypeException, IlrObjectFactoryParametersException {
        void var3_19;
        IlrObjectFactoryParameterValue parameterValue;
        Object var3_3 = null;
        String fullyQualifiedName = theBOMTypeOfTheObject.getFullyQualifiedName();
        NodeKind nodeKind = null;
        BusinessDataIEService businessDataIEService = this.businessDataIEService;
        synchronized (businessDataIEService) {
            nodeKind = this.businessDataIEService.getNodeKind(fullyQualifiedName);
        }
        if (nodeKind == null) {
            throw new IlrObjectFactoryParametersException(MESSAGE_HELPER.getLocalizedMessage(IlrCommonMessageHelper.ERROR_NODE_KIND_SHOULD_NOT_BE_NULL, new Object[]{IlrHRSerializationUtils.serializeBOMTypeDescriptor(theBOMTypeOfTheObject)}));
        }
        if (nodeKind == NodeKind.BEAN) {
            if (fullyQualifiedName.equals("java.util.GregorianCalendar")) {
                Node node = this.createNodeForGregorianCalendar(theBOMTypeOfTheObject, theFactoryInputParameters);
            } else {
                Map<String, IlrObjectFactoryParameter> factorySignature = this.getBeanFactorySignature(theBOMTypeOfTheObject);
                BeanNode beanNode = new BeanNode(fullyQualifiedName);
                for (IlrObjectFactoryParameter parameter : factorySignature.values()) {
                    void var13_44;
                    String parameterName = parameter.getName();
                    IlrObjectFactoryParameterValue parameterValue2 = theFactoryInputParameters.get(parameterName);
                    if (parameterValue2 == null) {
                        if (parameter.isOptional()) continue;
                        throw new IlrObjectFactoryParametersException(MESSAGE_HELPER.getLocalizedMessage(IlrCommonMessageHelper.ERROR_MANDATORY_PARAMETER_IS_MISSING, new Object[]{parameterName, IlrHRSerializationUtils.serializeBOMTypeDescriptor(theBOMTypeOfTheObject)}));
                    }
                    Object obj = parameterValue2.getValue();
                    Object var13_45 = null;
                    if (obj == null) {
                        BuiltinNode builtinNode = BuiltinNode.NULL;
                    } else if (obj.getClass().getName().equals(META_OBJECT_CLASSNAME) || obj.getClass().getName().equals(META_ARRAY_CLASSNAME)) {
                        Node node = (Node)this.getObject(obj);
                    } else if (obj instanceof Node) {
                        Node node = (Node)obj;
                    } else {
                        Node node = this.createNodeForSimpleType(parameterValue2.getBOMType(), obj);
                    }
                    beanNode.addChild(parameterName, (Node)var13_44);
                }
                BeanNode beanNode2 = beanNode;
            }
        } else if (nodeKind == NodeKind.COLLECTION) {
            parameterValue = theFactoryInputParameters.get("_content");
            if (parameterValue != null) {
                Object obj = parameterValue.getValue();
                CollectionNode arrayNode = obj.getClass().getName().equals(META_ARRAY_CLASSNAME) ? (CollectionNode)this.getObject(obj) : (CollectionNode)obj;
                CollectionNode collectionNode = CollectionNode.createNodeForCollection((String)fullyQualifiedName, (int)arrayNode.size());
                for (Node node : arrayNode.getNodes()) {
                    collectionNode.addNode(node);
                }
                CollectionNode collectionNode2 = collectionNode;
            }
        } else if (nodeKind == NodeKind.BUILTIN) {
            if (fullyQualifiedName.equals("java.lang.Boolean")) {
                parameterValue = theFactoryInputParameters.get("value");
                if (parameterValue.getValue() == null) {
                    BuiltinNode builtinNode = BuiltinNode.NULL;
                } else {
                    if (!(parameterValue.getValue() instanceof String)) throw new IlrObjectFactoryParametersException(MESSAGE_HELPER.getLocalizedMessage(IlrCommonMessageHelper.ERROR_VALUE_OF_MANDATORY_PARAMETER_MUST_BE_STRING, new Object[]{"value", IlrHRSerializationUtils.serializeBOMTypeDescriptor(theBOMTypeOfTheObject)}));
                    String stringValue = (String)parameterValue.getValue();
                    if (!(stringValue = stringValue.toLowerCase()).equals("true") && !stringValue.equals("false")) {
                        throw new IlrObjectFactoryParametersException(MESSAGE_HELPER.getLocalizedMessage(IlrCommonMessageHelper.ERROR_VALUE_NOT_VALID_FOR_CLASS, new Object[]{stringValue, IlrHRSerializationUtils.serializeBOMTypeDescriptor(theBOMTypeOfTheObject)}));
                    }
                    Boolean booleanValue = Boolean.valueOf(stringValue);
                    BuiltinNode builtinNode = booleanValue != false ? BuiltinNode.TRUE : BuiltinNode.FALSE;
                }
            }
        } else if (nodeKind == NodeKind.ENUM) {
            parameterValue = theFactoryInputParameters.get("value");
            if (parameterValue.getValue() == null) {
                BuiltinNode builtinNode = BuiltinNode.NULL;
            } else {
                if (!(parameterValue.getValue() instanceof String)) throw new IlrObjectFactoryParametersException(MESSAGE_HELPER.getLocalizedMessage(IlrCommonMessageHelper.ERROR_VALUE_OF_MANDATORY_PARAMETER_MUST_BE_STRING, new Object[]{"value", IlrHRSerializationUtils.serializeBOMTypeDescriptor(theBOMTypeOfTheObject)}));
                Map<String, IlrObjectFactoryParameter> factorySignature = this.getBeanFactorySignature(theBOMTypeOfTheObject);
                String stringValue = (String)parameterValue.getValue();
                IlrObjectFactoryParameter parameterInFactorySignature = factorySignature.get("value");
                IlrBOMTypeDescriptor bomTypeInFactorySignature = parameterInFactorySignature.getBOMType();
                List<String> domainList = null;
                if (bomTypeInFactorySignature.getDomainValues() != null) {
                    domainList = Arrays.asList(bomTypeInFactorySignature.getDomainValues());
                }
                if (domainList == null || domainList != null && !domainList.contains(stringValue)) {
                    throw new IlrObjectFactoryParametersException(MESSAGE_HELPER.getLocalizedMessage(IlrCommonMessageHelper.ERROR_VALUE_NOT_VALID_FOR_CLASS, new Object[]{stringValue, IlrHRSerializationUtils.serializeBOMTypeDescriptor(theBOMTypeOfTheObject)}));
                }
                EnumValueNode enumValueNode = new EnumValueNode(fullyQualifiedName, stringValue);
            }
        } else if (nodeKind == NodeKind.STRING) {
            if (fullyQualifiedName.equals("javax.xml.datatype.XMLGregorianCalendar")) {
                Node node = this.createNodeForXMLGregorianCalendar(theBOMTypeOfTheObject, theFactoryInputParameters);
            } else {
                if (theFactoryInputParameters.size() != 1) throw new IlrObjectFactoryParametersException(MESSAGE_HELPER.getLocalizedMessage(IlrCommonMessageHelper.ERROR_FACTORY_SIGNATURE_SHOULD_CONTAIN_ONE_PARAMETER, new Object[]{IlrHRSerializationUtils.serializeBOMTypeDescriptor(theBOMTypeOfTheObject)}));
                IlrObjectFactoryParameterValue objectFactoryParameterValue = theFactoryInputParameters.values().iterator().next();
                Object objectValue = objectFactoryParameterValue.getValue();
                if (objectValue == null) {
                    BuiltinNode builtinNode = BuiltinNode.NULL;
                } else {
                    String objectFullyQualifiedName = objectFactoryParameterValue.getBOMType().getFullyQualifiedName();
                    if (objectFullyQualifiedName.equals(Date.class.getName())) {
                        Node node = this.createNodeForDate(theBOMTypeOfTheObject, (Date)objectValue);
                    } else {
                        StringNode stringNode = new StringNode(fullyQualifiedName, String.valueOf(objectValue));
                    }
                }
            }
        } else if (nodeKind == NodeKind.MAP) {
            throw new IlrObjectFactoryParametersException(MESSAGE_HELPER.getLocalizedMessage(IlrCommonMessageHelper.ERROR_MAPS_NOT_SUPPORTED));
        }
        if (var3_19 != null) return var3_19;
        throw new IlrObjectFactoryParametersException(MESSAGE_HELPER.getLocalizedMessage(IlrCommonMessageHelper.ERROR_CREATED_INSTANCE_SHOULD_NOT_BE_NULL, new Object[]{IlrHRSerializationUtils.serializeBOMTypeDescriptor(theBOMTypeOfTheObject)}));
    }

    protected Object createObjectInstanceWithFormatterFactory(IlrBOMTypeDescriptor theBOMTypeOfTheObject, Map<String, IlrObjectFactoryParameterValue> theFactoryInputParameters) throws IlrUnsupportedBOMTypeException, IlrObjectFactoryParametersException {
        BuiltinNode returnedValue = null;
        IlrObjectFactoryParameterValue parameterValue = theFactoryInputParameters.get("value");
        if (parameterValue.getValue() == null) {
            returnedValue = BuiltinNode.NULL;
        } else if (parameterValue.getValue() instanceof String) {
            returnedValue = new StringNode(theBOMTypeOfTheObject.getFullyQualifiedName(), (String)parameterValue.getValue());
        } else {
            throw new IlrObjectFactoryParametersException(MESSAGE_HELPER.getLocalizedMessage(IlrCommonMessageHelper.ERROR_VALUE_OF_MANDATORY_PARAMETER_MUST_BE_STRING, new Object[]{"value", IlrHRSerializationUtils.serializeBOMTypeDescriptor(theBOMTypeOfTheObject)}));
        }
        return returnedValue;
    }

    protected Object createArrayObjectInstance(IlrBOMTypeDescriptor theBOMTypeOfTheObject, Map<String, IlrObjectFactoryParameterValue> theFactoryInputParameters) throws IlrUnsupportedBOMTypeException, IlrObjectFactoryParametersException {
        CollectionNode returnedValue = null;
        String fullyQualifiedName = theBOMTypeOfTheObject.getFullyQualifiedName();
        IlrObjectFactoryParameterValue parameterValue = theFactoryInputParameters.get("_content");
        if (parameterValue != null) {
            Object obj = parameterValue.getValue();
            Object[] values = (Object[])obj;
            IlrBOMTypeDescriptor typeOfArrayElements = this.getTypeOfArrayElements(fullyQualifiedName);
            CollectionNode arrayNode = CollectionNode.createNodeForArray((String)typeOfArrayElements.getFullyQualifiedName(), (int)values.length);
            for (Object value : values) {
                Object childNode = null;
                childNode = value == null ? BuiltinNode.NULL : (value.getClass().getName().equals(META_OBJECT_CLASSNAME) ? (Node)this.getObject(value) : (value instanceof Node ? (Node)value : this.createNodeForSimpleType(typeOfArrayElements, value)));
                arrayNode.addNode((Node)childNode);
            }
            returnedValue = arrayNode;
        }
        return returnedValue;
    }

    protected Object getObject(Object obj) {
        try {
            Method m = obj.getClass().getMethod("getObject", null);
            return m.invoke(obj, (Object[])null);
        }
        catch (Exception e) {
            return obj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Node createNodeForSimpleType(IlrBOMTypeDescriptor bomTypeDescriptor, Object value) throws IlrObjectFactoryParametersException {
        Object returnedValue = null;
        String fullyQualifiedName = bomTypeDescriptor.getFullyQualifiedName();
        NodeKind nodeKind = null;
        BusinessDataIEService businessDataIEService = this.businessDataIEService;
        synchronized (businessDataIEService) {
            nodeKind = this.businessDataIEService.getNodeKind(fullyQualifiedName);
        }
        if (nodeKind == null) {
            throw new IlrObjectFactoryParametersException(MESSAGE_HELPER.getLocalizedMessage(IlrCommonMessageHelper.ERROR_NODE_KIND_SHOULD_NOT_BE_NULL, new Object[]{IlrHRSerializationUtils.serializeBOMTypeDescriptor(bomTypeDescriptor)}));
        }
        if (value == null) {
            returnedValue = BuiltinNode.NULL;
        } else if (nodeKind == NodeKind.STRING) {
            returnedValue = bomTypeDescriptor.getFullyQualifiedName().equals(Date.class.getName()) ? this.createNodeForDate(bomTypeDescriptor, (Date)value) : new StringNode(fullyQualifiedName, String.valueOf(value));
        } else if (nodeKind == NodeKind.BUILTIN && (fullyQualifiedName.equals("boolean") || fullyQualifiedName.equals("java.lang.Boolean"))) {
            Boolean booleanValue = Boolean.valueOf(String.valueOf(value));
            BuiltinNode builtinNode = returnedValue = booleanValue != false ? BuiltinNode.TRUE : BuiltinNode.FALSE;
        }
        if (returnedValue == null) {
            throw new IlrObjectFactoryParametersException(MESSAGE_HELPER.getLocalizedMessage(IlrCommonMessageHelper.ERROR_NOT_A_SIMPLE_TYPE, new Object[]{IlrHRSerializationUtils.serializeBOMTypeDescriptor(bomTypeDescriptor)}));
        }
        return returnedValue;
    }

    protected Node createNodeForDate(IlrBOMTypeDescriptor theBOMTypeOfTheObject, Date date) throws IlrObjectFactoryParametersException {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        DatatypeFactory datatypeFactory = null;
        String stringValue = null;
        try {
            datatypeFactory = DatatypeFactory.newInstance();
            XMLGregorianCalendar xmlGregorianCalendar = datatypeFactory.newXMLGregorianCalendar(gregorianCalendar);
            stringValue = xmlGregorianCalendar.toString();
        }
        catch (DatatypeConfigurationException e) {
            throw new IlrObjectFactoryParametersException(MESSAGE_HELPER.getLocalizedMessage(IlrCommonMessageHelper.ERROR_CANNOT_CONVERT_DATE_TO_STRING_FORMAT, new Object[]{date, IlrHRSerializationUtils.serializeBOMTypeDescriptor(theBOMTypeOfTheObject)}), e);
        }
        return new StringNode(theBOMTypeOfTheObject.getFullyQualifiedName(), stringValue);
    }

    protected Node createNodeForXMLGregorianCalendar(IlrBOMTypeDescriptor bomTypeDescriptor, Map<String, IlrObjectFactoryParameterValue> factoryInputParameters) throws IlrObjectFactoryParametersException {
        DatatypeFactory datatypeFactory = null;
        String stringValue = null;
        try {
            datatypeFactory = DatatypeFactory.newInstance();
            Integer year = Integer.MIN_VALUE;
            IlrObjectFactoryParameterValue yearFactoryParameterValue = factoryInputParameters.get("year");
            if (yearFactoryParameterValue != null && yearFactoryParameterValue.getValue() != null) {
                year = (Integer)yearFactoryParameterValue.getValue();
            }
            Integer month = Integer.MIN_VALUE;
            IlrObjectFactoryParameterValue monthFactoryParameterValue = factoryInputParameters.get("month");
            if (monthFactoryParameterValue != null && monthFactoryParameterValue.getValue() != null) {
                month = (Integer)monthFactoryParameterValue.getValue();
            }
            Integer day = Integer.MIN_VALUE;
            IlrObjectFactoryParameterValue dayFactoryParameterValue = factoryInputParameters.get("day");
            if (dayFactoryParameterValue != null && dayFactoryParameterValue.getValue() != null) {
                day = (Integer)dayFactoryParameterValue.getValue();
            }
            Integer hour = Integer.MIN_VALUE;
            IlrObjectFactoryParameterValue hourFactoryParameterValue = factoryInputParameters.get("hour");
            if (hourFactoryParameterValue != null && hourFactoryParameterValue.getValue() != null) {
                hour = (Integer)hourFactoryParameterValue.getValue();
            }
            Integer minute = Integer.MIN_VALUE;
            IlrObjectFactoryParameterValue minuteFactoryParameterValue = factoryInputParameters.get("minute");
            if (minuteFactoryParameterValue != null && minuteFactoryParameterValue.getValue() != null) {
                minute = (Integer)minuteFactoryParameterValue.getValue();
            }
            Integer second = Integer.MIN_VALUE;
            IlrObjectFactoryParameterValue secondFactoryParameterValue = factoryInputParameters.get("second");
            if (secondFactoryParameterValue != null && secondFactoryParameterValue.getValue() != null) {
                second = (Integer)secondFactoryParameterValue.getValue();
            }
            Integer millisecond = Integer.MIN_VALUE;
            IlrObjectFactoryParameterValue millisecondFactoryParameterValue = factoryInputParameters.get("millisecond");
            if (millisecondFactoryParameterValue != null && millisecondFactoryParameterValue.getValue() != null) {
                millisecond = (Integer)millisecondFactoryParameterValue.getValue();
            }
            Integer timezone = Integer.MIN_VALUE;
            IlrObjectFactoryParameterValue timezoneFactoryParameterValue = factoryInputParameters.get("timezone");
            if (timezoneFactoryParameterValue != null && timezoneFactoryParameterValue.getValue() != null) {
                timezone = (Integer)timezoneFactoryParameterValue.getValue();
            }
            BigDecimal fractionalSecond = null;
            IlrObjectFactoryParameterValue fractionalSecondFactoryParameterValue = factoryInputParameters.get("fractionalSecond");
            if (fractionalSecondFactoryParameterValue != null && fractionalSecondFactoryParameterValue.getValue() != null) {
                fractionalSecond = (BigDecimal)fractionalSecondFactoryParameterValue.getValue();
            }
            XMLGregorianCalendar xmlGregorianCalendar = datatypeFactory.newXMLGregorianCalendar(year, (int)month, (int)day, (int)hour, (int)minute, (int)second, millisecond, (int)timezone);
            xmlGregorianCalendar.setFractionalSecond(fractionalSecond);
            stringValue = xmlGregorianCalendar.toString();
        }
        catch (DatatypeConfigurationException e) {
            throw new IlrObjectFactoryParametersException(MESSAGE_HELPER.getLocalizedMessage(IlrCommonMessageHelper.ERROR_CANNOT_CREATE_NODE_FOR_XMLGREGORIANCALENDAR), e);
        }
        return new StringNode(bomTypeDescriptor.getFullyQualifiedName(), stringValue);
    }

    protected Node createNodeForGregorianCalendar(IlrBOMTypeDescriptor bomTypeDescriptor, Map<String, IlrObjectFactoryParameterValue> factoryInputParameters) throws IlrObjectFactoryParametersException {
        BeanNode returnedValue = new BeanNode(bomTypeDescriptor.getFullyQualifiedName());
        IlrObjectFactoryParameterValue timeFactoryParameterValue = factoryInputParameters.get("time");
        if (timeFactoryParameterValue != null && timeFactoryParameterValue.getValue() != null) {
            Date date = (Date)timeFactoryParameterValue.getValue();
            returnedValue.addChild("time", date.getTime());
        }
        return returnedValue;
    }

    protected Object transformObject(Object object) throws IlrObjectFactoryParametersException {
        Object returnedObject = null;
        if (object != null) {
            if (object instanceof Node) {
                Node node = (Node)object;
                NodeKind nodeKind = node.getNodeKind();
                if (nodeKind == null) {
                    throw new IlrObjectFactoryParametersException(MESSAGE_HELPER.getLocalizedMessage(IlrCommonMessageHelper.ERROR_NODE_KIND_SHOULD_NOT_BE_NULL, new Object[]{node.getNodeName()}));
                }
                if (nodeKind == NodeKind.BEAN) {
                    MapNode mapNode = new MapNode("java.util.HashMap");
                    BeanNode beanNode = (BeanNode)node;
                    Iterator iterator = beanNode.getAttributeNames();
                    while (iterator.hasNext()) {
                        String attributeName = (String)iterator.next();
                        StringNode keyNode = new StringNode("java.lang.String", attributeName);
                        Node valueNode = beanNode.getNode(attributeName);
                        mapNode.put((Node)keyNode, (Node)this.transformObject(valueNode));
                    }
                    returnedObject = mapNode;
                } else if (nodeKind == NodeKind.COLLECTION) {
                    CollectionNode collectionNode = (CollectionNode)node;
                    CollectionNode newCollectionNode = null;
                    newCollectionNode = collectionNode.getComponentType() != null ? CollectionNode.createNodeForCollection((String)"java.util.ArrayList", (int)collectionNode.size()) : CollectionNode.createNodeForCollection((String)collectionNode.getNodeName(), (int)collectionNode.size());
                    for (Node itemNode : collectionNode.getChildren()) {
                        newCollectionNode.addNode((Node)this.transformObject(itemNode));
                    }
                    returnedObject = newCollectionNode;
                } else if (nodeKind == NodeKind.ENUM) {
                    EnumValueNode enumValueNode = (EnumValueNode)node;
                    String value = enumValueNode.getNodeName() + "." + enumValueNode.getReference();
                    returnedObject = new StringNode("java.lang.String", value);
                } else if (nodeKind == NodeKind.STRING || nodeKind == NodeKind.BUILTIN) {
                    returnedObject = object;
                } else if (nodeKind == NodeKind.MAP) {
                    throw new IlrObjectFactoryParametersException(MESSAGE_HELPER.getLocalizedMessage(IlrCommonMessageHelper.ERROR_MAPS_NOT_SUPPORTED));
                }
            } else {
                returnedObject = object;
            }
        }
        return returnedObject;
    }
}

