/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.htds.plugin.cci.internal;

import com.ibm.rules.engine.migration.classdriver.runtime.XSDComponent;
import com.ibm.rules.engine.migration.classdriver.runtime.XmlBindingService;
import com.ibm.rules.res.xu.client.internal.XURulesetParameter;
import ilog.rules.factory.IlrReflect;
import ilog.rules.res.model.IlrCRERulesetArchive;
import ilog.rules.res.model.IlrDERulesetArchive;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RulesetMetaData {
    private final String name;
    private final IlrCRERulesetArchive cre;
    private final XURulesetParameter[] parameters;
    private final IlrReflect xomReflect;
    private XmlBindingService xmlService;
    private Map<String, Map<String, InputStream>> loadedXmlService;
    private Map<String, List<String>> loadedXmlSchemaNames;

    public RulesetMetaData(String name, IlrCRERulesetArchive archive, XURulesetParameter[] parameters, IlrReflect xomReflect) {
        this.name = name;
        this.parameters = parameters;
        this.cre = archive;
        this.xmlService = null;
        this.xomReflect = xomReflect;
    }

    public RulesetMetaData(String name, IlrDERulesetArchive archive, XURulesetParameter[] parameters, XmlBindingService xmlService) {
        this.name = name;
        this.parameters = parameters;
        this.cre = null;
        this.xmlService = xmlService;
        this.xomReflect = xmlService != null ? xmlService.getXOM() : null;
    }

    public Map<String, List<String>> getSchemaNames() {
        if (this.cre != null) {
            return this.cre.getRulesetArchive().getSchemaNames(true);
        }
        if (this.xmlService != null) {
            this.loadXmlService();
        }
        if (this.loadedXmlSchemaNames != null) {
            return this.loadedXmlSchemaNames;
        }
        return null;
    }

    public Object getSchema(String namespace, String fileName) {
        if (this.cre != null) {
            return this.cre.getRulesetArchive().getSchema(namespace, fileName);
        }
        if (this.xmlService != null) {
            this.loadXmlService();
        }
        if (this.loadedXmlService != null) {
            return this.loadedXmlService.get(namespace).get(fileName);
        }
        return null;
    }

    private void loadXmlService() {
        List xsdComponents = null;
        try {
            xsdComponents = this.xmlService.getXSDComponents();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (xsdComponents != null) {
            this.loadedXmlService = new HashMap<String, Map<String, InputStream>>();
            this.loadedXmlSchemaNames = new HashMap<String, List<String>>();
            for (XSDComponent xsdComponent : xsdComponents) {
                String namespace = xsdComponent.getNamespace();
                Map<String, InputStream> fileName2Data = this.loadedXmlService.get(namespace);
                if (fileName2Data == null) {
                    fileName2Data = new HashMap<String, InputStream>();
                    this.loadedXmlService.put(namespace, fileName2Data);
                    this.loadedXmlSchemaNames.put(namespace, new ArrayList());
                }
                List<String> fileNames = this.loadedXmlSchemaNames.get(namespace);
                fileName2Data.put(xsdComponent.getFileName(), xsdComponent.getXsdContent());
                fileNames.add(xsdComponent.getFileName());
            }
            this.xmlService = null;
        }
    }

    public final String getName() {
        return this.name;
    }

    public final IlrReflect getXMLReflect() {
        return this.xomReflect;
    }

    public XURulesetParameter[] getRulesetParameters() {
        return this.parameters;
    }
}

