/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.htds.plugin.cci.internal;

import com.ibm.rules.htds.plugin.cci.internal.DLCommonXMLUtil;
import com.ibm.rules.htds.plugin.cci.internal.HTDSUtil;
import com.ibm.rules.htds.plugin.cci.internal.RulesetParameterWrapperImpl;
import com.ibm.rules.htds.plugin.cci.internal.RulesetWrapperImpl;
import com.ibm.rules.res.message.internal.LocalizedMessageHelper;
import com.ibm.rules.res.util.internal.RESTUtil;
import com.ibm.rules.res.xml.internal.JAXBClassDesciption;
import com.ibm.rules.res.xml.internal.XSD;
import com.ibm.rules.res.xml.internal.XSDUtil;
import com.ibm.rules.res.xml.internal.XSDWrapper;
import com.ibm.rules.res.xu.client.internal.XURulesetParameter;
import com.ibm.wsdl.extensions.schema.SchemaConstants;
import ilog.rules.res.util.io.IlrFileUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.resource.ResourceException;
import javax.wsdl.WSDLException;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WADLGenerator {
    public static final String WADL_DEFAULT_NS_NAME = "rest";
    public static final String WADL_DEFAULT_NS_URI = "http://www.ibm.com/rules/rest";
    public static final boolean JSON = false;
    protected DocumentBuilder builder;
    private transient DocumentBuilderFactory xmlfactory;
    private transient TransformerFactory transformerFactory = TransformerFactory.newInstance();

    protected DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        if (this.builder == null) {
            this.builder = this.getDocumentBuilderFactory().newDocumentBuilder();
        }
        return this.builder;
    }

    protected DocumentBuilderFactory getDocumentBuilderFactory() {
        if (this.xmlfactory == null) {
            this.xmlfactory = DocumentBuilderFactory.newInstance();
            this.xmlfactory.setNamespaceAware(true);
            this.xmlfactory.setValidating(true);
        }
        return this.xmlfactory;
    }

    public void generateWADL(RulesetWrapperImpl ruleset, ByteArrayOutputStream outstream) throws ParserConfigurationException, IOException, TransformerException, DOMException, WSDLException, ResourceException, ClassNotFoundException, JAXBException {
        HashMap<String, XSD> additionalXSDs = new HashMap<String, XSD>();
        RulesetWrapperImpl rulesetWrapper = new RulesetWrapperImpl(ruleset);
        ZipOutputStream zos = new ZipOutputStream(outstream);
        if (!ruleset.inlineWSDL()) {
            zos.putNextEntry(new ZipEntry(rulesetWrapper.DecisionServiceWADLName()));
            Element definition = this.populateDefaultDefinition(rulesetWrapper, additionalXSDs);
            zos.write(this.toByteArray(definition));
            for (Map.Entry entry : additionalXSDs.entrySet()) {
                String filename = (String)entry.getKey();
                ZipEntry zentry = new ZipEntry(filename);
                zos.putNextEntry(zentry);
                XSD currXSD = (XSD)entry.getValue();
                if (currXSD.getDefaultNamespace() != null && !currXSD.isFlattenedInclusion() && currXSD.getOriginalXSD() != null) {
                    zos.write(currXSD.getOriginalXSD());
                } else {
                    Element root = currXSD.getElement();
                    try {
                        zos.write(this.toByteArray(root));
                    }
                    catch (TransformerException e) {
                        e.printStackTrace();
                    }
                }
                zos.closeEntry();
            }
            zos.close();
        } else {
            Element definition = this.populateDefaultDefinition(rulesetWrapper, additionalXSDs);
            outstream.write(this.toByteArray(definition));
        }
    }

    private byte[] toByteArray(Element root) throws TransformerException, IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        DOMSource source = new DOMSource(root);
        Transformer transformer = this.transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        StreamResult res = new StreamResult(result);
        transformer.transform(source, res);
        result.flush();
        result.close();
        return result.toByteArray();
    }

    private Element populateDefaultDefinition(RulesetWrapperImpl ruleset, Map<String, XSD> additionalXSDs) throws ParserConfigurationException, DOMException, WSDLException, ResourceException, ClassNotFoundException, IOException, JAXBException {
        this.extractXSDs(ruleset, additionalXSDs);
        Document doc = this.getDocumentBuilder().newDocument();
        Element root = doc.createElement("application");
        root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
        root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://wadl.dev.java.net/2009/02");
        root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + ruleset.ParameterNamespaceQName().getLocalPart(), ruleset.ParameterNamespaceQName().getNamespaceURI());
        root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://wadl.dev.java.net/2009/02 wadl.xsd");
        Element rootDoc = doc.createElement("doc");
        rootDoc.setAttribute("title", ruleset.getRulesetMetaData().getName());
        root.appendChild(rootDoc);
        Element grammars = doc.createElement("grammars");
        if (ruleset.inlineWSDL()) {
            if (additionalXSDs.size() != 0) {
                for (Map.Entry<String, XSD> entry : additionalXSDs.entrySet()) {
                    grammars.appendChild(grammars.getOwnerDocument().importNode(entry.getValue().getElement(), true));
                }
            }
        } else {
            Element includeGrammar = doc.createElement("include");
            includeGrammar.setAttribute("href", ruleset.ParametersSchemaName());
            grammars.appendChild(includeGrammar);
        }
        root.appendChild(grammars);
        Map<String, URL> endpoints = ruleset.getEndPoints();
        if (endpoints == null || endpoints.size() == 0) {
            return root;
        }
        if (endpoints.size() > 1) {
            throw new IllegalArgumentException();
        }
        Element resources = doc.createElement("resources");
        String urlForPost = endpoints.values().iterator().next().toString();
        if (urlForPost.toLowerCase().endsWith("/wadl")) {
            urlForPost = urlForPost.substring(0, urlForPost.length() - 5);
        }
        resources.setAttribute("base", urlForPost);
        root.appendChild(resources);
        Element resource = doc.createElement("resource");
        resource.setAttribute("path", "");
        resources.appendChild(resource);
        Element method = doc.createElement("method");
        method.setAttribute("name", "POST");
        resource.appendChild(method);
        Element requestDoc = doc.createElement("doc");
        requestDoc.setAttribute("title", "execute");
        method.appendChild(requestDoc);
        Element request = doc.createElement("request");
        method.appendChild(request);
        this.appendClassicalParamDoc(request);
        Element requestRespresentation = doc.createElement("representation");
        requestRespresentation.setAttribute("element", ruleset.ParameterNamespaceQName().getLocalPart() + ":" + ruleset.getDecisionServiceRESTRequestQName());
        requestRespresentation.setAttribute("mediaType", "application/xml");
        request.appendChild(requestRespresentation);
        Element response = doc.createElement("response");
        method.appendChild(response);
        Element responseRespresentation = doc.createElement("representation");
        responseRespresentation.setAttribute("element", ruleset.ParameterNamespaceQName().getLocalPart() + ":" + ruleset.getDecisionServiceRESTResponseQName());
        responseRespresentation.setAttribute("mediaType", "application/xml");
        response.appendChild(responseRespresentation);
        resource = doc.createElement("resource");
        resource.setAttribute("path", "/xml");
        resources.appendChild(resource);
        method = doc.createElement("method");
        method.setAttribute("name", "GET");
        resource.appendChild(method);
        requestDoc = doc.createElement("doc");
        requestDoc.setAttribute("title", "XML generation");
        method.appendChild(requestDoc);
        response = doc.createElement("response");
        method.appendChild(response);
        responseRespresentation = doc.createElement("representation");
        responseRespresentation.setAttribute("element", ruleset.ParameterNamespaceQName().getLocalPart() + ":" + ruleset.getDecisionServiceRESTRequestQName());
        responseRespresentation.setAttribute("mediaType", "application/xml");
        response.appendChild(responseRespresentation);
        resource = doc.createElement("resource");
        resource.setAttribute("path", "/validate");
        resources.appendChild(resource);
        method = doc.createElement("method");
        method.setAttribute("name", "POST");
        resource.appendChild(method);
        requestDoc = doc.createElement("doc");
        requestDoc.setAttribute("title", "Payload preemptive validation");
        method.appendChild(requestDoc);
        request = doc.createElement("request");
        method.appendChild(request);
        this.appendClassicalParamDoc(request);
        requestRespresentation = doc.createElement("representation");
        requestRespresentation.setAttribute("element", ruleset.ParameterNamespaceQName().getLocalPart() + ":" + ruleset.getDecisionServiceRESTRequestQName());
        requestRespresentation.setAttribute("mediaType", "application/xml");
        request.appendChild(requestRespresentation);
        response = doc.createElement("response");
        method.appendChild(response);
        responseRespresentation = doc.createElement("representation");
        responseRespresentation.setAttribute("mediaType", "application/json");
        response.appendChild(responseRespresentation);
        return root;
    }

    private void appendClassicalParamDoc(Element root) {
        Element paramAccept = root.getOwnerDocument().createElement("param");
        paramAccept.setAttribute("name", "Accept");
        paramAccept.setAttribute("style", "header");
        paramAccept.setAttribute("default", "application/xml");
        paramAccept.setAttribute("required", "false");
        paramAccept.setAttribute("repeating", "false");
        root.appendChild(paramAccept);
        Element optionFormat = root.getOwnerDocument().createElement("option");
        optionFormat.setAttribute("value", "application/xml");
        paramAccept.appendChild(optionFormat);
        paramAccept = root.getOwnerDocument().createElement("param");
        paramAccept.setAttribute("name", "accept");
        paramAccept.setAttribute("style", "query");
        paramAccept.setAttribute("default", "application/xml");
        paramAccept.setAttribute("required", "false");
        paramAccept.setAttribute("repeating", "false");
        root.appendChild(paramAccept);
        optionFormat = root.getOwnerDocument().createElement("option");
        optionFormat.setAttribute("value", "application/xml");
        paramAccept.appendChild(optionFormat);
        Element paramAcceptLanguage = root.getOwnerDocument().createElement("param");
        paramAcceptLanguage.setAttribute("name", "Accept-Language");
        paramAcceptLanguage.setAttribute("style", "header");
        paramAcceptLanguage.setAttribute("default", "en");
        paramAcceptLanguage.setAttribute("required", "false");
        paramAcceptLanguage.setAttribute("repeating", "false");
        root.appendChild(paramAcceptLanguage);
        for (Locale tmpLocale : RESTUtil.availableLocales) {
            optionFormat = root.getOwnerDocument().createElement("option");
            optionFormat.setAttribute("value", tmpLocale.toString());
            paramAcceptLanguage.appendChild(optionFormat);
        }
        paramAcceptLanguage = root.getOwnerDocument().createElement("param");
        paramAcceptLanguage.setAttribute("name", "accept-language");
        paramAcceptLanguage.setAttribute("style", "query");
        paramAcceptLanguage.setAttribute("default", "en");
        paramAcceptLanguage.setAttribute("required", "false");
        paramAcceptLanguage.setAttribute("repeating", "false");
        root.appendChild(paramAcceptLanguage);
        for (Locale tmpLocale : RESTUtil.availableLocales) {
            optionFormat = root.getOwnerDocument().createElement("option");
            optionFormat.setAttribute("value", tmpLocale.toString());
            paramAcceptLanguage.appendChild(optionFormat);
        }
        Element paramContentType = root.getOwnerDocument().createElement("param");
        paramContentType.setAttribute("name", "Content-Type");
        paramContentType.setAttribute("style", "header");
        paramContentType.setAttribute("required", "false");
        paramContentType.setAttribute("repeating", "false");
        root.appendChild(paramContentType);
        optionFormat = root.getOwnerDocument().createElement("option");
        optionFormat.setAttribute("value", "application/xml");
        paramContentType.appendChild(optionFormat);
    }

    private void extractXSDs(RulesetWrapperImpl ruleset, Map<String, XSD> externalSchemas) throws WSDLException, DOMException, ResourceException, ClassNotFoundException, IOException, JAXBException, ParserConfigurationException {
        Map<String, XSD> schemas = this.getSchemas(ruleset);
        if (schemas.size() == 0) {
            return;
        }
        for (Map.Entry<String, XSD> entry : schemas.entrySet()) {
            externalSchemas.put(entry.getKey(), entry.getValue());
        }
    }

    private Map<String, XSD> getSchemas(RulesetWrapperImpl ruleset) throws DOMException, ResourceException, ClassNotFoundException, IOException, JAXBException, ParserConfigurationException {
        boolean zipMergeStrategyForImport = ruleset.zipMergeStrategyForImport();
        Map<String, XSD> result = new LinkedHashMap<String, XSD>();
        DocumentBuilder builder = this.getDocumentBuilder();
        Document doc = builder.newDocument();
        if (ruleset.trace()) {
            InputStream inputStream = this.getClass().getResourceAsStream("decisionTraceFilter.xsd");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IlrFileUtil.copy(inputStream, baos);
            XSD xsd = new XSD(baos.toByteArray());
            xsd.setTargetNamespace("http://www.ibm.com/rules/decisionservice/trace");
            result.put("decisionTraceFilter.xsd", xsd);
            inputStream = this.getClass().getResourceAsStream("decisionTrace.xsd");
            baos = new ByteArrayOutputStream();
            IlrFileUtil.copy(inputStream, baos);
            xsd = new XSD(baos.toByteArray());
            xsd.setTargetNamespace("http://www.ibm.com/rules/decisionservice/tracefilter");
            result.put("decisionTrace.xsd", xsd);
        }
        XSDUtil xsdUtil = new XSDUtil(ruleset.getLogger());
        Map<String, XSD> results = HTDSUtil.createXSDMap(ruleset, ruleset.getLogger());
        result.putAll(results);
        HashMap<QName, Integer> arrayType2depth = new HashMap<QName, Integer>();
        XURulesetParameter[] params = ruleset.getRulesetMetaData().getRulesetParameters();
        TreeSet<XURulesetParameter> treeParameters = new TreeSet<XURulesetParameter>(new Comparator<XURulesetParameter>(){

            @Override
            public int compare(XURulesetParameter o1, XURulesetParameter o2) {
                int nameCompare = o1.getName().compareTo(o2.getName());
                if (nameCompare != 0) {
                    return nameCompare;
                }
                return o1.getKind() - o2.getKind();
            }
        });
        boolean importJaxbArrayNS = false;
        for (XURulesetParameter parameter : params) {
            RulesetParameterWrapperImpl rulesetParameterWrapper;
            treeParameters.add(parameter);
            if (importJaxbArrayNS || (rulesetParameterWrapper = this.getRulesetParameterWrapper(ruleset, parameter)).getDepth() <= 1 || rulesetParameterWrapper.getParameterType() != 2) continue;
            importJaxbArrayNS = true;
        }
        Element schemaParameterElement = doc.createElement(ruleset.XSDQName().getLocalPart() + ':' + SchemaConstants.Q_ELEM_XSD_2001.getLocalPart());
        schemaParameterElement.setAttribute("elementFormDefault", "qualified");
        schemaParameterElement.setAttribute("targetNamespace", ruleset.ParameterNamespaceQName().getNamespaceURI());
        schemaParameterElement.setAttribute("xmlns:" + ruleset.ParameterNamespaceQName().getLocalPart(), ruleset.ParameterNamespaceQName().getNamespaceURI());
        this.declareParametersNamespaceAttributes(ruleset, schemaParameterElement);
        schemaParameterElement.setAttribute("xmlns:" + ruleset.XSDQName().getLocalPart(), ruleset.XSDQName().getNamespaceURI());
        if (ruleset.trace()) {
            schemaParameterElement.setAttribute("xmlns:trace", "http://www.ibm.com/rules/decisionservice/trace");
            schemaParameterElement.setAttribute("xmlns:filter", "http://www.ibm.com/rules/decisionservice/tracefilter");
        }
        Map<String, XSDWrapper> ns2wrapper = this.declareParametersImports(ruleset, schemaParameterElement, zipMergeStrategyForImport);
        if (ruleset.trace()) {
            Element importTraceFilterElement = DLCommonXMLUtil.createXSDElement(doc, ruleset.XSDQName(), "import", false);
            importTraceFilterElement.setAttribute("namespace", "http://www.ibm.com/rules/decisionservice/tracefilter");
            Element importTraceElement = DLCommonXMLUtil.createXSDElement(doc, ruleset.XSDQName(), "import", false);
            importTraceElement.setAttribute("namespace", "http://www.ibm.com/rules/decisionservice/trace");
            if (ruleset.zipFile) {
                importTraceFilterElement.setAttribute("schemaLocation", "decisionTraceFilter.xsd");
                importTraceElement.setAttribute("schemaLocation", "decisionTrace.xsd");
            }
            schemaParameterElement.appendChild(importTraceFilterElement);
            schemaParameterElement.appendChild(importTraceElement);
        }
        Element requestElement = DLCommonXMLUtil.createXSDElement(doc, ruleset.XSDQName(), "element", false);
        requestElement.setAttribute("name", ruleset.getDecisionServiceRESTRequestQName());
        schemaParameterElement.appendChild(requestElement);
        Element requestElementComplexType = DLCommonXMLUtil.createXSDElement(doc, ruleset.XSDQName(), "complexType", false);
        requestElement.appendChild(requestElementComplexType);
        Element requestElementComplexTypeSeq = DLCommonXMLUtil.createXSDElement(doc, ruleset.XSDQName(), "sequence", false);
        requestElementComplexType.appendChild(requestElementComplexTypeSeq);
        if (ruleset.decisionId()) {
            requestElementComplexTypeSeq.appendChild(DLCommonXMLUtil.createElement("string", ruleset.getDecisionIdName(), true, false, doc, ruleset));
        }
        if (ruleset.trace()) {
            Element decisionTraceFilterElement = DLCommonXMLUtil.createXSDElement(doc, ruleset.XSDQName(), "element", true);
            decisionTraceFilterElement.setAttribute("ref", "filter:decisionTraceFilter");
            requestElementComplexTypeSeq.appendChild(decisionTraceFilterElement);
        }
        Element responseElement = DLCommonXMLUtil.createXSDElement(doc, ruleset.XSDQName(), "element", false);
        responseElement.setAttribute("name", ruleset.getDecisionServiceRESTResponseQName());
        schemaParameterElement.appendChild(responseElement);
        Element responseElementComplexTypeSeq = DLCommonXMLUtil.appendComplexTypeSequenceElements(responseElement, doc, ruleset);
        if (ruleset.simpleTraceElements()) {
            responseElementComplexTypeSeq.appendChild(DLCommonXMLUtil.createElement("string", ruleset.getOutputStringName(), false, false, doc, ruleset));
            responseElementComplexTypeSeq.appendChild(DLCommonXMLUtil.createElement("int", ruleset.getFiredRuleCountName(), false, false, doc, ruleset));
        }
        if (ruleset.decisionId()) {
            responseElementComplexTypeSeq.appendChild(DLCommonXMLUtil.createElement("string", ruleset.getDecisionIdName(), false, false, doc, ruleset));
        }
        if (ruleset.trace()) {
            Element executionTraceElement = DLCommonXMLUtil.createXSDElement(doc, ruleset.XSDQName(), "element", true);
            executionTraceElement.setAttribute("ref", "trace:decisionTrace");
            responseElementComplexTypeSeq.appendChild(executionTraceElement);
        }
        XSD decisionServiceXsd = new XSD(schemaParameterElement);
        decisionServiceXsd.setTargetNamespace(ruleset.TargetNamespaceQName().getNamespaceURI());
        result.put(ruleset.ParametersSchemaName(), decisionServiceXsd);
        for (XURulesetParameter xURulesetParameter : treeParameters) {
            byte direction = xURulesetParameter.getDirection();
            if (direction == 1 || direction == 4) {
                this.addParameter(requestElementComplexTypeSeq, ruleset, xURulesetParameter, arrayType2depth, false);
            }
            if (direction != 2 && direction != 4) continue;
            this.addParameter(responseElementComplexTypeSeq, ruleset, xURulesetParameter, arrayType2depth, false);
        }
        if (arrayType2depth.size() != 0) {
            XSD jaxbxsd = null;
            Object var21_25 = null;
            for (Map.Entry entry : result.entrySet()) {
                XSD xsd = (XSD)entry.getValue();
                if (xsd.getTargetNamespace() == null) continue;
                if (xsd.getTargetNamespace().equals("http://jaxb.dev.java.net/array")) {
                    jaxbxsd = xsd;
                    continue;
                }
                if (!xsd.getTargetNamespace().equals(ruleset.ParameterNamespaceQName().getNamespaceURI())) continue;
                XSD xSD = xsd;
            }
        }
        if (ruleset.inlineWSDL()) {
            result = xsdUtil.treatSameNamespaces(result, false);
        } else if (zipMergeStrategyForImport) {
            for (Map.Entry entry : ns2wrapper.entrySet()) {
                XSDWrapper wrapper = (XSDWrapper)entry.getValue();
                if (wrapper.getSchemaLocationList().size() <= 1) continue;
                String mainSchemaLocation = null;
                XSD mainXsd = null;
                for (String schemaLocation : wrapper.getSchemaLocationList()) {
                    if (mainSchemaLocation == null) {
                        mainSchemaLocation = schemaLocation;
                        mainXsd = result.get(schemaLocation);
                        continue;
                    }
                    XSD otherXsd = result.remove(schemaLocation);
                    mainXsd.setEvents(xsdUtil.mergeEvents(mainXsd.getEvents(), otherXsd.getEvents()));
                }
            }
        }
        return result;
    }

    private void declareParametersNamespaceAttributes(RulesetWrapperImpl ruleset, Element root) {
        for (Map.Entry<String, String[]> entry : ruleset.NamespaceURI2NameAndLocation().entrySet()) {
            String uri = entry.getKey();
            String name = entry.getValue()[0];
            if (uri.equals(ruleset.XSDQName().getNamespaceURI())) continue;
            if (uri.equals("")) {
                uri = ruleset.DecisionServiceDefaultNamespaceQName().getNamespaceURI();
            }
            root.setAttribute("xmlns:" + name, uri);
        }
    }

    private Map<String, XSDWrapper> declareParametersImports(RulesetWrapperImpl ruleset, Element root, boolean zipMergeStrategyForImport) throws ParserConfigurationException {
        LinkedHashMap<String, XSDWrapper> ns2wrapper = new LinkedHashMap<String, XSDWrapper>();
        for (Map.Entry<String, String[]> entry : ruleset.NamespaceURI2NameAndLocation().entrySet()) {
            String uri = entry.getKey();
            String[] values = entry.getValue();
            int loopCount = values.length / 2;
            if (ruleset.inlineWSDL()) {
                loopCount = 1;
            }
            for (int i = 0; i < loopCount; ++i) {
                String location = values[i * 2 + 1];
                if (ruleset.XSDQName().getNamespaceURI().equals(uri) || ruleset.ParameterNamespaceQName().getNamespaceURI().equals(uri)) continue;
                XSDWrapper xsdWrapper = (XSDWrapper)ns2wrapper.get(uri);
                if (xsdWrapper == null) {
                    xsdWrapper = new XSDWrapper();
                    xsdWrapper.setNamespaceUri(uri);
                    ns2wrapper.put(uri, xsdWrapper);
                }
                xsdWrapper.getSchemaLocationList().add(location);
            }
        }
        for (Map.Entry<String, Object> entry : ns2wrapper.entrySet()) {
            Element importElmt = DLCommonXMLUtil.createXSDElement(root.getOwnerDocument(), ruleset.XSDQName(), "import", false);
            importElmt.setAttribute("namespace", entry.getKey());
            if (ruleset.zipFile) {
                if (zipMergeStrategyForImport) {
                    importElmt.setAttribute("schemaLocation", ((XSDWrapper)entry.getValue()).getFirstName());
                } else {
                    importElmt.setAttribute("schemaLocation", ((XSDWrapper)entry.getValue()).getComputedName());
                }
            }
            root.appendChild(importElmt);
        }
        return ns2wrapper;
    }

    private RulesetParameterWrapperImpl getRulesetParameterWrapper(RulesetWrapperImpl ruleset, XURulesetParameter parameter) throws ResourceException, ClassNotFoundException, IOException, JAXBException {
        for (RulesetParameterWrapperImpl tmp : ruleset.RulesetParameter()) {
            if (!tmp.getRulesetParameter().getName().equals(parameter.getName())) continue;
            return tmp;
        }
        return null;
    }

    private void appendParameter(Element root, RulesetWrapperImpl ruleset, RulesetParameterWrapperImpl parameter, QName qnameType, String ref, boolean simpleJavaType, Map<QName, Integer> arrayType2depth, boolean forceQualified) throws ParserConfigurationException, ResourceException {
        String name = parameter.getRulesetParameter().getName();
        int depth = parameter.getDepth();
        QName xsdQName = ruleset.XSDQName();
        if (ref != null) {
            root.appendChild(root.getOwnerDocument().createComment(" " + name + " parameter "));
        }
        Element elt = DLCommonXMLUtil.createXSDElement(root.getOwnerDocument(), xsdQName, "element", false);
        if (depth == 0) {
            if (qnameType != null) {
                elt.setAttribute("name", name);
                if (forceQualified) {
                    elt.setAttribute("form", "qualified");
                }
                elt.setAttribute("maxOccurs", "1");
                elt.setAttribute("minOccurs", "0");
                elt.setAttribute("type", qnameType.getPrefix() + ':' + qnameType.getLocalPart());
            } else if (ref != null) {
                elt.setAttribute("ref", ref);
            }
        } else if (simpleJavaType) {
            if (depth == 1) {
                elt.setAttribute("name", name);
                elt.setAttribute("form", "qualified");
                elt.setAttribute("maxOccurs", "unbounded");
                elt.setAttribute("minOccurs", "0");
                elt.setAttribute("nillable", "true");
                elt.setAttribute("type", xsdQName.getLocalPart() + ':' + parameter.getXSDType());
            } else {
                elt.setAttribute("name", name);
                elt.setAttribute("form", "qualified");
                elt.setAttribute("maxOccurs", "unbounded");
                elt.setAttribute("minOccurs", "0");
                elt.setAttribute("nillable", "true");
                elt.setAttribute("type", ruleset.NamespaceURI2NameAndLocation().get("http://jaxb.dev.java.net/array")[0] + ':' + parameter.getXSDType() + this.repeat("Array", depth - 1));
            }
        } else if (qnameType != null) {
            elt.setAttribute("name", name);
            elt.setAttribute("maxOccurs", "unbounded");
            elt.setAttribute("minOccurs", "0");
            elt.setAttribute("nillable", "true");
            if (forceQualified) {
                elt.setAttribute("form", "qualified");
            }
            elt.setAttribute("type", qnameType.getPrefix() + ':' + qnameType.getLocalPart());
        } else if (ref != null) {
            elt.setAttribute("ref", ref);
            elt.setAttribute("maxOccurs", "unbounded");
            elt.setAttribute("minOccurs", "0");
            elt.setAttribute("nillable", "true");
        }
        root.appendChild(elt);
    }

    private String repeat(String s, int i) {
        StringBuffer result = new StringBuffer();
        for (int j = 0; j < i; ++j) {
            result.append(s);
        }
        return result.toString();
    }

    private void addParameter(Element root, RulesetWrapperImpl ruleset, XURulesetParameter parameter, Map<QName, Integer> arrayType2depth, boolean forceQualified) throws ParserConfigurationException, ResourceException, ClassNotFoundException, IOException, JAXBException {
        RulesetParameterWrapperImpl parameterWrapper = this.getRulesetParameterWrapper(ruleset, parameter);
        if (parameterWrapper.getParameterType() == 2) {
            QName qnameType = new QName(ruleset.XSDQName().getNamespaceURI(), parameterWrapper.getXSDType(), ruleset.XSDQName().getLocalPart());
            this.appendParameter(root, ruleset, parameterWrapper, qnameType, null, true, arrayType2depth, forceQualified);
        } else {
            String namespace = null;
            if (parameterWrapper.getXMLReference() != null && (namespace = parameterWrapper.getXMLReference().getNamespace()).length() == 0) {
                namespace = ruleset.DecisionServiceDefaultNamespaceQName().getNamespaceURI();
            }
            switch (parameterWrapper.getParameterType()) {
                case 1: {
                    this.appendParameter(root, ruleset, parameterWrapper, null, ruleset.NamespaceURI2NameAndLocation().get(namespace)[0] + ':' + parameterWrapper.getXMLReference().getName(), false, arrayType2depth, forceQualified);
                    break;
                }
                case 0: {
                    QName qnameType = new QName(namespace, parameterWrapper.getXMLReference().getName(), ruleset.NamespaceURI2NameAndLocation().get(namespace)[0]);
                    this.appendParameter(root, ruleset, parameterWrapper, qnameType, null, false, arrayType2depth, forceQualified);
                    break;
                }
                case 3: {
                    JAXBClassDesciption jaxbClassDesc = parameterWrapper.getJAXBClassDescription();
                    QName qnameType = new QName(jaxbClassDesc.getTypeName().getNamespaceURI(), jaxbClassDesc.getTypeName().getLocalPart(), ruleset.NamespaceURI2NameAndLocation().get(jaxbClassDesc.getTypeName().getNamespaceURI())[0]);
                    this.appendParameter(root, ruleset, parameterWrapper, qnameType, null, false, arrayType2depth, forceQualified);
                }
            }
        }
    }

    private Element createArrayType(Document doc, RulesetWrapperImpl ruleset, String name, String type) throws ParserConfigurationException {
        Element addElementComplexType = DLCommonXMLUtil.createXSDElement(doc, ruleset.XSDQName(), "complexType", false);
        addElementComplexType.setAttribute("final", "#all");
        addElementComplexType.setAttribute("name", name);
        Element addElementComplexTypeSeq = DLCommonXMLUtil.createXSDElement(doc, ruleset.XSDQName(), "sequence", false);
        addElementComplexType.appendChild(addElementComplexTypeSeq);
        Element addElementComplexTypeSeqElt = DLCommonXMLUtil.createXSDElement(doc, ruleset.XSDQName(), "element", false);
        addElementComplexTypeSeqElt.setAttribute("name", "item");
        addElementComplexTypeSeqElt.setAttribute("nillable", "true");
        addElementComplexTypeSeqElt.setAttribute("maxOccurs", "unbounded");
        addElementComplexTypeSeqElt.setAttribute("minOccurs", "0");
        addElementComplexTypeSeqElt.setAttribute("type", type);
        addElementComplexTypeSeq.appendChild(addElementComplexTypeSeqElt);
        return addElementComplexType;
    }

    public static ResourceException createResourceException(String messageKey, String[] messageParameters, Exception ex) {
        String message = LocalizedMessageHelper.getLocalizedMessage("com.ibm.rules.htds.plugin", messageKey, messageParameters, null, null);
        ResourceException exception = new ResourceException(message, messageKey);
        if (ex != null) {
            exception.initCause((Throwable)ex);
        }
        return exception;
    }
}

