/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.message.internal;

import com.ibm.rules.res.message.internal.LocalizedMessage;
import com.ibm.rules.res.message.internal.LocalizedMessageHelper;
import java.util.Locale;

public class LocalizedRuntimeException
extends RuntimeException
implements LocalizedMessage {
    private static final long serialVersionUID = 1L;
    private final String resourceBundleName;
    private final String messageCode;
    private final Object[] messageParams;

    public LocalizedRuntimeException(String message) {
        super(message);
        this.resourceBundleName = null;
        this.messageCode = null;
        this.messageParams = null;
    }

    public LocalizedRuntimeException(Throwable t) {
        super(t);
        this.resourceBundleName = null;
        this.messageCode = null;
        this.messageParams = null;
    }

    public LocalizedRuntimeException(String resourceBundleName, String messageCode, Object[] messageParams, Throwable cause) {
        super(messageCode, cause);
        this.resourceBundleName = resourceBundleName;
        this.messageCode = messageCode;
        this.messageParams = messageParams;
    }

    public LocalizedRuntimeException(String resourceBundleName, String messageCode, Object[] messageParams) {
        super(messageCode);
        this.resourceBundleName = resourceBundleName;
        this.messageCode = messageCode;
        this.messageParams = messageParams;
    }

    @Override
    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    @Override
    public String getMessageCode() {
        return this.messageCode;
    }

    @Override
    public Object[] getMessageParameters() {
        return this.messageParams;
    }

    @Override
    public String getMessage() {
        return this.getLocalizedMessage(Locale.getDefault());
    }

    @Override
    public String getLocalizedMessage(Locale locale) {
        return this.getLocalizedMessage(locale, this.getClass().getClassLoader());
    }

    public String getLocalizedMessage(Locale locale, ClassLoader cl) {
        if (this.resourceBundleName != null) {
            return LocalizedMessageHelper.getLocalizedMessage(this.resourceBundleName, this.messageCode, this.messageParams, locale, cl);
        }
        return this.messageCode;
    }
}

