/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.model.rest;

import com.ibm.rules.res.model.XOMResourceId;
import com.ibm.rules.res.model.XOMResourceInformation;
import com.ibm.rules.res.model.internal.XOMInternalNameUtil;
import com.ibm.rules.res.model.rest.Parts;
import com.ibm.rules.res.model.rest.Resource;
import com.ibm.rules.res.model.rest.io.RESTResourcesJsonDeserializer;
import com.ibm.rules.res.persistence.XOMRepositoryDAO;
import com.ibm.rules.res.persistence.internal.SHA1ChecksumProvider;
import com.ibm.rules.rest.HTTPError;
import com.ibm.rules.rest.RESTCollection;
import com.ibm.rules.rest.io.RESTCollectionJsonSerializer;
import ilog.rules.res.model.IlrPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@XmlRootElement(name="resources")
@JsonSerialize(using=RESTCollectionJsonSerializer.class)
@JsonDeserialize(using=RESTResourcesJsonDeserializer.class)
public class Resources
extends RESTCollection<XOMResourceId, Resource> {
    public static Resources DEFAULT_IN_INSTANCE;
    public static Resources DEFAULT_OUT_INSTANCE;
    private Collection<Resource> resources;
    private Collection<XOMResourceId> initialResources;
    private Parts parts;
    private XOMRepositoryDAO dao;

    public Resources() {
    }

    public Resources(XOMRepositoryDAO dao, Collection<XOMResourceId> initialResources, Locale locale, Parts parts) {
        super(locale);
        this.initialResources = initialResources;
        this.parts = parts;
        this.dao = dao;
    }

    @XmlElement(name="resource")
    public Collection<Resource> getResources() {
        if (this.resources != null) {
            return this.resources;
        }
        if (this.initialResources == null) {
            this.resources = new ArrayList<Resource>();
            return this.resources;
        }
        return this.getRESTCollection();
    }

    public void setResources(Collection<Resource> resources) {
        this.resources = resources;
    }

    @Override
    @JsonIgnore
    public Collection<XOMResourceId> getInitialCollection() {
        return this.initialResources;
    }

    @Override
    public Resource toRESTObject(XOMResourceId internalObject, Locale locale) {
        return Resources.toRESTObject(this.dao, internalObject, this.parts);
    }

    public static Resource toRESTObject(XOMRepositoryDAO dao, XOMResourceId internalObject, Parts parts) {
        if (internalObject == null) {
            return null;
        }
        Resource result = new Resource(internalObject);
        result.setId(new IlrPath(internalObject.getName(), internalObject.getVersion()).toString().substring(1));
        if (parts.isDisplayed("name")) {
            result.setName(internalObject.getName());
        }
        if (parts.isDisplayed("version") && internalObject.getVersion() != null) {
            result.setVersion(internalObject.getVersion().toString());
        }
        if (parts.isDisplayed("creationDate")) {
            result.setCreationDate(internalObject.getDate());
        }
        if (parts.isDisplayed("sha1")) {
            result.setSha1(SHA1ChecksumProvider.toHexString(internalObject.getSHA1()));
        }
        if (parts.isDisplayed("uri")) {
            result.setUri("resuri://" + XOMInternalNameUtil.getInternalName(internalObject));
        }
        if (parts.isPart("content")) {
            try {
                if (dao != null) {
                    result.setByteContent(dao.getContent(internalObject));
                } else if (internalObject instanceof XOMResourceInformation) {
                    result.setByteContent(((XOMResourceInformation)internalObject).getData());
                }
            }
            catch (Exception e) {
                throw new HTTPError(500, e);
            }
        }
        return result;
    }

    @Override
    public Collection<Resource> getForcedRESTCollection() {
        return this.resources;
    }

    static {
        ArrayList<Resource> collin = new ArrayList<Resource>();
        collin.add(Resource.DEFAULT_IN_INSTANCE);
        DEFAULT_IN_INSTANCE = new Resources();
        DEFAULT_IN_INSTANCE.setResources(collin);
        ArrayList<Resource> collout = new ArrayList<Resource>();
        collout.add(Resource.DEFAULT_OUT_INSTANCE);
        DEFAULT_OUT_INSTANCE = new Resources();
        DEFAULT_OUT_INSTANCE.setResources(collout);
    }
}

