/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.notificationserver.internal;

import com.ibm.rules.res.message.internal.XXNotificationServerMessageCode;
import com.ibm.rules.res.notificationserver.Message;
import com.ibm.rules.res.notificationserver.MessageFactory;
import com.ibm.rules.res.notificationserver.internal.DefaultMessage;
import com.ibm.rules.res.notificationserver.internal.DefaultNotificationServerClient;
import com.ibm.rules.res.notificationserver.internal.util.IoSessionHelper;
import com.ibm.rules.res.notificationserver.internal.util.LogMessageHelper;
import com.ibm.rules.res.notificationserver.internal.util.MessageDataHelper;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;

public class ClientConnectionHandler
extends IoHandlerAdapter {
    private DefaultNotificationServerClient holder = null;
    private Logger logger = null;

    public ClientConnectionHandler(DefaultNotificationServerClient theHolder, Logger theLogger) {
        if (theHolder == null || theLogger == null) {
            throw new IllegalArgumentException();
        }
        this.holder = theHolder;
        this.logger = theLogger;
    }

    public void sessionCreated(IoSession session) throws Exception {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest(LogMessageHelper.getMessage((Object)this, XXNotificationServerMessageCode.INFO_CLIENT_SESSION_CREATED, new String[]{IoSessionHelper.toString(session), this.holder.getID()}));
        }
    }

    public void sessionOpened(IoSession session) throws Exception {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest(LogMessageHelper.getMessage((Object)this, XXNotificationServerMessageCode.INFO_CLIENT_SESSION_OPENED, new String[]{IoSessionHelper.toString(session), this.holder.getID()}));
        }
        Message message = MessageFactory.getInstance().createMessage(Message.MessageType.HANDSHAKE);
        String[] data = MessageDataHelper.writeData(Message.MessageType.HANDSHAKE, null, (Serializable)new Object[]{this.holder.getID(), this.holder.getProperties()});
        message.setData(data);
        WriteFuture future = session.write((Object)DefaultMessage.serialize(message));
        future.addListener((IoFutureListener)new IoFutureListener<WriteFuture>(){

            public void operationComplete(WriteFuture future) {
                if (!future.isWritten()) {
                    if (ClientConnectionHandler.this.logger.isLoggable(Level.WARNING)) {
                        ClientConnectionHandler.this.logger.log(Level.WARNING, LogMessageHelper.getMessage((Object)this, XXNotificationServerMessageCode.WARNING_CLIENT_HANDSHAKE_FAILED, new String[]{ClientConnectionHandler.this.holder.getID()}), future.getException());
                    }
                    future.getSession().close(false);
                } else if (ClientConnectionHandler.this.logger.isLoggable(Level.INFO)) {
                    ClientConnectionHandler.this.logger.info(LogMessageHelper.getMessage((Object)this, XXNotificationServerMessageCode.INFO_CLIENT_HANDSHAKE_SUCCEEDED, new String[]{ClientConnectionHandler.this.holder.getID()}));
                }
            }
        });
    }

    public void sessionClosed(IoSession session) throws Exception {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest(LogMessageHelper.getMessage((Object)this, XXNotificationServerMessageCode.INFO_CLIENT_SESSION_CLOSED, new String[]{IoSessionHelper.toString(session), this.holder.getID()}));
        }
        if (!this.holder.isDisconnecting() && !this.holder.isDisconnected()) {
            this.holder.onUnexpectedDisconnection(session);
        }
    }

    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        if (this.logger.isLoggable(Level.WARNING)) {
            this.logger.log(Level.WARNING, LogMessageHelper.getMessage((Object)this, XXNotificationServerMessageCode.WARNING_EXCEPTION_CAUGHT_IN_CLIENT_SESSION, new String[]{IoSessionHelper.toString(session), this.holder.getID()}), cause);
        }
        session.close(true);
    }

    public void messageReceived(IoSession theSession, Object theMessage) throws Exception {
        if (theMessage != null && theMessage instanceof byte[]) {
            Message message;
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest(LogMessageHelper.getMessage((Object)this, XXNotificationServerMessageCode.INFO_MESSAGE_RECEIVED_BY_CLIENT, new String[]{IoSessionHelper.toString(theSession), this.holder.getID(), new String((byte[])theMessage, "UTF-8")}));
            }
            if (Message.MessageType.NOTIFICATION.equals((Object)(message = DefaultMessage.deserialize((byte[])theMessage)).getType())) {
                this.processNotification(theSession, message);
            } else if (Message.MessageType.REQUEST.equals((Object)message.getType())) {
                this.processRequest(theSession, message);
            } else if (this.logger.isLoggable(Level.WARNING)) {
                this.logger.warning(LogMessageHelper.getMessage((Object)this, XXNotificationServerMessageCode.WARNING_UNKNOWN_MESSAGE_TYPE_RECEIVED_BY_CLIENT, new String[]{IoSessionHelper.toString(theSession), this.holder.getID()}));
            }
        } else if (this.logger.isLoggable(Level.WARNING)) {
            this.logger.warning(LogMessageHelper.getMessage((Object)this, XXNotificationServerMessageCode.WARNING_UNKNOWN_MESSAGE_KIND_RECEIVED_BY_CLIENT, new String[]{IoSessionHelper.toString(theSession), this.holder.getID()}));
        }
    }

    public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
    }

    private void processNotification(IoSession theSession, Message theMessage) {
        block2: {
            try {
                this.holder.getNotificationHandler().onNotification(theMessage);
            }
            catch (Throwable t) {
                if (!this.logger.isLoggable(Level.SEVERE)) break block2;
                this.logger.log(Level.SEVERE, LogMessageHelper.getMessage((Object)this, XXNotificationServerMessageCode.SEVERE_ERROR_OCCURED_WHILE_CLIENT_PROCESSED_MESSAGE, new String[]{IoSessionHelper.toString(theSession), this.holder.getID()}), t);
            }
        }
    }

    private void processRequest(IoSession theSession, Message theMessage) {
        block2: {
            try {
                Serializable result = this.holder.getNotificationHandler().onRequest(theMessage);
                final Message response = MessageFactory.getInstance().createMessage(Message.MessageType.RESPONSE);
                response.setHeader(theMessage.getHeader());
                String[] responseData = MessageDataHelper.writeData(Message.MessageType.RESPONSE, theMessage.getHeader(), result);
                response.setData(responseData);
                response.setCorrelationID(theMessage.getID());
                WriteFuture future = theSession.write((Object)DefaultMessage.serialize(response));
                future.addListener((IoFutureListener)new IoFutureListener<WriteFuture>(){

                    public void operationComplete(WriteFuture future) {
                        if (future.isWritten()) {
                            if (ClientConnectionHandler.this.logger.isLoggable(Level.FINEST)) {
                                ClientConnectionHandler.this.logger.finest(LogMessageHelper.getMessage((Object)this, XXNotificationServerMessageCode.INFO_CLIENT_RESPONSE_SENT, new String[]{IoSessionHelper.toString(future.getSession()), ClientConnectionHandler.this.holder.getID(), response.getCorrelationID()}));
                            }
                        } else if (ClientConnectionHandler.this.logger.isLoggable(Level.SEVERE)) {
                            IoSession session = null;
                            try {
                                session = future.getSession();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            ClientConnectionHandler.this.logger.log(Level.SEVERE, LogMessageHelper.getMessage((Object)this, XXNotificationServerMessageCode.SEVERE_ERROR_OCCURED_WHEN_CLIENT_SENT_RESPONSE, new String[]{IoSessionHelper.toString(session), ClientConnectionHandler.this.holder.getID()}), future.getException());
                        }
                    }
                });
            }
            catch (Throwable t) {
                if (!this.logger.isLoggable(Level.SEVERE)) break block2;
                this.logger.log(Level.SEVERE, LogMessageHelper.getMessage((Object)this, XXNotificationServerMessageCode.SEVERE_ERROR_OCCURED_WHILE_CLIENT_PROCESSED_MESSAGE, new String[]{IoSessionHelper.toString(theSession), this.holder.getID()}), t);
            }
        }
    }
}

