/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.notificationserver.internal;

import com.ibm.rules.res.notificationserver.Message;
import com.ibm.rules.res.notificationserver.internal.DefaultMessage;
import java.util.Locale;

public class RESMessageFactory {
    public static final String HEADER_RULESET_UPDATE_NOTIFICATION = "RULESET_UPDATE";
    public static final String HEADER_TEST_RULESET_EXECUTION_REQUEST = "TEST_RULESET_EXECUTION";
    public static final String HEADER_DEBUG_INFOS_REQUESTS = "DEBUG_INFOS";
    public static final String HEADER_XU_LOGS_REQUEST = "XU_LOGS";
    public static final String HEADER_RULESET_LOGS_REQUEST = "RULESET_LOGS";
    public static final String HEADER_ERROR_COUNT_REQUEST = "ERROR_COUNT";
    public static final String HEADER_WARNING_COUNT_REQUEST = "WARNING_COUNT";
    public static final String HEADER_RESET_XU_LOGS_REQUEST = "RESET_XU_LOGS";
    public static final String HEADER_RESET_RULESET_LOGS_REQUEST = "RESET_RULESET_LOGS";
    public static final String HEADER_RULESET_STATISTICS_REQUEST = "RULESET_STATISTICS";
    public static final String HEADER_RESET_RULESET_STATISTICS_REQUEST = "RESET_RULESET_STATISTICS";
    private static RESMessageFactory _instance = new RESMessageFactory();

    public static RESMessageFactory getInstance() {
        return _instance;
    }

    private RESMessageFactory() {
    }

    public Message createRulesetUpdateNotification(String theCanonicalRulesetPath) {
        DefaultMessage message = new DefaultMessage(Message.MessageType.NOTIFICATION);
        message.setHeader(HEADER_RULESET_UPDATE_NOTIFICATION);
        message.setData(new String[]{theCanonicalRulesetPath});
        return message;
    }

    public Message createTestExecutionRequest(String theCanonicalRulesetPath) {
        DefaultMessage message = new DefaultMessage(Message.MessageType.REQUEST);
        message.setHeader(HEADER_TEST_RULESET_EXECUTION_REQUEST);
        message.setData(new String[]{theCanonicalRulesetPath});
        return message;
    }

    public Message createDebugInfosRequest(Locale theLocale) {
        DefaultMessage message = new DefaultMessage(Message.MessageType.REQUEST);
        message.setHeader(HEADER_DEBUG_INFOS_REQUESTS);
        message.setData(new String[]{theLocale.toString()});
        return message;
    }

    public Message createXULogsRequest(Locale theLocale) {
        DefaultMessage message = new DefaultMessage(Message.MessageType.REQUEST);
        message.setHeader(HEADER_XU_LOGS_REQUEST);
        message.setData(new String[]{theLocale.toString()});
        return message;
    }

    public Message createRulesetLogsRequest(Locale theLocale, String theCanonicalRulesetPath) {
        DefaultMessage message = new DefaultMessage(Message.MessageType.REQUEST);
        message.setHeader(HEADER_RULESET_LOGS_REQUEST);
        message.setData(new String[]{theLocale.toString(), theCanonicalRulesetPath});
        return message;
    }

    public Message createResetXULogsRequest() {
        DefaultMessage message = new DefaultMessage(Message.MessageType.REQUEST);
        message.setHeader(HEADER_RESET_XU_LOGS_REQUEST);
        return message;
    }

    public Message createResetRulesetLogsRequest(String theCanonicalRulesetPath) {
        DefaultMessage message = new DefaultMessage(Message.MessageType.REQUEST);
        message.setHeader(HEADER_RESET_RULESET_LOGS_REQUEST);
        message.setData(new String[]{theCanonicalRulesetPath});
        return message;
    }

    public Message createErrorCountRequest() {
        DefaultMessage message = new DefaultMessage(Message.MessageType.REQUEST);
        message.setHeader(HEADER_ERROR_COUNT_REQUEST);
        return message;
    }

    public Message createWarningCountRequest() {
        DefaultMessage message = new DefaultMessage(Message.MessageType.REQUEST);
        message.setHeader(HEADER_WARNING_COUNT_REQUEST);
        return message;
    }

    public Message createRulesetStatisticsRequest(String theCanonicalRulesetPath) {
        DefaultMessage message = new DefaultMessage(Message.MessageType.REQUEST);
        message.setHeader(HEADER_RULESET_STATISTICS_REQUEST);
        message.setData(new String[]{theCanonicalRulesetPath});
        return message;
    }

    public Message createResetRulesetStatisticsRequest(String theCanonicalRulesetPath) {
        DefaultMessage message = new DefaultMessage(Message.MessageType.REQUEST);
        message.setHeader(HEADER_RESET_RULESET_STATISTICS_REQUEST);
        message.setData(new String[]{theCanonicalRulesetPath});
        return message;
    }
}

