/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.notificationserver.internal;

import com.ibm.rules.res.message.internal.XXNotificationServerMessageCode;
import com.ibm.rules.res.notificationserver.Message;
import com.ibm.rules.res.notificationserver.NotificationServerClientInformation;
import com.ibm.rules.res.notificationserver.internal.DefaultMessage;
import com.ibm.rules.res.notificationserver.internal.DefaultNotificationServerClientInformation;
import com.ibm.rules.res.notificationserver.internal.ResponseMonitor;
import com.ibm.rules.res.notificationserver.internal.util.IoSessionHelper;
import com.ibm.rules.res.notificationserver.internal.util.LogMessageHelper;
import com.ibm.rules.res.notificationserver.internal.util.MessageDataHelper;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.xml.sax.SAXException;

public class ServerConnectionHandler
extends IoHandlerAdapter {
    public static final String CLIENT_ID_ATTRIBUTE = "CLIENT_ID";
    public static final String MESSAGE_VERSION = "1.0";
    private Map<String, NotificationServerClientInformation> clients = new HashMap<String, NotificationServerClientInformation>();
    private Map<String, ResponseMonitor> responseMonitors = new HashMap<String, ResponseMonitor>();
    private Logger logger = null;

    public ServerConnectionHandler(Logger theLogger) {
        if (theLogger == null) {
            throw new IllegalArgumentException();
        }
        this.logger = theLogger;
    }

    public void sessionCreated(IoSession session) throws Exception {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest(LogMessageHelper.getMessage((Object)this, XXNotificationServerMessageCode.INFO_SERVER_SESSION_CREATED, new String[]{IoSessionHelper.toString(session)}));
        }
    }

    public void sessionOpened(IoSession session) throws Exception {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest(LogMessageHelper.getMessage((Object)this, XXNotificationServerMessageCode.INFO_SERVER_SESSION_OPENED, new String[]{IoSessionHelper.toString(session)}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionClosed(IoSession session) throws Exception {
        String clientID;
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest(LogMessageHelper.getMessage((Object)this, XXNotificationServerMessageCode.INFO_SERVER_SESSION_CLOSED, new String[]{IoSessionHelper.toString(session)}));
        }
        if ((clientID = (String)session.getAttribute((Object)CLIENT_ID_ATTRIBUTE)) != null) {
            Map<String, NotificationServerClientInformation> map = this.clients;
            synchronized (map) {
                this.clients.remove(clientID);
            }
        }
    }

    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        if (this.logger.isLoggable(Level.WARNING)) {
            this.logger.log(Level.WARNING, LogMessageHelper.getMessage((Object)this, XXNotificationServerMessageCode.WARNING_EXCEPTION_CAUGHT_IN_SERVER_SESSION, new String[]{IoSessionHelper.toString(session)}), cause);
        }
        session.close(true);
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        if (message != null && message instanceof byte[]) {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest(LogMessageHelper.getMessage((Object)this, XXNotificationServerMessageCode.INFO_MESSAGE_RECEIVED_BY_SERVER, new String[]{IoSessionHelper.toString(session), new String((byte[])message, "UTF-8")}));
            }
            this.processClientMessage(session, DefaultMessage.deserialize((byte[])message));
        } else if (this.logger.isLoggable(Level.WARNING)) {
            this.logger.warning(LogMessageHelper.getMessage((Object)this, XXNotificationServerMessageCode.WARNING_UNKNOWN_MESSAGE_KIND_RECEIVED_BY_SERVER, new String[]{IoSessionHelper.toString(session)}));
        }
    }

    public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<NotificationServerClientInformation> getClientsInformation() {
        Map<String, NotificationServerClientInformation> map = this.clients;
        synchronized (map) {
            return Collections.unmodifiableCollection(this.clients.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NotificationServerClientInformation getClientInformations(String theClientID) {
        Map<String, NotificationServerClientInformation> map = this.clients;
        synchronized (map) {
            return this.clients.get(theClientID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IoSession getClientSession(String theClientID) {
        IoSession returnedValue = null;
        NotificationServerClientInformation ci = null;
        Map<String, NotificationServerClientInformation> map = this.clients;
        synchronized (map) {
            ci = this.clients.get(theClientID);
        }
        if (ci != null && ci instanceof DefaultNotificationServerClientInformation) {
            DefaultNotificationServerClientInformation dnci = (DefaultNotificationServerClientInformation)ci;
            returnedValue = dnci.getSession();
        }
        return returnedValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResponseMonitor(String theRequestID) {
        Map<String, ResponseMonitor> map = this.responseMonitors;
        synchronized (map) {
            this.responseMonitors.put(theRequestID, new ResponseMonitor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable getResponse(String theRequestID, int theTimeoutInSeconds) throws TimeoutException {
        Serializable returnedValue = null;
        boolean valueRetrieved = false;
        long endDate = new Date().getTime() + (long)(theTimeoutInSeconds * 1000);
        while (new Date().getTime() < endDate && !valueRetrieved) {
            Map<String, ResponseMonitor> map = this.responseMonitors;
            synchronized (map) {
                ResponseMonitor monitor;
                if (this.responseMonitors.containsKey(theRequestID) && ResponseMonitor.ResponseStatus.RECEIVED.equals((Object)(monitor = this.responseMonitors.get(theRequestID)).getStatus())) {
                    valueRetrieved = true;
                    returnedValue = monitor.getData();
                    this.responseMonitors.remove(theRequestID);
                }
            }
            if (valueRetrieved) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {}
        }
        if (!valueRetrieved) {
            throw new TimeoutException();
        }
        return returnedValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processClientMessage(IoSession session, Message theMessage) throws IOException, ParserConfigurationException, SAXException {
        if (!theMessage.getVersion().equals(MESSAGE_VERSION)) {
            if (this.logger.isLoggable(Level.SEVERE)) {
                this.logger.severe(LogMessageHelper.getMessage((Object)this, XXNotificationServerMessageCode.SEVERE_SEVERE_INCOMPATIBLE_CLIENT, new String[]{session.getRemoteAddress().toString()}));
            }
            return;
        }
        if (Message.MessageType.HANDSHAKE.equals((Object)theMessage.getType())) {
            Serializable[] clientInfo = (Serializable[])MessageDataHelper.readData(Message.MessageType.HANDSHAKE, null, theMessage.getData());
            String clientID = (String)((Object)clientInfo[0]);
            session.setAttribute((Object)CLIENT_ID_ATTRIBUTE, (Object)clientID);
            Properties clientProperties = (Properties)clientInfo[1];
            Map<String, NotificationServerClientInformation> map = this.clients;
            synchronized (map) {
                DefaultNotificationServerClientInformation nsci = new DefaultNotificationServerClientInformation(session);
                nsci.setClientProperties(clientProperties);
                this.clients.put(clientID, nsci);
            }
        } else if (Message.MessageType.RESPONSE.equals((Object)theMessage.getType())) {
            Map<String, ResponseMonitor> map = this.responseMonitors;
            synchronized (map) {
                if (this.responseMonitors.containsKey(theMessage.getCorrelationID())) {
                    ResponseMonitor monitor = this.responseMonitors.get(theMessage.getCorrelationID());
                    monitor.setStatus(ResponseMonitor.ResponseStatus.RECEIVED);
                    Serializable responseData = MessageDataHelper.readData(Message.MessageType.RESPONSE, theMessage.getHeader(), theMessage.getData());
                    monitor.setData(responseData);
                }
            }
        } else if (this.logger.isLoggable(Level.WARNING)) {
            this.logger.warning(LogMessageHelper.getMessage((Object)this, XXNotificationServerMessageCode.WARNING_UNKNOWN_MESSAGE_TYPE_RECEIVED_BY_SERVER, new String[]{IoSessionHelper.toString(session)}));
        }
    }
}

