/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.notificationserver.internal.util;

import com.ibm.rules.res.notificationserver.Message;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MessageDataHelper {
    private static final String LOGS_OPEN = "<logs>";
    private static final String LOGS_CLOSE = "</logs>";
    private static final String LOG_TAG = "log";
    private static final String LOG_OPEN = "<log>";
    private static final String LOG_CLOSE = "</log>";
    private static final String TIME_TAG = "time";
    private static final String TIME_OPEN = "<time>";
    private static final String TIME_CLOSE = "</time>";
    private static final String LEVEL_TAG = "level";
    private static final String LEVEL_OPEN = "<level>";
    private static final String LEVEL_CLOSE = "</level>";
    private static final String MESSAGE_TAG = "message";
    private static final String MESSAGE_OPEN = "<message>";
    private static final String MESSAGE_CLOSE = "</message>";
    private static final String STACK_TAG = "stack";
    private static final String STACK_OPEN = "<stack>";
    private static final String STACK_CLOSE = "</stack>";
    private static final String STATS_OPEN = "<stats>";
    private static final String STATS_CLOSE = "</stats>";
    private static final String STAT_TAG = "stat";
    private static final String STAT_OPEN = "<stat>";
    private static final String STAT_CLOSE = "</stat>";
    private static final String KEY_TAG = "key";
    private static final String KEY_OPEN = "<key>";
    private static final String KEY_CLOSE = "</key>";
    private static final String VALUE_TAG = "value";
    private static final String VALUE_OPEN = "<value>";
    private static final String VALUE_CLOSE = "</value>";
    private static final String LONG_ARRAY_SEP = ";";
    private static final String CDATA_OPEN = "<![CDATA[";
    private static final String CDATA_CLOSE = "]]>";

    private MessageDataHelper() {
    }

    public static String[] writeData(Message.MessageType type, String header, Serializable data) throws IOException {
        if (data == null) {
            return null;
        }
        switch (type) {
            case HANDSHAKE: {
                Object[] objs = (Object[])data;
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)os, "UTF-8");
                if (objs[1] != null) {
                    Properties props = (Properties)objs[1];
                    props.store(writer, null);
                    ((Writer)writer).flush();
                    ((Writer)writer).close();
                }
                return new String[]{(String)objs[0], os.toString("UTF-8")};
            }
            case REQUEST: {
                break;
            }
            case RESPONSE: {
                if ("TEST_RULESET_EXECUTION".equals(header) || "DEBUG_INFOS".equals(header) || "WARNING_COUNT".equals(header) || "ERROR_COUNT".equals(header) || "RESET_XU_LOGS".equals(header) || "RESET_RULESET_LOGS".equals(header) || "RESET_RULESET_STATISTICS".equals(header)) {
                    return new String[]{data.toString()};
                }
                if ("XU_LOGS".equals(header) || "RULESET_LOGS".equals(header)) {
                    Object[] logs = (Object[])data;
                    List events = (List)logs[2];
                    StringBuilder builder = new StringBuilder();
                    builder.append(LOGS_OPEN);
                    for (Object[] e : events) {
                        builder.append(LOG_OPEN);
                        builder.append(TIME_OPEN).append(e[0]).append(TIME_CLOSE);
                        builder.append(LEVEL_OPEN).append(e[1]).append(LEVEL_CLOSE);
                        builder.append(MESSAGE_OPEN).append(CDATA_OPEN).append(e[2]).append(CDATA_CLOSE).append(MESSAGE_CLOSE);
                        builder.append(STACK_OPEN).append(CDATA_OPEN).append(e[3]).append(CDATA_CLOSE).append(STACK_CLOSE);
                        builder.append(LOG_CLOSE);
                    }
                    builder.append(LOGS_CLOSE);
                    return new String[]{String.valueOf(logs[0]), String.valueOf(logs[1]), builder.toString()};
                }
                if (!"RULESET_STATISTICS".equals(header)) break;
                HashMap stats = (HashMap)data;
                StringBuilder builder = new StringBuilder();
                builder.append(STATS_OPEN);
                for (Map.Entry entry : stats.entrySet()) {
                    builder.append(STAT_OPEN);
                    builder.append(KEY_OPEN).append((String)entry.getKey()).append(KEY_CLOSE);
                    builder.append(VALUE_OPEN);
                    for (long l : (long[])entry.getValue()) {
                        builder.append(l).append(LONG_ARRAY_SEP);
                    }
                    builder.deleteCharAt(builder.length() - 1).append(VALUE_CLOSE);
                    builder.append(STAT_CLOSE);
                }
                builder.append(STATS_CLOSE);
                return new String[]{builder.toString()};
            }
            case NOTIFICATION: {
                return new String[]{(String)((Object)data)};
            }
        }
        return new String[0];
    }

    public static Serializable readData(Message.MessageType type, String header, String[] data) throws IOException, ParserConfigurationException, SAXException {
        if (data == null) {
            return null;
        }
        switch (type) {
            case HANDSHAKE: {
                Properties clientProperties = new Properties();
                InputStreamReader reader = new InputStreamReader((InputStream)new ByteArrayInputStream(data[1].getBytes()), "UTF-8");
                clientProperties.load(reader);
                ((Reader)reader).close();
                return new Serializable[]{data[0], clientProperties};
            }
            case REQUEST: {
                break;
            }
            case RESPONSE: {
                if ("TEST_RULESET_EXECUTION".equals(header) || "DEBUG_INFOS".equals(header)) {
                    return data[0];
                }
                if ("WARNING_COUNT".equals(header) || "ERROR_COUNT".equals(header)) {
                    return Long.valueOf(data[0]);
                }
                if ("RESET_XU_LOGS".equals(header) || "RESET_RULESET_LOGS".equals(header) || "RESET_RULESET_STATISTICS".equals(header)) {
                    return Boolean.valueOf(data[0]);
                }
                if ("XU_LOGS".equals(header) || "RULESET_LOGS".equals(header)) {
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    Document doc = builder.parse(new ByteArrayInputStream(data[2].getBytes()));
                    NodeList logs = doc.getElementsByTagName(LOG_TAG);
                    ArrayList<Object[]> logsData = new ArrayList<Object[]>();
                    for (int i = 0; i < logs.getLength(); ++i) {
                        Element log = (Element)logs.item(i);
                        long time = Long.valueOf(log.getElementsByTagName(TIME_TAG).item(0).getTextContent());
                        Level level = Level.parse(log.getElementsByTagName(LEVEL_TAG).item(0).getTextContent());
                        String message = log.getElementsByTagName(MESSAGE_TAG).item(0).getTextContent();
                        String stack = log.getElementsByTagName(STACK_TAG).item(0).getTextContent();
                        logsData.add(new Object[]{time, level, message, stack});
                    }
                    return new Object[]{Long.valueOf(data[0]), Long.valueOf(data[1]), logsData};
                }
                if (!"RULESET_STATISTICS".equals(header)) break;
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document doc = builder.parse(new ByteArrayInputStream(data[0].getBytes()));
                NodeList stats = doc.getElementsByTagName(STAT_TAG);
                HashMap<String, long[]> statsData = new HashMap<String, long[]>();
                for (int i = 0; i < stats.getLength(); ++i) {
                    Element stat = (Element)stats.item(i);
                    String key = stat.getElementsByTagName(KEY_TAG).item(0).getTextContent();
                    String[] valueArray = stat.getElementsByTagName(VALUE_TAG).item(0).getTextContent().split(LONG_ARRAY_SEP);
                    long[] value = new long[valueArray.length];
                    for (int j = 0; j < valueArray.length; ++j) {
                        value[j] = Long.valueOf(valueArray[j]);
                    }
                    statsData.put(key, value);
                }
                return statsData;
            }
        }
        return data;
    }

    private static String escapeInvalidXmlCharacters(String s) {
        int codePoint;
        StringBuilder returnString = new StringBuilder();
        for (int i = 0; i < s.length(); i += Character.charCount(codePoint)) {
            codePoint = s.codePointAt(i);
            if (codePoint == 9 || codePoint == 10 || codePoint == 13 || codePoint >= 32 && codePoint <= 55295 || codePoint >= 57344 && codePoint <= 65533 || codePoint >= 65536 && codePoint <= 0x10FFFF) {
                returnString.append(Character.toChars(codePoint));
                continue;
            }
            returnString.append(65533);
        }
        return returnString.toString();
    }
}

