/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.persistence.internal;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class SHA1ChecksumProvider {
    private static final int BUFFER_SIZE = 64000;

    public static String toHexString(byte[] sha1Bytes) {
        if (sha1Bytes == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        for (byte b : sha1Bytes) {
            result.append(Integer.toString((b & 0xFF) + 256, 16).substring(1));
        }
        return result.toString();
    }

    public static byte[] fromHexString(String hexString) {
        int len = hexString.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(hexString.charAt(i), 16) << 4) + Character.digit(hexString.charAt(i + 1), 16));
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] computeSHA1(InputStream stream) throws IOException, NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        BufferedInputStream input = null;
        try {
            input = new BufferedInputStream(stream, 64000);
            byte[] buffer = new byte[64000];
            int n = 0;
            while ((n = input.read(buffer)) > 0) {
                digest.update(buffer, 0, n);
            }
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {}
            }
        }
        byte[] sha1Bytes = digest.digest();
        return sha1Bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] computeSHA1(ZipInputStream zipStream) throws IOException, NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        BufferedInputStream input = null;
        try {
            ZipEntry entry = null;
            TreeSet<String> name2DigesterSet = new TreeSet<String>();
            while ((entry = zipStream.getNextEntry()) != null) {
                String crc = String.valueOf(entry.getCrc());
                if (crc.equals("-1")) {
                    int count;
                    byte[] buffer = new byte[64000];
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    BufferedOutputStream dest = new BufferedOutputStream(baos, 64000);
                    while ((count = zipStream.read(buffer, 0, 64000)) != -1) {
                        dest.write(buffer);
                    }
                    dest.flush();
                    dest.close();
                    ByteArrayInputStream is = new ByteArrayInputStream(baos.toByteArray());
                    crc = new String(SHA1ChecksumProvider.computeSHA1(is));
                    baos.close();
                    ((InputStream)is).close();
                }
                String digesterName = entry.getName() + "[" + crc + "]";
                name2DigesterSet.add(digesterName);
            }
            for (String name2Digester : name2DigesterSet) {
                byte[] data2Digester = name2Digester.getBytes("UTF-8");
                digest.update(data2Digester, 0, data2Digester.length);
            }
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {}
            }
        }
        byte[] sha1Bytes = digest.digest();
        return sha1Bytes;
    }
}

