/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.persistence.internal;

import com.ibm.rules.res.persistence.DAOException;
import com.ibm.rules.res.persistence.XOMRepositoryDAO;
import com.ibm.rules.res.persistence.XOMRepositoryDAOFactory;
import com.ibm.rules.res.persistence.internal.file.FileXOMRepositoryDAO;
import com.ibm.rules.res.persistence.internal.jdbc.DataSourceXOMDAOFactory;
import com.ibm.rules.res.persistence.internal.jdbc.DriverXOMDAOFactory;
import java.util.Properties;

public class XOMRepositoryDAOFactoryImpl
implements XOMRepositoryDAOFactory {
    public static final int NO_USERNAME_NO_PASSWORD_BLANK_VALUES_POLICY = 0;
    public static final int NO_USERNAME_NO_PASSWORD_NO_VALUES_POLICY = 1;
    protected static final String NO_USERNAME_NO_PASSWORD_NO_VALUES_POLICY_PROPERTY = "com.ibm.rules.res.persistence.noUsernameNoPasswordNoValuePolicy";
    private boolean useNoUsernameNoPasswordBlankValuePolicy = true;

    public XOMRepositoryDAOFactoryImpl() {
        String noUsernameNoPasswordNoValuePolicyProperty = System.getProperty(NO_USERNAME_NO_PASSWORD_NO_VALUES_POLICY_PROPERTY);
        if (noUsernameNoPasswordNoValuePolicyProperty != null) {
            this.useNoUsernameNoPasswordBlankValuePolicy = false;
        }
    }

    public XOMRepositoryDAOFactoryImpl(int noUsernameNoPasswordPolicy) {
        if (1 == noUsernameNoPasswordPolicy) {
            this.useNoUsernameNoPasswordBlankValuePolicy = false;
        }
    }

    @Override
    public XOMRepositoryDAO getDataSourceRepositoryDAO(boolean transactionSupport) throws DAOException {
        return this.getDataSourceRepositoryDAO(null, transactionSupport);
    }

    @Override
    public XOMRepositoryDAO getDataSourceRepositoryDAO(String jndiName, boolean transactionSupport) throws DAOException {
        return (XOMRepositoryDAO)DataSourceXOMDAOFactory.getDAO("XOMRepositoryDAODescriptor.xml", jndiName, transactionSupport);
    }

    @Override
    public XOMRepositoryDAO getDriverRepositoryDAO(ClassLoader classLoader, String driverName, String url, String user, String password) throws DAOException {
        Properties props = this.getUserPasswordProperties(user, password);
        return (XOMRepositoryDAO)DriverXOMDAOFactory.getDAO("XOMRepositoryDAODescriptor.xml", classLoader, driverName, url, props);
    }

    protected Properties getUserPasswordProperties(String user, String password) {
        Properties props = new Properties();
        if (user != null) {
            props.setProperty("user", user);
        } else if (this.useNoUsernameNoPasswordBlankValuePolicy) {
            props.setProperty("user", "");
        }
        if (password != null) {
            props.setProperty("password", password);
        } else if (this.useNoUsernameNoPasswordBlankValuePolicy) {
            props.setProperty("password", "");
        }
        return props;
    }

    @Override
    public XOMRepositoryDAO getFileRepositoryDAO() throws DAOException {
        return this.getFileRepositoryDAO(null);
    }

    @Override
    public XOMRepositoryDAO getFileRepositoryDAO(String repositoryPath) throws DAOException {
        return new FileXOMRepositoryDAO(repositoryPath);
    }
}

