/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.persistence.internal.file;

import com.ibm.rules.res.message.internal.LocalizedException;
import com.ibm.rules.res.model.MutableXOMLibraryInformation;
import com.ibm.rules.res.model.XOMLibraryId;
import com.ibm.rules.res.model.XOMRepositoryFactory;
import com.ibm.rules.res.model.XOMResourceId;
import com.ibm.rules.res.model.internal.XOMInternalNameUtil;
import com.ibm.rules.res.model.internal.XOMLibraryIdImpl;
import com.ibm.rules.res.model.internal.XOMResourceIdImpl;
import com.ibm.rules.res.persistence.DAOException;
import com.ibm.rules.res.persistence.DiagnosticResult;
import com.ibm.rules.res.persistence.Transaction;
import com.ibm.rules.res.persistence.XOMRepositoryDAO;
import com.ibm.rules.res.persistence.internal.DiagnosticResultImpl;
import com.ibm.rules.res.persistence.internal.SHA1ChecksumProvider;
import com.ibm.rules.res.persistence.internal.XOMLibraryIdPath;
import com.ibm.rules.res.persistence.internal.XOMLoadingCaller;
import com.ibm.rules.res.persistence.internal.XOMResourceIdURL;
import com.ibm.rules.res.persistence.internal.file.FileTransaction;
import com.ibm.rules.res.persistence.internal.file.XOMDir;
import com.ibm.rules.res.util.internal.StreamUtil;
import ilog.rules.res.model.IlrFormatException;
import ilog.rules.res.model.IlrPath;
import ilog.rules.res.model.IlrVersion;
import ilog.rules.res.persistence.IlrResourceNotFoundDAOException;
import ilog.rules.res.persistence.impl.IlrDAOLocalization;
import ilog.rules.res.persistence.impl.file.helper.IlrFile;
import ilog.rules.res.persistence.impl.file.security.IlrDeletePrivilegedAction;
import ilog.rules.res.persistence.impl.file.security.IlrGetCanonicalPathPrivilegedAction;
import ilog.rules.res.persistence.impl.file.security.IlrIsDirectoryPrivilegedAction;
import ilog.rules.res.persistence.impl.file.security.IlrListFilesPrivilegedAction;
import ilog.rules.res.persistence.impl.file.security.IlrMkdirsPrivilegedAction;
import ilog.rules.res.util.IlrListParser;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.ZipInputStream;

public class FileXOMRepositoryDAO
implements XOMRepositoryDAO,
XOMLoadingCaller {
    private static final String DEFAULT_XOM_REPOSITORY_PATH = "res_xom";
    private static final String REF_FILE_NAME = ".ref";
    private static final String CHECKSUM_FILE_EXTENSION = ".sha1";
    private static final String DELETED_FILE_EXTENSION = ".deleted";
    private final File repositoryDir;
    protected String repositoryPath;

    public FileXOMRepositoryDAO(String repositoryPath) throws DAOException {
        this.repositoryDir = repositoryPath != null && repositoryPath.length() > 0 ? new File(repositoryPath) : new File(DEFAULT_XOM_REPOSITORY_PATH);
        try {
            IlrMkdirsPrivilegedAction.execute(this.repositoryDir);
            this.repositoryPath = IlrGetCanonicalPathPrivilegedAction.execute(this.repositoryDir);
            if (!IlrIsDirectoryPrivilegedAction.execute(this.repositoryDir)) {
                throw IlrDAOLocalization.newDAOException(IlrDAOLocalization.ERROR_WRONG_XOM_REP_DIR, new String[]{repositoryPath});
            }
        }
        catch (PrivilegedActionException e) {
            throw IlrDAOLocalization.newDAOException(IlrDAOLocalization.ERROR_INIT_XOM_FILE_DAO, new String[]{repositoryPath}, e.getCause());
        }
    }

    @Override
    public XOMResourceId addResource(String name, IlrVersion version, InputStream data) throws DAOException, IlrResourceNotFoundDAOException {
        return this.addResource((IlrPath)null, name, version, data);
    }

    @Override
    public XOMResourceId addResource(String name, IlrVersion version, InputStream data, Transaction transaction) throws DAOException, IlrResourceNotFoundDAOException {
        return this.addResource((IlrPath)null, name, version, data);
    }

    public XOMResourceId addResource(IlrPath path, String name, IlrVersion version, InputStream data) throws DAOException, IlrResourceNotFoundDAOException {
        return this.addResource(this.getFolder(path), name, version, data);
    }

    protected File getFolder(IlrPath path) {
        if (path == null || path.getRuleAppName() == null) {
            return this.repositoryDir;
        }
        File ruleAppDir = new File(this.repositoryDir, path.getRuleAppName());
        if (path.getRuleAppVersion() == null) {
            return ruleAppDir;
        }
        File versionRADir = new File(ruleAppDir, path.getRuleAppVersion().toString());
        if (path.getRulesetName() == null) {
            return versionRADir;
        }
        File rulesetDir = new File(versionRADir, path.getRulesetName());
        if (path.getRulesetVersion() == null) {
            return rulesetDir;
        }
        return new File(rulesetDir, path.getRulesetVersion().toString());
    }

    protected XOMResourceIdURL addResource(File folder, String name, IlrVersion version, InputStream data) throws DAOException, IlrResourceNotFoundDAOException {
        File deletedFile;
        assert (name != null);
        byte[] content = null;
        XOMResourceIdURL result = null;
        byte[] sha1 = null;
        try {
            content = StreamUtil.toByteArray(data);
            sha1 = name.toLowerCase().endsWith(".zip") ? SHA1ChecksumProvider.computeSHA1(new ZipInputStream(StreamUtil.toStream(content))) : SHA1ChecksumProvider.computeSHA1(StreamUtil.toStream(content));
            result = (XOMResourceIdURL)this.isAvailable(name, sha1);
            if (result != null) {
                return result;
            }
        }
        catch (Exception e) {
            throw IlrDAOLocalization.newDAOException(IlrDAOLocalization.ERROR_XOM_UNKNOWN, e);
        }
        String nameAsFile = XOMInternalNameUtil.getNameAsFile(name, version);
        IlrMkdirsPrivilegedAction.execute(folder);
        File file = new File(folder, nameAsFile);
        result = new XOMResourceIdURL(name, version, file);
        File sha1file = new File(folder, nameAsFile + CHECKSUM_FILE_EXTENSION);
        if (file.exists() && !(deletedFile = new File(this.repositoryDir, nameAsFile + DELETED_FILE_EXTENSION)).exists()) {
            return result;
        }
        this.removeResource(result);
        try {
            XOMDir.add(file, content);
            XOMDir.add(sha1file, sha1);
        }
        catch (PrivilegedActionException e) {
            throw IlrDAOLocalization.newDAOException(IlrDAOLocalization.ERROR_ADD_XOM, new String[]{String.valueOf(result)}, e.getCause());
        }
        catch (IOException e) {
            throw IlrDAOLocalization.newDAOException(IlrDAOLocalization.ERROR_ADD_XOM, new String[]{String.valueOf(result)}, e.getCause());
        }
        return result;
    }

    @Override
    public boolean removeResource(XOMResourceId resourceId) throws DAOException, IlrResourceNotFoundDAOException {
        return this.removeResource(null, resourceId, null);
    }

    @Override
    public boolean removeResource(XOMResourceId resourceId, Transaction transaction) throws DAOException, IlrResourceNotFoundDAOException {
        return this.removeResource(null, resourceId, transaction);
    }

    public boolean removeResource(IlrPath path, XOMResourceId resourceId) throws DAOException, IlrResourceNotFoundDAOException {
        return this.removeResource(path, resourceId, null);
    }

    public boolean removeResource(IlrPath path, XOMResourceId resourceId, Transaction transaction) throws DAOException, IlrResourceNotFoundDAOException {
        String nameAsFile = XOMInternalNameUtil.getNameAsFile(resourceId.getName(), resourceId.getVersion());
        File file = new File(this.repositoryDir, nameAsFile);
        File sha1File = new File(this.repositoryDir, nameAsFile + CHECKSUM_FILE_EXTENSION);
        File deletedFile = new File(this.repositoryDir, nameAsFile + DELETED_FILE_EXTENSION);
        try {
            if (file.exists() && !IlrDeletePrivilegedAction.execute(file)) {
                XOMDir.add(deletedFile, new byte[0]);
            } else {
                IlrDeletePrivilegedAction.execute(deletedFile);
            }
            return IlrDeletePrivilegedAction.execute(sha1File);
        }
        catch (PrivilegedActionException e) {
            throw IlrDAOLocalization.newDAOException(IlrDAOLocalization.ERROR_REMOVE_XOM, new String[]{resourceId.getName()}, e.getCause());
        }
        catch (Exception e) {
            throw IlrDAOLocalization.newDAOException(IlrDAOLocalization.ERROR_REMOVE_XOM, new String[]{resourceId.getName()}, e);
        }
    }

    public XOMResourceId fromNameAsFile(File file) {
        String fileName = file.getName();
        try {
            String[] nameAndExtension = XOMInternalNameUtil.splitNameAndExtension(fileName);
            String rootName = nameAndExtension[0];
            int indexUnderscore = rootName.lastIndexOf("_");
            String initialJarName = rootName.substring(0, indexUnderscore);
            String version = rootName.substring(indexUnderscore);
            String extension = nameAndExtension[1];
            return new XOMResourceIdURL(initialJarName + (extension == null ? "" : "." + extension), XOMInternalNameUtil.toVersion(version), file);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public byte[] getContent(XOMResourceId resourceId) throws DAOException, IlrResourceNotFoundDAOException {
        String nameAsFile = XOMInternalNameUtil.getNameAsFile(resourceId.getName(), resourceId.getVersion());
        if (nameAsFile == null) {
            Set<XOMResourceId> resources = this.loadResources();
            for (XOMResourceId tmpResourceId : resources) {
                if (!tmpResourceId.getName().equals(resourceId.getName())) continue;
                return this.getContent(tmpResourceId);
            }
            return null;
        }
        File file = new File(this.repositoryDir, nameAsFile);
        File deletedFile = new File(this.repositoryDir, nameAsFile + DELETED_FILE_EXTENSION);
        try {
            if (file.exists()) {
                if (deletedFile.exists()) {
                    this.removeResource(resourceId);
                    throw IlrDAOLocalization.newDAOException(IlrDAOLocalization.ERROR_XOM_NOT_FOUND_FILE, new String[]{resourceId.getName(), this.repositoryPath});
                }
                return IlrFile.getContent(file);
            }
            throw IlrDAOLocalization.newDAOException(IlrDAOLocalization.ERROR_XOM_NOT_FOUND_FILE, new String[]{resourceId.getName(), this.repositoryPath});
        }
        catch (Exception e) {
            throw IlrDAOLocalization.newDAOException(IlrDAOLocalization.ERROR_GET_XOM, new String[]{resourceId.getName()}, e);
        }
    }

    @Override
    public XOMResourceId isAvailable(String name, byte[] sha1) throws DAOException, IlrResourceNotFoundDAOException {
        TreeSet<XOMResourceIdURL> resources = this.getResourcesWithName(name, null);
        for (XOMResourceIdURL resource : resources) {
            byte[] tmpSha1 = this.getSHA1FileContent(resource.getFile());
            if (!Arrays.equals(tmpSha1, sha1)) continue;
            return resource;
        }
        return null;
    }

    @Override
    public XOMResourceId isAvailable(String name, IlrVersion version) throws DAOException, IlrResourceNotFoundDAOException {
        TreeSet<XOMResourceIdURL> resources = this.getResourcesWithName(name, version);
        if (resources == null || resources.size() == 0) {
            return null;
        }
        XOMResourceIdURL result = null;
        if (version == null) {
            for (XOMResourceIdURL resource : resources) {
                if (!resource.getName().equals(name)) continue;
                if (result == null) {
                    result = resource;
                    continue;
                }
                IlrVersion tmpVersion = resource.getVersion();
                if (result.getVersion().compareTo(tmpVersion) >= 0) continue;
                result = resource;
            }
        } else {
            return this.getResourceInformation(name, version, resources);
        }
        return result;
    }

    @Override
    public XOMResourceId getResourceInformation(String name, IlrVersion version) throws DAOException, IlrResourceNotFoundDAOException {
        if (version == null) {
            return new XOMResourceIdImpl(name, version);
        }
        TreeSet<XOMResourceIdURL> resources = this.getResourcesWithName(name, version);
        return this.getResourceInformation(name, version, resources);
    }

    protected XOMResourceId getResourceInformation(String name, IlrVersion version, TreeSet<XOMResourceIdURL> resources) throws DAOException, IlrResourceNotFoundDAOException {
        if (resources == null || resources.size() == 0) {
            return null;
        }
        XOMResourceIdURL result = null;
        for (XOMResourceIdURL resource : resources) {
            IlrVersion tmpVersion;
            if (!resource.getName().equals(name) || !version.equals(tmpVersion = resource.getVersion())) continue;
            result = resource;
        }
        return result;
    }

    @Override
    public XOMLibraryId getLibraryInformation(String name, IlrVersion version) throws DAOException, IlrResourceNotFoundDAOException {
        if (version == null) {
            return new XOMLibraryIdImpl(name, version);
        }
        Set<XOMLibraryId> libraries = this.loadLibraries();
        if (libraries == null || libraries.size() == 0) {
            return null;
        }
        XOMLibraryId result = null;
        for (XOMLibraryId library : libraries) {
            IlrVersion tmpVersion;
            if (!library.getName().equals(name) || !version.equals(tmpVersion = library.getVersion())) continue;
            result = library;
        }
        return result;
    }

    protected byte[] getSHA1FileContent(File rootFile) {
        File sha1File = this.getSHA1File(rootFile);
        if (sha1File != null) {
            try {
                byte[] content = IlrFile.getContent(sha1File);
                return content;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return null;
    }

    protected File getSHA1File(File rootFile) {
        File sha1File = new File(rootFile.getAbsoluteFile() + CHECKSUM_FILE_EXTENSION);
        if (sha1File.exists()) {
            return sha1File;
        }
        return null;
    }

    protected TreeSet<XOMResourceIdURL> getResourcesWithName(String name, IlrVersion version) {
        int extLength;
        final String[] nameAndExtension = XOMInternalNameUtil.splitNameAndExtension(name);
        int nameLength = nameAndExtension[0].length();
        int n = extLength = nameAndExtension[1] != null ? nameAndExtension[1].length() : 0;
        if (version == null) {
            File[] files;
            TreeSet<XOMResourceIdURL> result = new TreeSet<XOMResourceIdURL>();
            for (File tmpFile : files = IlrListFilesPrivilegedAction.execute(this.repositoryDir, new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    String tmpFileName = pathname.getName();
                    if (tmpFileName.startsWith(nameAndExtension[0])) {
                        if (nameAndExtension[1] != null) {
                            return tmpFileName.endsWith(nameAndExtension[1]);
                        }
                        return true;
                    }
                    return false;
                }
            })) {
                String tmpFileName = tmpFile.getName();
                File deletedFile = new File(this.repositoryDir, tmpFileName + DELETED_FILE_EXTENSION);
                if (deletedFile.exists()) {
                    try {
                        this.removeResource(new XOMResourceIdImpl(name, version));
                    }
                    catch (Exception e) {}
                    continue;
                }
                String versionAsString = tmpFileName.substring(nameLength, tmpFileName.length() - extLength);
                IlrVersion tmpVersion = XOMInternalNameUtil.toVersion(versionAsString);
                if (tmpVersion == null) continue;
                XOMResourceIdURL tmp = new XOMResourceIdURL(name, tmpVersion, tmpFile);
                File shaFile = this.getSHA1File(tmpFile);
                tmp.setDate(new Date(shaFile.lastModified()));
                tmp.setSHA1(this.getSHA1FileContent(tmpFile));
                result.add(tmp);
            }
            return result;
        }
        String fileName = XOMInternalNameUtil.getNameAsFile(name, version);
        File tmpFile = new File(this.repositoryDir, fileName);
        File deletedFile = new File(this.repositoryDir, fileName + DELETED_FILE_EXTENSION);
        if (deletedFile.exists()) {
            try {
                this.removeResource(new XOMResourceIdImpl(name, version));
            }
            catch (Exception e) {
                // empty catch block
            }
            return null;
        }
        if (tmpFile.exists()) {
            TreeSet<XOMResourceIdURL> result = new TreeSet<XOMResourceIdURL>();
            String tmpFileName = tmpFile.getName();
            String versionAsString = tmpFileName.substring(nameLength, tmpFileName.length() - extLength);
            IlrVersion tmpVersion = XOMInternalNameUtil.toVersion(versionAsString);
            if (tmpVersion != null) {
                XOMResourceIdURL tmp = new XOMResourceIdURL(name, tmpVersion, tmpFile);
                File shaFile = this.getSHA1File(tmpFile);
                tmp.setDate(new Date(shaFile.lastModified()));
                tmp.setSHA1(this.getSHA1FileContent(tmpFile));
                result.add(tmp);
            }
            return result;
        }
        return null;
    }

    @Override
    public Transaction beginTransaction() throws DAOException {
        return new FileTransaction();
    }

    @Override
    public Set<XOMResourceId> loadResources() throws DAOException {
        return this.loadResources(this.repositoryDir, null);
    }

    @Override
    public Set<XOMResourceId> loadResources(String name) throws DAOException {
        return this.loadResources(this.repositoryDir, name);
    }

    protected Set<XOMResourceId> loadResources(File folder, final String name) throws DAOException {
        HashSet<XOMResourceId> result = new HashSet<XOMResourceId>();
        final String[] nameAndExtension = XOMInternalNameUtil.splitNameAndExtension(name);
        File[] files = IlrListFilesPrivilegedAction.execute(folder, new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname.getName().endsWith(FileXOMRepositoryDAO.CHECKSUM_FILE_EXTENSION)) {
                    return false;
                }
                if (pathname.getName().endsWith(FileXOMRepositoryDAO.DELETED_FILE_EXTENSION)) {
                    return false;
                }
                if (name == null) {
                    return true;
                }
                String tmpFileName = pathname.getName();
                if (tmpFileName.startsWith(nameAndExtension[0])) {
                    if (nameAndExtension[1] != null) {
                        return tmpFileName.endsWith(nameAndExtension[1]);
                    }
                    return true;
                }
                return false;
            }
        });
        int nameLength = 0;
        int extLength = 0;
        if (name != null) {
            nameLength = nameAndExtension[0].length();
            int n = extLength = nameAndExtension[1] != null ? nameAndExtension[1].length() : 0;
        }
        if (files != null && files.length != 0) {
            for (File file : files) {
                File shaFile;
                XOMResourceIdURL tmp;
                if (IlrIsDirectoryPrivilegedAction.execute(file)) continue;
                XOMResourceId resourceId = null;
                if (name != null) {
                    String tmpFileName = file.getName();
                    String versionAsString = tmpFileName.substring(nameLength, tmpFileName.length() - extLength);
                    IlrVersion version = XOMInternalNameUtil.toVersion(versionAsString);
                    if (version == null) continue;
                    File deletedFile = new File(file.getParent(), file.getName() + DELETED_FILE_EXTENSION);
                    resourceId = new XOMResourceIdURL(name, version, file);
                    if (resourceId != null && deletedFile.exists()) {
                        try {
                            this.removeResource(resourceId);
                        }
                        catch (Exception e) {}
                        continue;
                    }
                } else {
                    resourceId = this.fromNameAsFile(file);
                    File deletedFile = new File(file.getParent(), file.getName() + DELETED_FILE_EXTENSION);
                    if (resourceId != null && deletedFile.exists()) {
                        try {
                            this.removeResource(resourceId);
                        }
                        catch (Exception e) {}
                        continue;
                    }
                }
                if (resourceId == null) {
                    try {
                        tmp = this.migrateDragAndDroppedFile(file);
                        shaFile = this.getSHA1File(tmp.getFile());
                        tmp.setDate(new Date(shaFile.lastModified()));
                        tmp.setSHA1(this.getSHA1FileContent(tmp.getFile()));
                        result.add(tmp);
                        continue;
                    }
                    catch (IlrResourceNotFoundDAOException e) {
                        throw IlrDAOLocalization.newDAOException(IlrDAOLocalization.ERROR_UNABLE_TO_MIGRATE_FILE, new String[]{file.getName(), this.repositoryPath}, e);
                    }
                    catch (IOException e) {
                        throw IlrDAOLocalization.newDAOException(IlrDAOLocalization.ERROR_UNABLE_TO_MIGRATE_FILE, new String[]{file.getName(), this.repositoryPath}, e);
                    }
                    catch (PrivilegedActionException e) {
                        throw IlrDAOLocalization.newDAOException(IlrDAOLocalization.ERROR_UNABLE_TO_MIGRATE_FILE, new String[]{file.getName(), this.repositoryPath}, e.getCause());
                    }
                }
                if (name != null && !resourceId.getName().equals(name)) continue;
                tmp = new XOMResourceIdURL(resourceId.getName(), resourceId.getVersion(), file);
                shaFile = this.getSHA1File(file);
                if (shaFile == null) continue;
                tmp.setDate(new Date(shaFile.lastModified()));
                tmp.setSHA1(this.getSHA1FileContent(file));
                result.add(tmp);
            }
        }
        return result;
    }

    protected List<XOMResourceId> loadFiles(File folder) throws DAOException, MalformedURLException, IlrFormatException {
        ArrayList<XOMResourceId> result = new ArrayList<XOMResourceId>();
        File[] files = IlrListFilesPrivilegedAction.execute(folder, null);
        if (files != null && files.length != 0) {
            for (File file : files) {
                if (IlrIsDirectoryPrivilegedAction.execute(file)) continue;
                result.add(new XOMResourceIdURL(file.getName(), null, file));
            }
        }
        return result;
    }

    protected XOMResourceIdURL migrateDragAndDroppedFile(File file) throws IOException, IlrResourceNotFoundDAOException, DAOException, PrivilegedActionException {
        String name = file.getName();
        byte[] content = IlrFile.getContent(file);
        TreeSet<XOMResourceIdURL> resources = this.getResourcesWithName(name, null);
        IlrVersion latestVersion = resources.size() == 0 ? new IlrVersion(1, 0) : resources.last().getVersion();
        IlrVersion newVersion = XOMInternalNameUtil.nextVersion(latestVersion, false);
        XOMResourceIdURL result = this.addResource(file.getParentFile(), name, newVersion, StreamUtil.toStream(content));
        IlrDeletePrivilegedAction.execute(file);
        return result;
    }

    protected XOMResourceId getXOMResourceId(File file) {
        XOMResourceId result;
        String fileName = file.getName();
        try {
            result = XOMInternalNameUtil.getXOMResourceId(fileName);
        }
        catch (IlrFormatException e) {
            return null;
        }
        byte[] sha1 = this.getSHA1FileContent(file);
        if (sha1 == null) {
            return null;
        }
        return result;
    }

    @Override
    public String getDetails() {
        return this.repositoryPath;
    }

    @Override
    public DiagnosticResult executeDiagnostic() {
        Properties infos = new Properties();
        infos.setProperty("xomDaoClassName", this.getClass().getName());
        infos.setProperty("xomRepositoryPath", this.repositoryPath);
        return new DiagnosticResultImpl(infos, true);
    }

    @Override
    public XOMLibraryId addLibrary(String name, IlrVersion version, String[] uris) throws DAOException, IlrResourceNotFoundDAOException {
        if (uris != null && uris.length == 0) {
            uris = null;
        }
        StringBuffer content = new StringBuffer();
        File libNameDir = new File(this.repositoryDir, name);
        File libVersionDir = new File(libNameDir, version.toString());
        IlrMkdirsPrivilegedAction.execute(libVersionDir);
        File file = new File(libVersionDir, REF_FILE_NAME);
        if (uris != null) {
            for (String uri : uris) {
                try {
                    XOMInternalNameUtil.validateURL(uri);
                    content.append(uri).append(',');
                }
                catch (LocalizedException e) {
                    throw new DAOException(e);
                }
            }
            if (content.charAt(content.length() - 1) == ',') {
                content.deleteCharAt(content.length() - 1);
            }
        }
        try {
            XOMDir.add(file, content.toString().getBytes("UTF-8"));
        }
        catch (PrivilegedActionException e) {
            throw IlrDAOLocalization.newDAOException(IlrDAOLocalization.ERROR_ADD_LIB, new String[]{String.valueOf(name)}, e.getCause());
        }
        catch (IOException e) {
            throw IlrDAOLocalization.newDAOException(IlrDAOLocalization.ERROR_ADD_LIB, new String[]{String.valueOf(name)}, e.getCause());
        }
        return new XOMLibraryIdImpl(name, version);
    }

    public List<XOMResourceId> getRulesetPathContent(XOMLibraryId initialLibraryId) throws DAOException, IlrResourceNotFoundDAOException {
        if (initialLibraryId == null) {
            return null;
        }
        if (initialLibraryId instanceof XOMLibraryIdPath) {
            try {
                List<XOMResourceId> tmpRSV;
                StringBuffer loadingInfo = new StringBuffer();
                IlrPath path = ((XOMLibraryIdPath)initialLibraryId).getPath();
                ArrayList<XOMResourceId> result = new ArrayList<XOMResourceId>();
                File ruleAppDir = new File(this.repositoryDir, path.getRuleAppName());
                List<XOMResourceId> tmpRA = this.loadFiles(ruleAppDir);
                if (tmpRA != null && tmpRA.size() == 0) {
                    tmpRA = null;
                }
                File fileRAV = null;
                List<XOMResourceId> tmpRAV = null;
                if (path.getRuleAppVersion() != null && (tmpRAV = this.loadFiles(fileRAV = new File(ruleAppDir, path.getRuleAppVersion().toString()))) != null && tmpRAV.size() == 0) {
                    tmpRAV = null;
                }
                File fileRS = null;
                List<XOMResourceId> tmpRS = null;
                if (path.getRulesetName() != null && (tmpRS = this.loadFiles(fileRS = new File(fileRAV, path.getRulesetName()))) != null && tmpRS.size() == 0) {
                    tmpRS = null;
                }
                File fileRSV = null;
                boolean lastTopic = true;
                if (path.getRulesetVersion() != null && (tmpRSV = this.loadFiles(fileRSV = new File(fileRS, path.getRulesetVersion().toString()))) != null && tmpRSV.size() != 0) {
                    lastTopic = tmpRS == null && tmpRAV == null && tmpRA == null;
                    loadingInfo.append("   " + (lastTopic ? "\\" : "+") + "- /" + path.getRuleAppName() + "/" + path.getRuleAppVersion() + "/" + path.getRulesetName() + "/" + path.getRulesetVersion() + "\n");
                    int index = 0;
                    for (XOMResourceId resourceID : tmpRSV) {
                        loadingInfo.append("   " + (lastTopic ? " " : "|") + "  " + (++index == tmpRSV.size() ? "\\" : "+") + "- " + ((XOMResourceIdImpl)resourceID).getLoadingInfo() + "\n");
                        result.add(resourceID);
                    }
                }
                if (tmpRS != null) {
                    lastTopic = tmpRAV == null && tmpRA == null;
                    loadingInfo.append("   " + (lastTopic ? "\\" : "+") + "- /" + path.getRuleAppName() + "/" + path.getRuleAppVersion() + "/" + path.getRulesetName() + "\n");
                    int index = 0;
                    for (XOMResourceId resourceID : tmpRS) {
                        loadingInfo.append("   " + (lastTopic ? " " : "|") + "  " + (++index == tmpRS.size() ? "\\" : "+") + "- " + ((XOMResourceIdImpl)resourceID).getLoadingInfo() + "\n");
                        result.add(resourceID);
                    }
                }
                if (tmpRAV != null) {
                    lastTopic = tmpRA == null;
                    loadingInfo.append("   " + (lastTopic ? "\\" : "+") + "- /" + path.getRuleAppName() + "/" + path.getRuleAppVersion() + "\n");
                    int index = 0;
                    for (XOMResourceId resourceID : tmpRAV) {
                        loadingInfo.append("   " + (lastTopic ? " " : "|") + "  " + (++index == tmpRAV.size() ? "\\" : "+") + "- " + ((XOMResourceIdImpl)resourceID).getLoadingInfo() + "\n");
                        result.add(resourceID);
                    }
                }
                if (tmpRA != null) {
                    loadingInfo.append("   \\- /" + path.getRuleAppName());
                    int index = 0;
                    for (XOMResourceId resourceID : tmpRA) {
                        loadingInfo.append("      " + (++index == tmpRA.size() ? "\\" : "+") + "- " + ((XOMResourceIdImpl)resourceID).getLoadingInfo() + "\n");
                        result.add(resourceID);
                    }
                }
                if (result.size() != 0) {
                    ((XOMResourceIdImpl)result.get(0)).setLoadingInfo(loadingInfo.toString());
                }
                return result;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Set<XOMLibraryId> loadLibraries() throws DAOException {
        return this.loadLibraries(this.repositoryDir, null);
    }

    @Override
    public Set<XOMLibraryId> loadLibraries(String name) throws DAOException {
        return this.loadLibraries(this.repositoryDir, name);
    }

    protected void appendFolders(String readName, File fromFile, List<LibFolder> list, boolean skipCurrent) {
        File[] files = IlrListFilesPrivilegedAction.execute(fromFile, null);
        boolean atLeastOneFile = false;
        String name = readName;
        Date date = null;
        if (!skipCurrent) {
            if (name.length() == 0) {
                name = name + fromFile.getName();
                date = new Date(fromFile.lastModified());
            } else {
                name = name + '/' + fromFile.getName();
                date = new Date(fromFile.lastModified());
            }
        }
        if (files != null && files.length != 0) {
            for (File file : files) {
                if (IlrIsDirectoryPrivilegedAction.execute(file)) {
                    this.appendFolders(name, file, list, false);
                    continue;
                }
                atLeastOneFile = true;
            }
        }
        if (!skipCurrent && atLeastOneFile) {
            LibFolder libFolder = new LibFolder();
            libFolder.name = name;
            libFolder.date = date;
            list.add(libFolder);
        }
    }

    protected Set<XOMLibraryId> loadLibraries(File folder, String name) throws DAOException {
        HashSet<XOMLibraryId> result = new HashSet<XOMLibraryId>();
        ArrayList<LibFolder> allFolders = new ArrayList<LibFolder>();
        this.appendFolders("", folder, allFolders, true);
        for (LibFolder libFolder : allFolders) {
            try {
                XOMLibraryIdImpl libId = XOMInternalNameUtil.getXOMLibraryId(libFolder.name, libFolder.date);
                if (name != null && !libId.getName().equals(name)) continue;
                result.add(libId);
            }
            catch (Exception e) {}
        }
        return result;
    }

    @Override
    public boolean removeLibrary(XOMLibraryId library) throws DAOException, IlrResourceNotFoundDAOException {
        return this.removeLibrary(library, null);
    }

    @Override
    public boolean removeLibrary(XOMLibraryId library, Transaction transaction) throws DAOException, IlrResourceNotFoundDAOException {
        String internalName = XOMLibraryIdImpl.getInternalName(library);
        File file = new File(this.repositoryDir, internalName);
        boolean result = false;
        try {
            result = IlrDeletePrivilegedAction.execute(file);
        }
        catch (PrivilegedActionException e) {
            throw IlrDAOLocalization.newDAOException(IlrDAOLocalization.ERROR_REMOVE_LIB, new String[]{internalName}, e.getCause());
        }
        catch (Exception e) {
            throw IlrDAOLocalization.newDAOException(IlrDAOLocalization.ERROR_REMOVE_LIB, new String[]{internalName}, e);
        }
        File parentFile = file.getParentFile();
        while (!parentFile.equals(this.repositoryDir)) {
            File[] childs = IlrListFilesPrivilegedAction.execute(parentFile, null);
            if (childs.length == 0) {
                try {
                    IlrDeletePrivilegedAction.execute(parentFile);
                }
                catch (PrivilegedActionException e) {
                    throw IlrDAOLocalization.newDAOException(IlrDAOLocalization.ERROR_REMOVE_LIB, new String[]{internalName}, e.getCause());
                }
                catch (Exception e) {
                    throw IlrDAOLocalization.newDAOException(IlrDAOLocalization.ERROR_REMOVE_LIB, new String[]{internalName}, e);
                }
            }
            parentFile = parentFile.getParentFile();
        }
        return result;
    }

    @Override
    public Set<XOMLibraryId> isReferenced(String url) throws DAOException {
        LinkedHashSet<XOMLibraryId> result = new LinkedHashSet<XOMLibraryId>();
        try {
            Set<XOMLibraryId> libraries = this.loadLibraries();
            block2: for (XOMLibraryId libraryID : libraries) {
                String[] urls = this.getContent(libraryID);
                for (int i = 0; i < urls.length; ++i) {
                    if (!urls[i].equals(url)) continue;
                    result.add(libraryID);
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            throw IlrDAOLocalization.newDAOException(IlrDAOLocalization.ERROR_XOM_UNKNOWN, e);
        }
        if (result.size() != 0) {
            return result;
        }
        return null;
    }

    @Override
    public String[] getContent(XOMLibraryId libraryID) throws DAOException {
        IlrVersion resLibVersion;
        String resLibName = libraryID.getName();
        File libDir = new File(this.repositoryDir, resLibName);
        File libAndVersionDir = new File(libDir, (resLibVersion = libraryID.getVersion()).toString());
        File refFile = new File(libAndVersionDir, REF_FILE_NAME);
        if (refFile.exists()) {
            String refValue = null;
            try {
                refValue = new String(IlrFile.getContent(refFile), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                try {
                    refValue = new String(IlrFile.getContent(refFile));
                }
                catch (IOException e1) {
                    throw IlrDAOLocalization.newDAOException(IlrDAOLocalization.ERROR_READ_LIB, new String[]{refFile.toString()}, e);
                }
            }
            catch (IOException e) {
                throw IlrDAOLocalization.newDAOException(IlrDAOLocalization.ERROR_READ_LIB, new String[]{refFile.toString()}, e);
            }
            if (refValue == null || refValue.trim().equals("")) {
                return new String[0];
            }
            String[] urls = new IlrListParser().parse(refValue);
            return urls;
        }
        return new String[0];
    }

    @Override
    public XOMLibraryId addLibrary(String name, IlrVersion version, String[] uris, Transaction transaction) throws DAOException, IlrResourceNotFoundDAOException {
        return this.addLibrary(name, version, uris);
    }

    @Override
    public Set<MutableXOMLibraryInformation> loadLibraries(XOMRepositoryFactory factory) throws DAOException {
        HashSet<MutableXOMLibraryInformation> result = new HashSet<MutableXOMLibraryInformation>();
        ArrayList<LibFolder> allFolders = new ArrayList<LibFolder>();
        this.appendFolders("", this.repositoryDir, allFolders, true);
        for (LibFolder libFolder : allFolders) {
            try {
                XOMLibraryIdImpl libId = XOMInternalNameUtil.getXOMLibraryId(libFolder.name, libFolder.date);
                MutableXOMLibraryInformation lib = factory.createLibrary(libId.getName(), libId.getVersion(), libId.getDate());
                result.add(lib);
            }
            catch (Exception e) {}
        }
        return result;
    }

    protected static class LibFolder {
        String name;
        Date date;

        protected LibFolder() {
        }
    }
}

