/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.persistence.internal.jdbc.helper;

import com.ibm.rules.res.logging.internal.RESLogger;
import com.ibm.rules.res.message.internal.LocalizedException;
import com.ibm.rules.res.model.XOMResourceId;
import com.ibm.rules.res.model.internal.XOMInternalNameUtil;
import com.ibm.rules.res.persistence.DAOException;
import com.ibm.rules.res.persistence.internal.jdbc.DAOConfigurator;
import ilog.rules.res.persistence.impl.jdbc.helper.IlrDatabaseUtility;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Level;

public class LibraryValuesTable {
    private static final RESLogger LOGGER = RESLogger.getRESLogger("com.ibm.rules.res.persistence.sql", "ilog.rules.res.persistence.impl.messages");
    private static final String SQLST_SELECT_LIBRARY_VALUES = "select_library_values";
    private static final String SQLST_DELETE_LIBRARY_VALUES = "delete_library_values";
    private static final String SQLST_INSERT_LIBRARY_VALUE = "insert_library_value";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<String> get(DAOConfigurator configurator, Connection connection, int librarySQLID) throws SQLException {
        Collection<String> collection;
        String sqlStatement = configurator.getSQLStatement(SQLST_SELECT_LIBRARY_VALUES);
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            statement = connection.prepareStatement(sqlStatement);
            statement.setInt(1, librarySQLID);
            TreeMap<Integer, String> id2url = new TreeMap<Integer, String>();
            ArrayList<String> parameterValues = new ArrayList<String>();
            if (LOGGER.isLoggable(Level.FINEST)) {
                parameterValues.add(String.valueOf(librarySQLID));
            }
            rs = IlrDatabaseUtility.executeQuery(statement, sqlStatement, parameterValues);
            while (rs.next()) {
                String value = rs.getString(2);
                if (value == null) {
                    value = "";
                }
                id2url.put(rs.getInt(1), value);
            }
            collection = id2url.values();
        }
        catch (Throwable throwable) {
            IlrDatabaseUtility.closeStatement(statement);
            IlrDatabaseUtility.closeResultSet(rs);
            throw throwable;
        }
        IlrDatabaseUtility.closeStatement(statement);
        IlrDatabaseUtility.closeResultSet(rs);
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean insert(DAOConfigurator configurator, Connection connection, int librarySQLID, String url) throws SQLException {
        String sqlStatement = configurator.getSQLStatement(SQLST_INSERT_LIBRARY_VALUE);
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(sqlStatement);
            statement.setInt(1, librarySQLID);
            statement.setString(2, url);
            ArrayList<String> parameterValues = new ArrayList<String>();
            if (LOGGER.isLoggable(Level.FINEST)) {
                parameterValues.add(String.valueOf(librarySQLID));
                parameterValues.add(url);
            }
            boolean bl = IlrDatabaseUtility.executeUpdate(statement, sqlStatement, parameterValues) == 1;
            return bl;
        }
        finally {
            IlrDatabaseUtility.closeStatement(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insert(DAOConfigurator configurator, Connection connection, int librarySQLID, List<XOMResourceId> resources) throws SQLException {
        String sqlStatement = configurator.getSQLStatement(SQLST_INSERT_LIBRARY_VALUE);
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(sqlStatement);
            HashMap<Integer, List<String>> parameterValues = new HashMap<Integer, List<String>>();
            int line = 0;
            for (XOMResourceId resourceID : resources) {
                statement.setInt(1, librarySQLID);
                statement.setString(2, "resuri://" + XOMInternalNameUtil.getInternalName(resourceID));
                statement.addBatch();
                if (!LOGGER.isLoggable(Level.FINEST)) continue;
                ArrayList<String> lineValues = new ArrayList<String>();
                lineValues.add(String.valueOf(librarySQLID));
                lineValues.add("resuri://" + XOMInternalNameUtil.getInternalName(resourceID));
                parameterValues.put(line, lineValues);
                ++line;
            }
            IlrDatabaseUtility.executeBatch(statement, sqlStatement, parameterValues);
        }
        finally {
            statement.clearBatch();
            IlrDatabaseUtility.closeStatement(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insertURIs(DAOConfigurator configurator, Connection connection, int librarySQLID, String[] uris) throws SQLException, DAOException {
        String sqlStatement = configurator.getSQLStatement(SQLST_INSERT_LIBRARY_VALUE);
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(sqlStatement);
            HashMap<Integer, List<String>> parameterValues = new HashMap<Integer, List<String>>();
            int line = 0;
            for (String uri : uris) {
                try {
                    XOMInternalNameUtil.validateURL(uri);
                }
                catch (LocalizedException e) {
                    throw new DAOException(e);
                }
                statement.setInt(1, librarySQLID);
                statement.setString(2, uri);
                statement.addBatch();
                if (!LOGGER.isLoggable(Level.FINEST)) continue;
                ArrayList<String> lineValues = new ArrayList<String>();
                lineValues.add(String.valueOf(librarySQLID));
                lineValues.add(uri);
                parameterValues.put(line, lineValues);
                ++line;
            }
            IlrDatabaseUtility.executeBatch(statement, sqlStatement, parameterValues);
        }
        finally {
            statement.clearBatch();
            IlrDatabaseUtility.closeStatement(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean delete(DAOConfigurator configurator, Connection connection, int librarySQLID) throws SQLException {
        String sqlStatement = configurator.getSQLStatement(SQLST_DELETE_LIBRARY_VALUES);
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(sqlStatement);
            statement.setInt(1, librarySQLID);
            ArrayList<String> parameterValues = new ArrayList<String>();
            if (LOGGER.isLoggable(Level.FINEST)) {
                parameterValues.add(String.valueOf(librarySQLID));
            }
            boolean bl = IlrDatabaseUtility.executeUpdate(statement, sqlStatement, parameterValues) == 1;
            return bl;
        }
        finally {
            IlrDatabaseUtility.closeStatement(statement);
        }
    }
}

