/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.persistence.internal.jdbc.helper;

import com.ibm.rules.res.logging.internal.RESLogger;
import com.ibm.rules.res.model.XOMResourceId;
import com.ibm.rules.res.model.internal.XOMResourceIdImpl;
import com.ibm.rules.res.persistence.internal.SHA1ChecksumProvider;
import com.ibm.rules.res.persistence.internal.jdbc.DAOConfigurator;
import com.ibm.rules.res.util.internal.StreamUtil;
import ilog.rules.res.model.IlrFormatException;
import ilog.rules.res.model.IlrVersion;
import ilog.rules.res.persistence.impl.jdbc.helper.IlrDatabaseUtility;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;

public class ResourcesTable {
    private static final RESLogger LOGGER = RESLogger.getRESLogger("com.ibm.rules.res.persistence.sql", "ilog.rules.res.persistence.impl.messages");
    private static final String SQLST_SELECT_RESOURCES = "select_resources";
    private static final String SQLST_SELECT_RESOURCES_NAME = "select_resources_name";
    private static final String SQLST_DELETE_RESOURCE = "delete_resource";
    private static final String SQLST_INSERT_RESOURCE = "insert_resource";
    private static final String SQLST_SELECT_RESOURCE_ID = "select_resource_id";
    private static final String SQLST_SELECT_RESOURCE_ID_SHA1 = "select_resource_id_sha1";
    private static final String SQLST_SELECT_RESOURCE_ID_VERSION = "select_resource_id_version";
    private static final String SQLST_SELECT_RESOURCE_DATA = "select_resource_data";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<XOMResourceId> load(DAOConfigurator configurator, Connection connection) throws SQLException, IlrFormatException {
        String sqlStatement = configurator.getSQLStatement(SQLST_SELECT_RESOURCES);
        HashSet<XOMResourceId> result = new HashSet<XOMResourceId>();
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            statement = connection.prepareStatement(sqlStatement);
            rs = IlrDatabaseUtility.executeQuery(statement, sqlStatement, new ArrayList<String>());
            while (rs.next()) {
                XOMResourceIdImpl resource = new XOMResourceIdImpl(rs.getString(1), new IlrVersion(rs.getInt(2), rs.getInt(3)));
                resource.setSHA1(SHA1ChecksumProvider.fromHexString(rs.getString(4)));
                resource.setDate(new Date(rs.getLong(5)));
                result.add(resource);
            }
        }
        catch (Throwable throwable) {
            IlrDatabaseUtility.closeStatement(statement);
            IlrDatabaseUtility.closeResultSet(rs);
            throw throwable;
        }
        IlrDatabaseUtility.closeStatement(statement);
        IlrDatabaseUtility.closeResultSet(rs);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<XOMResourceId> load(DAOConfigurator configurator, Connection connection, String name) throws SQLException, IlrFormatException {
        String sqlStatement = configurator.getSQLStatement(SQLST_SELECT_RESOURCES_NAME);
        HashSet<XOMResourceId> result = new HashSet<XOMResourceId>();
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            statement = connection.prepareStatement(sqlStatement);
            statement.setString(1, name);
            ArrayList<String> parameterValues = new ArrayList<String>();
            if (LOGGER.isLoggable(Level.FINEST)) {
                parameterValues.add(name);
            }
            rs = IlrDatabaseUtility.executeQuery(statement, sqlStatement, parameterValues);
            while (rs.next()) {
                XOMResourceIdImpl resource = new XOMResourceIdImpl(rs.getString(1), new IlrVersion(rs.getInt(2), rs.getInt(3)));
                resource.setSHA1(SHA1ChecksumProvider.fromHexString(rs.getString(4)));
                resource.setDate(new Date(rs.getLong(5)));
                result.add(resource);
            }
        }
        catch (Throwable throwable) {
            IlrDatabaseUtility.closeStatement(statement);
            IlrDatabaseUtility.closeResultSet(rs);
            throw throwable;
        }
        IlrDatabaseUtility.closeStatement(statement);
        IlrDatabaseUtility.closeResultSet(rs);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean insert(DAOConfigurator configurator, Connection connection, String name, IlrVersion version, byte[] sha1, byte[] content) throws SQLException {
        String sqlStatement = configurator.getSQLStatement(SQLST_INSERT_RESOURCE);
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(sqlStatement);
            statement.setString(1, name);
            statement.setInt(2, version.getMajor());
            statement.setInt(3, version.getMinor());
            String sSha1 = SHA1ChecksumProvider.toHexString(sha1);
            statement.setString(4, sSha1);
            long currentTime = System.currentTimeMillis();
            statement.setLong(5, currentTime);
            statement.setBinaryStream(6, StreamUtil.toStream(content), content.length);
            ArrayList<String> parameterValues = new ArrayList<String>();
            if (LOGGER.isLoggable(Level.FINEST)) {
                parameterValues.add(name);
                parameterValues.add(String.valueOf(version.getMajor()));
                parameterValues.add(String.valueOf(version.getMinor()));
                parameterValues.add(sSha1);
                parameterValues.add(String.valueOf(currentTime));
                parameterValues.add(content.toString());
            }
            boolean bl = IlrDatabaseUtility.executeUpdate(statement, sqlStatement, parameterValues) == 1;
            return bl;
        }
        finally {
            IlrDatabaseUtility.closeStatement(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XOMResourceId getId(DAOConfigurator configurator, Connection connection, String name, byte[] sha1) throws SQLException {
        ResultSet rs;
        PreparedStatement statement;
        block4: {
            XOMResourceIdImpl xOMResourceIdImpl;
            String sqlStatement = configurator.getSQLStatement(SQLST_SELECT_RESOURCE_ID_SHA1);
            statement = null;
            rs = null;
            try {
                statement = connection.prepareStatement(sqlStatement);
                statement.setString(1, name);
                String sSha1 = SHA1ChecksumProvider.toHexString(sha1);
                statement.setString(2, sSha1);
                ArrayList<String> parameterValues = new ArrayList<String>();
                if (LOGGER.isLoggable(Level.FINEST)) {
                    parameterValues.add(name);
                    parameterValues.add(sSha1);
                }
                if (!(rs = IlrDatabaseUtility.executeQuery(statement, sqlStatement, parameterValues)).next()) break block4;
                xOMResourceIdImpl = new XOMResourceIdImpl(name, new IlrVersion(rs.getInt(1), rs.getInt(2)));
            }
            catch (Throwable throwable) {
                IlrDatabaseUtility.closeStatement(statement);
                IlrDatabaseUtility.closeResultSet(rs);
                throw throwable;
            }
            IlrDatabaseUtility.closeStatement(statement);
            IlrDatabaseUtility.closeResultSet(rs);
            return xOMResourceIdImpl;
        }
        XOMResourceId xOMResourceId = null;
        IlrDatabaseUtility.closeStatement(statement);
        IlrDatabaseUtility.closeResultSet(rs);
        return xOMResourceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XOMResourceId getId(DAOConfigurator configurator, Connection connection, String name, IlrVersion version) throws SQLException {
        ResultSet rs;
        PreparedStatement statement;
        block4: {
            XOMResourceIdImpl xOMResourceIdImpl;
            String sqlStatement = configurator.getSQLStatement(SQLST_SELECT_RESOURCE_ID_VERSION);
            statement = null;
            rs = null;
            try {
                statement = connection.prepareStatement(sqlStatement);
                statement.setString(1, name);
                statement.setInt(2, version.getMajor());
                statement.setInt(3, version.getMinor());
                ArrayList<String> parameterValues = new ArrayList<String>();
                if (LOGGER.isLoggable(Level.FINEST)) {
                    parameterValues.add(name);
                    parameterValues.add(String.valueOf(version.getMajor()));
                    parameterValues.add(String.valueOf(version.getMinor()));
                }
                if (!(rs = IlrDatabaseUtility.executeQuery(statement, sqlStatement, parameterValues)).next()) break block4;
                XOMResourceIdImpl resourceId = new XOMResourceIdImpl(name, new IlrVersion(rs.getInt(1), rs.getInt(2)));
                resourceId.setDate(new Date(rs.getLong(3)));
                resourceId.setSHA1(SHA1ChecksumProvider.fromHexString(rs.getString(4)));
                xOMResourceIdImpl = resourceId;
            }
            catch (Throwable throwable) {
                IlrDatabaseUtility.closeStatement(statement);
                IlrDatabaseUtility.closeResultSet(rs);
                throw throwable;
            }
            IlrDatabaseUtility.closeStatement(statement);
            IlrDatabaseUtility.closeResultSet(rs);
            return xOMResourceIdImpl;
        }
        XOMResourceId xOMResourceId = null;
        IlrDatabaseUtility.closeStatement(statement);
        IlrDatabaseUtility.closeResultSet(rs);
        return xOMResourceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<XOMResourceId> getId(DAOConfigurator configurator, Connection connection, String name) throws SQLException {
        HashSet<XOMResourceId> hashSet;
        String sqlStatement = configurator.getSQLStatement(SQLST_SELECT_RESOURCE_ID);
        HashSet<XOMResourceId> result = new HashSet<XOMResourceId>();
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            statement = connection.prepareStatement(sqlStatement);
            statement.setString(1, name);
            ArrayList<String> parameterValues = new ArrayList<String>();
            if (LOGGER.isLoggable(Level.FINEST)) {
                parameterValues.add(name);
            }
            rs = IlrDatabaseUtility.executeQuery(statement, sqlStatement, parameterValues);
            while (rs.next()) {
                XOMResourceIdImpl resource = new XOMResourceIdImpl(name, new IlrVersion(rs.getInt(1), rs.getInt(2)));
                result.add(resource);
            }
            hashSet = result;
        }
        catch (Throwable throwable) {
            IlrDatabaseUtility.closeStatement(statement);
            IlrDatabaseUtility.closeResultSet(rs);
            throw throwable;
        }
        IlrDatabaseUtility.closeStatement(statement);
        IlrDatabaseUtility.closeResultSet(rs);
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getData(DAOConfigurator configurator, Connection connection, String name, IlrVersion version) throws SQLException, IOException {
        ResultSet rs;
        PreparedStatement statement;
        block5: {
            InputStream stream;
            block6: {
                byte[] byArray;
                String sqlStatement = configurator.getSQLStatement(SQLST_SELECT_RESOURCE_DATA);
                statement = null;
                rs = null;
                try {
                    statement = connection.prepareStatement(sqlStatement);
                    statement.setString(1, name);
                    statement.setInt(2, version.getMajor());
                    statement.setInt(3, version.getMinor());
                    ArrayList<String> parameterValues = new ArrayList<String>();
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        parameterValues.add(name);
                        parameterValues.add(String.valueOf(version.getMajor()));
                        parameterValues.add(String.valueOf(version.getMinor()));
                    }
                    if (!(rs = IlrDatabaseUtility.executeQuery(statement, sqlStatement, parameterValues)).next()) break block5;
                    stream = rs.getBinaryStream(1);
                    if (stream != null) break block6;
                    byArray = null;
                }
                catch (Throwable throwable) {
                    IlrDatabaseUtility.closeStatement(statement);
                    IlrDatabaseUtility.closeResultSet(rs);
                    throw throwable;
                }
                IlrDatabaseUtility.closeStatement(statement);
                IlrDatabaseUtility.closeResultSet(rs);
                return byArray;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            StreamUtil.copy(stream, baos);
            byte[] byArray = baos.toByteArray();
            IlrDatabaseUtility.closeStatement(statement);
            IlrDatabaseUtility.closeResultSet(rs);
            return byArray;
        }
        byte[] byArray = null;
        IlrDatabaseUtility.closeStatement(statement);
        IlrDatabaseUtility.closeResultSet(rs);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean delete(DAOConfigurator configurator, Connection connection, String name, IlrVersion version) throws SQLException {
        String sqlStatement = configurator.getSQLStatement(SQLST_DELETE_RESOURCE);
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(sqlStatement);
            statement.setString(1, name);
            statement.setInt(2, version.getMajor());
            statement.setInt(3, version.getMinor());
            ArrayList<String> parameterValues = new ArrayList<String>();
            if (LOGGER.isLoggable(Level.FINEST)) {
                parameterValues.add(name);
                parameterValues.add(String.valueOf(version.getMajor()));
                parameterValues.add(String.valueOf(version.getMinor()));
            }
            boolean bl = IlrDatabaseUtility.executeUpdate(statement, sqlStatement, parameterValues) == 1;
            return bl;
        }
        finally {
            IlrDatabaseUtility.closeStatement(statement);
        }
    }
}

