/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.rest;

import com.ibm.rules.res.model.rest.Libraries;
import com.ibm.rules.res.model.rest.Library;
import com.ibm.rules.rest.HTTPError;
import com.ibm.rules.rest.RESTActionResult;
import com.ibm.rules.rest.RESTContext;
import com.ibm.rules.rest.annotation.ActionResultType;
import com.ibm.rules.rest.annotation.DELETE;
import com.ibm.rules.rest.annotation.Doc;
import com.ibm.rules.rest.annotation.GET;
import com.ibm.rules.rest.annotation.POST;
import com.ibm.rules.rest.annotation.PUT;
import com.ibm.rules.rest.annotation.Path;
import com.ibm.rules.rest.annotation.PathParam;
import com.ibm.rules.rest.annotation.Produces;
import com.ibm.rules.rest.annotation.QueryParam;
import com.ibm.rules.rest.annotation.RESTResource;
import com.ibm.rules.rest.annotation.RegExp;

@Path(value="libraries")
@RESTResource(name="libraries", priority=3, version="v1", since="8.0.1.0", title="TITLE_LIBRARIES", summary="SUMMARY_LIBRARIES", introduction="INTRODUCTION_LIBRARIES")
public interface LibrariesResource {
    @GET
    @Path(value="/")
    @Doc(value="GET_LIBRARIES")
    @Produces(value={"application/json", "application/xml"})
    public Libraries getLibraries(RESTContext var1, @QueryParam(value="parts") @Doc(value="LIBRARY_PARTS") String var2);

    @GET
    @Path(value="/{libraryname}")
    @Doc(value="GET_LIBRARIES_NAME")
    @Produces(value={"application/json", "application/xml"})
    public Libraries getLibrariesByName(RESTContext var1, @PathParam(value="libraryname") @Doc(value="LIBRARY_NAME") String var2, @QueryParam(value="parts") @Doc(value="LIBRARY_PARTS") String var3);

    @GET
    @Path(value="/{libraryname}/{libraryversion}")
    @Doc(value="GET_LIBRARY")
    @Produces(value={"application/json", "application/xml"})
    public Library getLibrary(RESTContext var1, @PathParam(value="libraryname") @Doc(value="LIBRARY_NAME") String var2, @PathParam(value="libraryversion") @RegExp(value="([1-9][0-9]*)\\.([0-9]+)") @Doc(value="LIBRARY_VERSION") String var3, @QueryParam(value="parts") @Doc(value="LIBRARY_PARTS") String var4);

    @GET
    @Path(value="/{libraryname}/highest")
    @Doc(value="GET_LIBRARY_HIGHEST")
    @Produces(value={"application/json", "application/xml"})
    public Library getLibraryWithHighestNumber(RESTContext var1, @PathParam(value="libraryname") @Doc(value="LIBRARY_NAME") String var2, @QueryParam(value="parts") @Doc(value="LIBRARY_PARTS") String var3);

    @POST
    @Path(value="/{libraryname}/{libraryversion}")
    @Doc(value="ADD_LIBRARY")
    @Produces(value={"application/json", "application/xml"})
    @ActionResultType(value=Library.class)
    public RESTActionResult addLibrary(RESTContext var1, @PathParam(value="libraryname") @Doc(value="LIBRARY_NAME") String var2, @PathParam(value="libraryversion") @Doc(value="LIBRARY_VERSION") String var3, @Doc(value="LIBRARY_CONTENT") String var4) throws HTTPError;

    @PUT
    @Path(value="/{libraryname}/{libraryversion}")
    @Doc(value="UPDATE_LIBRARY")
    @Produces(value={"application/json", "application/xml"})
    @ActionResultType(value=Library.class)
    public RESTActionResult updateLibrary(RESTContext var1, @PathParam(value="libraryname") @Doc(value="LIBRARY_NAME") String var2, @PathParam(value="libraryversion") @Doc(value="LIBRARY_VERSION") String var3, @Doc(value="LIBRARY_CONTENT") String var4) throws HTTPError;

    @DELETE
    @Path(value="/{libraryname}/{libraryversion}")
    @Doc(value="DELETE_LIBRARY")
    @Produces(value={"application/json", "application/xml"})
    public RESTActionResult deleteLibrary(RESTContext var1, @PathParam(value="libraryname") @Doc(value="LIBRARY_NAME") String var2, @PathParam(value="libraryversion") @RegExp(value="([1-9][0-9]*)\\.([0-9]+)") @Doc(value="LIBRARY_VERSION") String var3);
}

