/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.rest;

import com.ibm.rules.res.model.rest.DeploymentReport;
import com.ibm.rules.res.model.rest.RuleApp;
import com.ibm.rules.res.model.rest.RuleApps;
import com.ibm.rules.res.model.rest.Ruleset;
import com.ibm.rules.res.model.rest.Rulesets;
import com.ibm.rules.res.model.rest.Signature;
import com.ibm.rules.rest.HTTPError;
import com.ibm.rules.rest.RESTActionResult;
import com.ibm.rules.rest.RESTContext;
import com.ibm.rules.rest.RESTPreResponse;
import com.ibm.rules.rest.RESTProperties;
import com.ibm.rules.rest.annotation.ActionResultType;
import com.ibm.rules.rest.annotation.Consumes;
import com.ibm.rules.rest.annotation.DELETE;
import com.ibm.rules.rest.annotation.Doc;
import com.ibm.rules.rest.annotation.GET;
import com.ibm.rules.rest.annotation.POST;
import com.ibm.rules.rest.annotation.PUT;
import com.ibm.rules.rest.annotation.Path;
import com.ibm.rules.rest.annotation.PathParam;
import com.ibm.rules.rest.annotation.Produces;
import com.ibm.rules.rest.annotation.QueryParam;
import com.ibm.rules.rest.annotation.RESTResource;
import com.ibm.rules.rest.annotation.RegExp;

@Path(value="ruleapps")
@RESTResource(name="ruleapps", priority=1, version="v1", since="8.0.1.0", title="TITLE_RULEAPPS", summary="SUMMARY_RULEAPPS", introduction="INTRODUCTION_RULEAPPS")
public interface RuleAppsResource {
    @GET
    @Path(value="/")
    @Doc(value="GET_RULEAPPS")
    @Produces(value={"application/json", "application/xml"})
    public RuleApps getRuleApps(RESTContext var1, @QueryParam(value="parts") @Doc(value="RULEAPP_PARTS") String var2);

    @GET
    @Path(value="/{ruleappname}")
    @Doc(value="GET_RULEAPPS_NAME")
    @Produces(value={"application/json", "application/xml"})
    public RuleApps getRuleAppsByName(RESTContext var1, @PathParam(value="ruleappname") @Doc(value="RULEAPP_NAME") String var2, @QueryParam(value="parts") @Doc(value="RULEAPP_PARTS") String var3);

    @GET
    @Path(value="/{ruleappname}/{ruleappversion}")
    @Doc(value="GET_RULEAPP")
    @Produces(value={"application/json", "application/xml"})
    public RuleApp getRuleApp(RESTContext var1, @PathParam(value="ruleappname") @Doc(value="RULEAPP_NAME") String var2, @PathParam(value="ruleappversion") @RegExp(value="([1-9][0-9]*)\\.([0-9]+)") @Doc(value="RULEAPP_VERSION") String var3, @QueryParam(value="parts") @Doc(value="RULEAPP_PARTS") String var4);

    @GET
    @Path(value="/{ruleappname}/{ruleappversion}/notifychanges")
    @Doc(value="GET_TOUCH_RULEAPP")
    @Produces(value={"application/json", "application/xml"})
    @ActionResultType(value=RuleApp.class)
    public RESTActionResult notifyRuleAppChanges(RESTContext var1, @PathParam(value="ruleappname") @Doc(value="RULEAPP_NAME") String var2, @PathParam(value="ruleappversion") @RegExp(value="([1-9][0-9]*)\\.([0-9]+)") @Doc(value="RULEAPP_VERSION") String var3);

    @GET
    @Path(value="/{ruleappname}/highest")
    @Doc(value="GET_RULEAPP_HIGHEST")
    @Produces(value={"application/json", "application/xml"})
    public RuleApp getRuleAppWithHighestNumber(RESTContext var1, @PathParam(value="ruleappname") @Doc(value="RULEAPP_NAME") String var2, @QueryParam(value="parts") @Doc(value="RULEAPP_PARTS") String var3);

    @GET
    @Path(value="/{ruleappname}/{ruleappversion}/{rulesetname}/highest")
    @Doc(value="GET_RULESET_HIGHEST")
    @Produces(value={"application/json", "application/xml"})
    public Ruleset getRulesetWithHighestNumber(RESTContext var1, @PathParam(value="ruleappname") @Doc(value="RULEAPP_NAME") String var2, @PathParam(value="ruleappversion") @RegExp(value="([1-9][0-9]*)\\.([0-9]+)") @Doc(value="RULEAPP_VERSION") String var3, @PathParam(value="rulesetname") @Doc(value="RULESET_NAME") String var4, @QueryParam(value="parts") @Doc(value="RULESET_PARTS") String var5);

    @GET
    @Path(value="/{ruleappname}/{ruleappversion}/rulesets")
    @Doc(value="GET_RULESETS")
    @Produces(value={"application/json", "application/xml"})
    public Rulesets getRulesets(RESTContext var1, @PathParam(value="ruleappname") @Doc(value="RULEAPP_NAME") String var2, @PathParam(value="ruleappversion") @RegExp(value="([1-9][0-9]*)\\.([0-9]+)") @Doc(value="RULEAPP_VERSION") String var3, @QueryParam(value="parts") @Doc(value="RULESET_PARTS") String var4);

    @GET
    @Path(value="/{ruleappname}/{ruleappversion}/archive")
    @Doc(value="GET_RULEAPP_ARCHIVE")
    @Produces(value={"application/octet-stream"})
    public RESTPreResponse getRuleAppArchive(@PathParam(value="ruleappname") @Doc(value="RULEAPP_NAME") String var1, @PathParam(value="ruleappversion") @RegExp(value="([1-9][0-9]*)\\.([0-9]+)") @Doc(value="RULEAPP_VERSION") String var2, @QueryParam(value="filename") @Doc(value="FILE_NAME") String var3);

    @GET
    @Path(value="/{ruleappname}/{ruleappversion}/properties")
    @Doc(value="GET_RULEAPP_PROPERTIES")
    @Produces(value={"application/octet-stream"})
    public RESTProperties getRuleAppProperties(RESTContext var1, @PathParam(value="ruleappname") @Doc(value="RULEAPP_NAME") String var2, @PathParam(value="ruleappversion") @RegExp(value="([1-9][0-9]*)\\.([0-9]+)") @Doc(value="RULEAPP_VERSION") String var3);

    @GET
    @Path(value="/{ruleappname}/{ruleappversion}/{rulesetname}")
    @Doc(value="GET_RULESETS_NAME")
    @Produces(value={"application/json", "application/xml"})
    public Rulesets getRulesetsByName(RESTContext var1, @PathParam(value="ruleappname") @Doc(value="RULEAPP_NAME") String var2, @PathParam(value="ruleappversion") @RegExp(value="([1-9][0-9]*)\\.([0-9]+)") @Doc(value="RULEAPP_VERSION") String var3, @PathParam(value="rulesetname") @Doc(value="RULESET_NAME") String var4, @QueryParam(value="parts") @Doc(value="RULESET_PARTS") String var5);

    @GET
    @Path(value="/{ruleappname}/{ruleappversion}/{rulesetname}/{rulesetversion}")
    @Doc(value="GET_RULESET")
    @Produces(value={"application/json", "application/xml"})
    public Ruleset getRuleset(RESTContext var1, @PathParam(value="ruleappname") @Doc(value="RULEAPP_NAME") String var2, @PathParam(value="ruleappversion") @RegExp(value="([1-9][0-9]*)\\.([0-9]+)") @Doc(value="RULEAPP_VERSION") String var3, @PathParam(value="rulesetname") @Doc(value="RULESET_NAME") String var4, @PathParam(value="rulesetversion") @RegExp(value="([1-9][0-9]*)\\.([0-9]+)") @Doc(value="RULESET_VERSION") String var5, @QueryParam(value="parts") @Doc(value="RULESET_PARTS") String var6);

    @GET
    @Path(value="/{ruleappname}/{ruleappversion}/{rulesetname}/{rulesetversion}/notifychanges")
    @Doc(value="GET_TOUCH_RULESET")
    @Produces(value={"application/json", "application/xml"})
    @ActionResultType(value=Ruleset.class)
    public RESTActionResult notifyRulesetChanges(RESTContext var1, @PathParam(value="ruleappname") @Doc(value="RULEAPP_NAME") String var2, @PathParam(value="ruleappversion") @RegExp(value="([1-9][0-9]*)\\.([0-9]+)") @Doc(value="RULEAPP_VERSION") String var3, @PathParam(value="rulesetname") @Doc(value="RULESET_NAME") String var4, @PathParam(value="rulesetversion") @RegExp(value="([1-9][0-9]*)\\.([0-9]+)") @Doc(value="RULESET_VERSION") String var5);

    @GET
    @Path(value="/{ruleappname}/{ruleappversion}/{rulesetname}/{rulesetversion}/archive")
    @Doc(value="GET_RULESET_ARCHIVE")
    @Produces(value={"application/octet-stream"})
    public RESTPreResponse getRulesetArchive(RESTContext var1, @PathParam(value="ruleappname") @Doc(value="RULEAPP_NAME") String var2, @PathParam(value="ruleappversion") @RegExp(value="([1-9][0-9]*)\\.([0-9]+)") @Doc(value="RULEAPP_VERSION") String var3, @PathParam(value="rulesetname") @Doc(value="RULESET_NAME") String var4, @PathParam(value="rulesetversion") @RegExp(value="([1-9][0-9]*)\\.([0-9]+)") @Doc(value="RULESET_VERSION") String var5, @QueryParam(value="filename") @Doc(value="FILE_NAME") String var6);

    @GET
    @Path(value="/{ruleappname}/{ruleappversion}/{rulesetname}/{rulesetversion}/xoms")
    @Doc(value="GET_RULESET_XOMS")
    @Produces(value={"application/octet-stream"})
    public RESTPreResponse getRulesetXOMs(RESTContext var1, @PathParam(value="ruleappname") @Doc(value="RULEAPP_NAME") String var2, @PathParam(value="ruleappversion") @RegExp(value="([1-9][0-9]*)\\.([0-9]+)") @Doc(value="RULEAPP_VERSION") String var3, @PathParam(value="rulesetname") @Doc(value="RULESET_NAME") String var4, @PathParam(value="rulesetversion") @RegExp(value="([1-9][0-9]*)\\.([0-9]+)") @Doc(value="RULESET_VERSION") String var5, @QueryParam(value="filename") @Doc(value="FILE_NAME") String var6);

    @GET
    @Path(value="/{ruleappname}/{ruleappversion}/{rulesetname}/{rulesetversion}/properties")
    @Doc(value="GET_RULESET_PROPERTIES")
    @Produces(value={"application/json", "application/xml"})
    public RESTProperties getRulesetProperties(RESTContext var1, @PathParam(value="ruleappname") @Doc(value="RULEAPP_NAME") String var2, @PathParam(value="ruleappversion") @RegExp(value="([1-9][0-9]*)\\.([0-9]+)") @Doc(value="RULEAPP_VERSION") String var3, @PathParam(value="rulesetname") @Doc(value="RULESET_NAME") String var4, @PathParam(value="rulesetversion") @RegExp(value="([1-9][0-9]*)\\.([0-9]+)") @Doc(value="RULESET_VERSION") String var5);

    @GET
    @Path(value="/{ruleappname}/{ruleappversion}/{rulesetname}/{rulesetversion}/signature")
    @Doc(value="GET_RULESET_SIGNATURE")
    @Produces(value={"application/json", "application/xml"})
    public Signature getRulesetSignature(RESTContext var1, @PathParam(value="ruleappname") @Doc(value="RULEAPP_NAME") String var2, @PathParam(value="ruleappversion") @RegExp(value="([1-9][0-9]*)\\.([0-9]+)") @Doc(value="RULEAPP_VERSION") String var3, @PathParam(value="rulesetname") @Doc(value="RULESET_NAME") String var4, @PathParam(value="rulesetversion") @RegExp(value="([1-9][0-9]*)\\.([0-9]+)") @Doc(value="RULESET_VERSION") String var5);

    @POST
    @Path(value="/")
    @Doc(value="ADD_RULEAPP")
    @Produces(value={"application/json", "application/xml"})
    @ActionResultType(value=RuleApp.class)
    public RESTActionResult addRuleApp(RESTContext var1, RuleApp var2) throws HTTPError;

    @POST
    @Path(value="/")
    @Doc(value="ADD_RULEAPP_ARCHIVE")
    @Produces(value={"application/json", "application/xml"})
    @Consumes(value={"application/octet-stream"})
    @ActionResultType(value=DeploymentReport.class)
    public RESTActionResult deployRuleAppArchive(RESTContext var1, @QueryParam(value="merging") @Doc(value="MERGING_POLICY") String var2, @QueryParam(value="version") @Doc(value="VERSION_POLICY") String var3, @Doc(value="RULEAPP_ARCHIVE") byte[] var4) throws HTTPError;

    @POST
    @Path(value="/{ruleappname}/{ruleappversion}/properties/{propertyname}")
    @Doc(value="ADD_RULEAPP_PROPERTY")
    @Produces(value={"application/json", "application/xml"})
    @ActionResultType(value=RuleApp.class)
    public RESTActionResult addRuleAppProperty(RESTContext var1, @PathParam(value="ruleappname") @Doc(value="RULEAPP_NAME") String var2, @PathParam(value="ruleappversion") @RegExp(value="([1-9][0-9]*)\\.([0-9]+)") @Doc(value="RULEAPP_VERSION") String var3, @PathParam(value="propertyname") @Doc(value="RULEAPP_PROPERTY_NAME") String var4, @Doc(value="RULEAPP_PROPERTY_VALUE") String var5) throws HTTPError;

    @POST
    @Path(value="/{ruleappname}/{ruleappversion}/rulesets")
    @Doc(value="ADD_RULESET")
    @Produces(value={"application/json", "application/xml"})
    @ActionResultType(value=Ruleset.class)
    public RESTActionResult addRuleset(RESTContext var1, @PathParam(value="ruleappname") @Doc(value="RULEAPP_NAME") String var2, @PathParam(value="ruleappversion") @RegExp(value="([1-9][0-9]*)\\.([0-9]+)") @Doc(value="RULEAPP_VERSION") String var3, Ruleset var4) throws HTTPError;

    @POST
    @Path(value="/{ruleappname}/{ruleappversion}/{rulesetname}/{rulesetversion}/properties/{propertyname}")
    @Doc(value="ADD_RULESET_PROPERTY")
    @Produces(value={"application/json", "application/xml"})
    @ActionResultType(value=Ruleset.class)
    public RESTActionResult addRulesetProperty(RESTContext var1, @PathParam(value="ruleappname") @Doc(value="RULEAPP_NAME") String var2, @PathParam(value="ruleappversion") @RegExp(value="([1-9][0-9]*)\\.([0-9]+)") @Doc(value="RULEAPP_VERSION") String var3, @PathParam(value="rulesetname") @Doc(value="RULESET_NAME") String var4, @PathParam(value="rulesetversion") @RegExp(value="([1-9][0-9]*)\\.([0-9]+)") @Doc(value="RULESET_VERSION") String var5, @PathParam(value="propertyname") @Doc(value="RULESET_PROPERTY_NAME") String var6, @Doc(value="RULESET_PROPERTY_VALUE") String var7) throws HTTPError;

    @POST
    @Path(value="/{ruleappname}/{ruleappversion}/{rulesetname}/{rulesetversion}")
    @Doc(value="ADD_RULESET_ARCHIVE")
    @Produces(value={"application/json", "application/xml"})
    @ActionResultType(value=Ruleset.class)
    public RESTActionResult deployRulesetArchive(RESTContext var1, @PathParam(value="ruleappname") @Doc(value="RULEAPP_NAME") String var2, @PathParam(value="ruleappversion") @RegExp(value="([1-9][0-9]*)\\.([0-9]+)") @Doc(value="RULEAPP_VERSION") String var3, @PathParam(value="rulesetname") @Doc(value="RULESET_NAME") String var4, @PathParam(value="rulesetversion") @RegExp(value="([1-9][0-9]*)\\.([0-9]+)") @Doc(value="RULESET_VERSION") String var5, @Doc(value="RULESET_ARCHIVE") byte[] var6) throws HTTPError;

    @PUT
    @Path(value="/{ruleappname}/{ruleappversion}")
    @Doc(value="UPDATE_RULEAPP")
    @Produces(value={"application/json", "application/xml"})
    @ActionResultType(value=RuleApp.class)
    public RESTActionResult updateRuleApp(RESTContext var1, @PathParam(value="ruleappname") @Doc(value="RULEAPP_NAME") String var2, @PathParam(value="ruleappversion") @RegExp(value="([1-9][0-9]*)\\.([0-9]+)") @Doc(value="RULEAPP_VERSION") String var3, RuleApp var4);

    @PUT
    @Path(value="/{ruleappname}/{ruleappversion}/properties/{propertyname}")
    @Doc(value="UPDATE_RULEAPP_PROPERTY")
    @Produces(value={"application/json", "application/xml"})
    public RESTActionResult updateRuleAppProperty(RESTContext var1, @PathParam(value="ruleappname") @Doc(value="RULEAPP_NAME") String var2, @PathParam(value="ruleappversion") @RegExp(value="([1-9][0-9]*)\\.([0-9]+)") @Doc(value="RULEAPP_VERSION") String var3, @PathParam(value="propertyname") @Doc(value="RULEAPP_PROPERTY_NAME") String var4, @Doc(value="RULEAPP_PROPERTY_VALUE") String var5);

    @PUT
    @Path(value="/{ruleappname}/{ruleappversion}/{rulesetname}/{rulesetversion}")
    @Doc(value="UPDATE_RULESET")
    @Produces(value={"application/json", "application/xml"})
    @ActionResultType(value=Ruleset.class)
    public RESTActionResult updateRuleset(RESTContext var1, @PathParam(value="ruleappname") @Doc(value="RULEAPP_NAME") String var2, @PathParam(value="ruleappversion") @RegExp(value="([1-9][0-9]*)\\.([0-9]+)") @Doc(value="RULEAPP_VERSION") String var3, @PathParam(value="rulesetname") @Doc(value="RULESET_NAME") String var4, @PathParam(value="rulesetversion") @RegExp(value="([1-9][0-9]*)\\.([0-9]+)") @Doc(value="RULESET_VERSION") String var5, Ruleset var6);

    @PUT
    @Path(value="/{ruleappname}/{ruleappversion}/{rulesetname}/{rulesetversion}/properties/{propertyname}")
    @Doc(value="UPDATE_RULESET_PROPERTY")
    @Produces(value={"application/json", "application/xml"})
    public RESTActionResult updateRulesetProperty(RESTContext var1, @PathParam(value="ruleappname") @Doc(value="RULEAPP_NAME") String var2, @PathParam(value="ruleappversion") @RegExp(value="([1-9][0-9]*)\\.([0-9]+)") @Doc(value="RULEAPP_VERSION") String var3, @PathParam(value="rulesetname") @Doc(value="RULESET_NAME") String var4, @PathParam(value="rulesetversion") @RegExp(value="([1-9][0-9]*)\\.([0-9]+)") @Doc(value="RULESET_VERSION") String var5, @PathParam(value="propertyname") @Doc(value="RULESET_PROPERTY_NAME") String var6, @Doc(value="RULESET_PROPERTY_VALUE") String var7);

    @PUT
    @Path(value="/{ruleappname}/{ruleappversion}/{rulesetname}/{rulesetversion}/archive")
    @Doc(value="UPDATE_RULESET_ARCHIVE")
    @Produces(value={"application/json", "application/xml"})
    @ActionResultType(value=Ruleset.class)
    public RESTActionResult updateRulesetArchive(RESTContext var1, @PathParam(value="ruleappname") @Doc(value="RULEAPP_NAME") String var2, @PathParam(value="ruleappversion") @RegExp(value="([1-9][0-9]*)\\.([0-9]+)") @Doc(value="RULEAPP_VERSION") String var3, @PathParam(value="rulesetname") @Doc(value="RULESET_NAME") String var4, @PathParam(value="rulesetversion") @RegExp(value="([1-9][0-9]*)\\.([0-9]+)") @Doc(value="RULESET_VERSION") String var5, @Doc(value="RULESET_ARCHIVE") byte[] var6) throws HTTPError;

    @DELETE
    @Path(value="/{ruleappname}/{ruleappversion}")
    @Doc(value="DELETE_RULEAPP")
    @Produces(value={"application/json", "application/xml"})
    public RESTActionResult deleteRuleApp(RESTContext var1, @PathParam(value="ruleappname") @Doc(value="RULEAPP_NAME") String var2, @PathParam(value="ruleappversion") @RegExp(value="([1-9][0-9]*)\\.([0-9]+)") @Doc(value="RULEAPP_VERSION") String var3);

    @DELETE
    @Path(value="/{ruleappname}/{ruleappversion}/properties/{propertyname}")
    @Doc(value="DELETE_RULEAPP_PROPERTY")
    @Produces(value={"application/json", "application/xml"})
    public RESTActionResult deleteRuleAppProperty(RESTContext var1, @PathParam(value="ruleappname") @Doc(value="RULEAPP_NAME") String var2, @PathParam(value="ruleappversion") @RegExp(value="([1-9][0-9]*)\\.([0-9]+)") @Doc(value="RULEAPP_VERSION") String var3, @PathParam(value="propertyname") @Doc(value="RULEAPP_PROPERTY_NAME") String var4);

    @DELETE
    @Path(value="/{ruleappname}/{ruleappversion}/{rulesetname}/{rulesetversion}")
    @Doc(value="DELETE_RULESET")
    @Produces(value={"application/json", "application/xml"})
    public RESTActionResult deleteRuleset(RESTContext var1, @PathParam(value="ruleappname") @Doc(value="RULEAPP_NAME") String var2, @PathParam(value="ruleappversion") @RegExp(value="([1-9][0-9]*)\\.([0-9]+)") @Doc(value="RULEAPP_VERSION") String var3, @PathParam(value="rulesetname") @Doc(value="RULESET_NAME") String var4, @PathParam(value="rulesetversion") @RegExp(value="([1-9][0-9]*)\\.([0-9]+)") @Doc(value="RULESET_VERSION") String var5);

    @DELETE
    @Path(value="/{ruleappname}/{ruleappversion}/{rulesetname}/{rulesetversion}/properties/{propertyname}")
    @Doc(value="DELETE_RULESET_PROPERTY")
    @Produces(value={"application/json", "application/xml"})
    public RESTActionResult deleteRulesetProperty(RESTContext var1, @PathParam(value="ruleappname") @Doc(value="RULEAPP_NAME") String var2, @PathParam(value="ruleappversion") @RegExp(value="([1-9][0-9]*)\\.([0-9]+)") @Doc(value="RULEAPP_VERSION") String var3, @PathParam(value="rulesetname") @Doc(value="RULESET_NAME") String var4, @PathParam(value="rulesetversion") @RegExp(value="([1-9][0-9]*)\\.([0-9]+)") @Doc(value="RULESET_VERSION") String var5, @PathParam(value="propertyname") @Doc(value="RULESET_PROPERTY_NAME") String var6);
}

