/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.util.internal;

import java.text.StringCharacterIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
    protected static final String EXCL = "\\\\:*?\"|<>,";
    protected static final Pattern PATTERN_NAME_AND_EXTENSION = Pattern.compile("([^\\\\:*?\"|<>,/ ](?:[^\\\\:*?\"|<>,/ ]|[^\\\\:*?\"|<>,/]*[^\\\\:*?\"|<>,/])?)\\.([_\\p{javaLetterOrDigit}]*)");
    protected static final Pattern PATTERN_VERSION = Pattern.compile("_([1-9][0-9]*)\\.([0-9]+)\\.?");
    protected static final Pattern PATTERN_WITHOUT_VERSION = Pattern.compile("([^\\\\:*?\"|<>, ](?:[^\\\\:*?\"|<>, ]|[^\\\\:*?\"|<>,]*[^\\\\:*?\"|<>,])?)");
    protected static final Pattern PATTERN_WITH_VERSION = Pattern.compile("([^\\\\:*?\"|<>, ](?:[^\\\\:*?\"|<>, ]|[^\\\\:*?\"|<>,]*[^\\\\:*?\"|<>,])?)/(([1-9][0-9]*)\\.([0-9]+))");

    public static String[] splitNameAndExtension(String resourceName) {
        if (resourceName == null) {
            return null;
        }
        Matcher m = PATTERN_NAME_AND_EXTENSION.matcher(resourceName);
        if (!m.matches()) {
            return new String[]{resourceName, null};
        }
        return new String[]{m.group(1), m.group(2)};
    }

    public static String escapeHTMLString(String str) {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(str);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '<') {
                result.append("&lt;");
            } else if (character == '>') {
                result.append("&gt;");
            } else if (character == '&') {
                result.append("&amp;");
            } else if (character == '\"') {
                result.append("&quot;");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }
}

